/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.SystemVersion;

class ExploratoryPeerSelector
extends TunnelPeerSelector {
    private static final int MIN_NONFAILING_PCT = 15;
    private static final int MIN_ACTIVE_PEERS_STARTUP = 6;
    private static final int MIN_ACTIVE_PEERS = 12;

    public ExploratoryPeerSelector(RouterContext context) {
        super(context);
    }

    @Override
    public List<Hash> selectPeers(TunnelPoolSettings settings) {
        ArrayList<Hash> rv;
        int length = this.getLength(settings);
        if (length < 0) {
            if (this.log.shouldLog(10)) {
                this.log.debug("Length requested is zero: " + settings);
            }
            return null;
        }
        boolean isInbound = settings.isInbound();
        Set<Hash> exclude = this.getExclude(isInbound, true);
        exclude.add(this.ctx.routerHash());
        boolean nonzero = length > 0;
        boolean exploreHighCap = nonzero && this.shouldPickHighCap();
        boolean v6Only = nonzero && this.isIPv6Only();
        boolean ntcpDisabled = nonzero && this.isNTCPDisabled();
        boolean ssuDisabled = nonzero && this.isSSUDisabled();
        boolean checkClosestHop = v6Only || ntcpDisabled || ssuDisabled;
        boolean hidden = nonzero && (this.ctx.router().isHidden() || this.ctx.router().getRouterInfo().getAddressCount() <= 0 || !this.ctx.commSystem().haveInboundCapacity(95));
        boolean hiddenInbound = hidden && isInbound;
        boolean hiddenOutbound = hidden && !isInbound;
        boolean lowOutbound = nonzero && !isInbound && !this.ctx.commSystem().haveHighOutboundCapacity();
        Hash closestHop = null;
        if (v6Only || hiddenInbound || lowOutbound) {
            Set<Hash> closestExclude;
            if (checkClosestHop) {
                closestExclude = this.getClosestHopExclude(isInbound);
                if (closestExclude != null) {
                    closestExclude.addAll(exclude);
                } else {
                    closestExclude = exclude;
                }
            } else {
                closestExclude = exclude;
            }
            HashSet<Hash> closest = new HashSet<Hash>(1);
            if (hiddenInbound || lowOutbound) {
                if (this.log.shouldLog(20)) {
                    this.log.info("EPS SANFP closest " + (isInbound ? "IB" : "OB") + " exclude " + closestExclude.size());
                }
                HashSet<Hash> SANFPExclude = new HashSet<Hash>(closestExclude);
                this.ctx.profileOrganizer().selectActiveNotFailingPeers(1, SANFPExclude, closest);
                if (closest.isEmpty()) {
                    if (this.log.shouldLog(20)) {
                        this.log.info("EPS SFP closest " + (isInbound ? "IB" : "OB") + " exclude " + closestExclude.size());
                    }
                    this.ctx.profileOrganizer().selectFastPeers(1, closestExclude, closest);
                }
            } else if (exploreHighCap) {
                if (this.log.shouldLog(20)) {
                    this.log.info("EPS SHCP closest " + (isInbound ? "IB" : "OB") + " exclude " + closestExclude.size());
                }
                this.ctx.profileOrganizer().selectHighCapacityPeers(1, closestExclude, closest);
            } else {
                if (this.log.shouldLog(20)) {
                    this.log.info("EPS SNFP closest " + (isInbound ? "IB" : "OB") + " exclude " + closestExclude.size());
                }
                this.ctx.profileOrganizer().selectNotFailingPeers(1, closestExclude, closest, false);
            }
            if (!closest.isEmpty()) {
                closestHop = (Hash)closest.iterator().next();
                exclude.add(closestHop);
                --length;
            }
        }
        Hash furthestHop = null;
        if (hiddenOutbound && length > 0) {
            TunnelManagerFacade tmf = this.ctx.tunnelManager();
            TunnelPool tp = tmf.getInboundExploratoryPool();
            TunnelPoolSettings tps = tp.getSettings();
            int len = tps.getLength();
            boolean pickFurthest = true;
            if (len > 0 && tps.getLengthOverride() != 0 && len + tps.getLengthVariance() > 0) {
                for (TunnelInfo ti : tp.listTunnels()) {
                    if (ti.getLength() <= 1) continue;
                    pickFurthest = false;
                    break;
                }
            }
            if (pickFurthest) {
                HashSet<Hash> furthest = new HashSet<Hash>(1);
                if (this.log.shouldLog(20)) {
                    this.log.info("EPS SANFP furthest OB exclude " + exclude.size());
                }
                HashSet<Hash> SANFPExclude = new HashSet<Hash>(exclude);
                this.ctx.profileOrganizer().selectActiveNotFailingPeers(1, SANFPExclude, furthest);
                if (furthest.isEmpty()) {
                    if (this.log.shouldLog(20)) {
                        this.log.info("EPS SFP furthest OB exclude " + exclude.size());
                    }
                    this.ctx.profileOrganizer().selectFastPeers(1, exclude, furthest);
                }
                if (!furthest.isEmpty()) {
                    furthestHop = (Hash)furthest.iterator().next();
                    exclude.add(furthestHop);
                    --length;
                }
            }
        }
        HashSet<Hash> matches = new HashSet<Hash>(length);
        if (length > 0) {
            if (exploreHighCap) {
                if (this.log.shouldLog(20)) {
                    this.log.info("EPS SHCP " + length + (isInbound ? " IB" : " OB") + " exclude " + exclude.size());
                }
                this.ctx.profileOrganizer().selectHighCapacityPeers(length, exclude, matches);
            } else {
                if (length > 2) {
                    this.ctx.profileOrganizer().selectHighCapacityPeers(length - 2, exclude, matches);
                }
                if (this.log.shouldLog(20)) {
                    this.log.info("EPS SNFP " + length + (isInbound ? " IB" : " OB") + " exclude " + exclude.size());
                }
                this.ctx.profileOrganizer().selectNotFailingPeers(length, exclude, matches, false);
            }
            matches.remove(this.ctx.routerHash());
        }
        if ((rv = new ArrayList<Hash>(matches)).size() > 1) {
            this.orderPeers(rv, settings.getRandomKey());
        }
        if (closestHop != null) {
            if (isInbound) {
                rv.add(0, closestHop);
            } else {
                rv.add(closestHop);
            }
            ++length;
        }
        if (furthestHop != null) {
            if (isInbound) {
                rv.add(furthestHop);
            } else {
                rv.add(0, furthestHop);
            }
            ++length;
        }
        if (isInbound) {
            rv.add(0, this.ctx.routerHash());
        } else {
            rv.add(this.ctx.routerHash());
        }
        if (rv.size() > 1 && !this.checkTunnel(isInbound, rv)) {
            rv = null;
        }
        return rv;
    }

    private boolean shouldPickHighCap() {
        int failPct;
        if (this.ctx.getBooleanProperty("router.exploreHighCapacity")) {
            return true;
        }
        int active = this.ctx.commSystem().countActivePeers();
        if (active < 6) {
            return false;
        }
        long uptime = this.ctx.router().getUptime();
        if (uptime <= (long)(SystemVersion.isAndroid() ? 900000 : 300000)) {
            return true;
        }
        if (uptime <= 3660000L && this.ctx.router().getEstimatedDowntime() > 259200000L) {
            return true;
        }
        if (this.ctx.router().gracefulShutdownInProgress()) {
            return true;
        }
        if (active < 12) {
            return false;
        }
        if (this.ctx.router().getUptime() <= 660000L) {
            failPct = 85;
        } else {
            failPct = this.getExploratoryFailPercentage();
            if (failPct > 85) {
                failPct = 85;
            }
        }
        return failPct >= this.ctx.random().nextInt(100);
    }

    private int getExploratoryFailPercentage() {
        int c = this.getFailPercentage("Client");
        int e = this.getFailPercentage("Exploratory");
        if (e <= c || e <= 25) {
            return 0;
        }
        if (c >= 70 || e >= 75) {
            return 85;
        }
        return 100 * (e - c) / (100 - c);
    }

    private int getFailPercentage(String t) {
        String pfx = "tunnel.build" + t;
        int timeout = this.getEvents(pfx + "Expire", 600000L);
        int reject = this.getEvents(pfx + "Reject", 600000L);
        int accept = this.getEvents(pfx + "Success", 600000L);
        if (accept + reject + timeout <= 0) {
            return 0;
        }
        double pct = (double)(reject + timeout) / (double)(accept + reject + timeout);
        return (int)(100.0 * pct);
    }

    private int getEvents(String stat, long period) {
        RateStat rs = this.ctx.statManager().getRate(stat);
        if (rs == null) {
            return 0;
        }
        Rate r = rs.getRate(period);
        if (r == null) {
            return 0;
        }
        return (int)r.computeAverages().getTotalEventCount();
    }
}

