/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import com.southernstorm.noise.protocol.CipherState;
import com.southernstorm.noise.protocol.CipherStatePair;
import com.southernstorm.noise.protocol.HandshakeState;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import net.i2p.crypto.HKDF;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.ntcp.EstablishState;
import net.i2p.router.transport.ntcp.NTCP2Payload;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

class OutboundNTCP2State
implements EstablishState {
    private final RouterContext _context;
    private final Log _log;
    private final NTCPTransport _transport;
    private final NTCPConnection _con;
    private final byte[] _tmp;
    private int _received;
    private long _peerSkew;
    public static final int KEY_SIZE = 32;
    public static final int MAC_SIZE = 16;
    public static final int IV_SIZE = 16;
    public static final int OPTIONS1_SIZE = 16;
    public static final int MSG1_SIZE = 64;
    public static final int TOTAL1_MAX = 287;
    private static final int PADDING1_MAX = 64;
    private static final int PADDING3_MAX = 64;
    public static final int OPTIONS2_SIZE = 16;
    public static final int MSG2_SIZE = 64;
    public static final int MSG3P1_SIZE = 48;
    private static final int OPTIONS3_SIZE = 12;
    public static final long MAX_SKEW = 60L;
    private static final byte[] ZEROLEN = new byte[0];
    private static final byte[] ONE = new byte[]{1};
    public static final byte[] ZEROKEY = new byte[32];
    private static final byte[] ASK = new byte[]{97, 115, 107, 1};
    private static final byte[] SIPHASH = DataHelper.getASCII("siphash");
    private final Object _stateLock = new Object();
    private State _state;
    private final HandshakeState _handshakeState;
    private final RouterInfo _aliceRI;
    private final int _aliceRISize;
    private int _padlen1;
    private int _padlen2;
    private final int _padlen3;
    private final SessionKey _bobHash;
    private final byte[] _bobIV;

    public OutboundNTCP2State(RouterContext ctx, NTCPTransport transport, NTCPConnection con) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._transport = transport;
        this._con = con;
        this._state = State.OB_INIT;
        this._tmp = new byte[287];
        try {
            this._handshakeState = new HandshakeState("XK", 1, this._transport.getXDHFactory());
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("bad proto", gse);
        }
        this._aliceRI = ctx.router().getRouterInfo();
        if (this._aliceRI == null) {
            throw new IllegalStateException("no RI yet");
        }
        this._aliceRISize = this._aliceRI.toByteArray().length;
        this._padlen3 = this._context.random().nextInt(64);
        Hash h = this._con.getRemotePeer().calculateHash();
        this._bobHash = new SessionKey(h.getData());
        String s = this._con.getRemoteAddress().getOption("i");
        if (s == null) {
            throw new IllegalArgumentException("no NTCP2 IV");
        }
        this._bobIV = Base64.decode(s);
        if (this._bobIV == null || this._bobIV.length != 16 || DataHelper.eq(this._bobIV, 0, ZEROKEY, 0, 16)) {
            throw new IllegalArgumentException("bad NTCP2 IV");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(State state) {
        Object object = this._stateLock;
        synchronized (object) {
            this._state = state;
        }
    }

    @Override
    public synchronized void receive(ByteBuffer src) {
        if (this._state == State.VERIFIED || this._state == State.CORRUPT) {
            throw new IllegalStateException(this + "received unexpected data on " + this._con);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this + "Receiving: " + src.remaining() + " Received: " + this._received);
        }
        if (!src.hasRemaining()) {
            return;
        }
        this.receiveOutbound(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCorrupt() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._state == State.CORRUPT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._state == State.VERIFIED;
        }
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public synchronized void prepareOutbound() {
        if (this._state != State.OB_INIT) {
            throw new IllegalStateException(this + "unexpected prepareOutbound()");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this + "send X");
        }
        byte[] options = new byte[16];
        options[0] = (byte)this._context.router().getNetworkID();
        options[1] = 2;
        int padlen1 = this._context.random().nextInt(64);
        DataHelper.toLong(options, 2, 2, padlen1);
        int msg3p2len = 4 + this._aliceRISize + 3 + 12 + 3 + this._padlen3 + 16;
        DataHelper.toLong(options, 4, 2, msg3p2len);
        long now = (this._context.clock().now() + 500L) / 1000L;
        DataHelper.toLong(options, 8, 4, now);
        String s = this._con.getRemoteAddress().getOption("s");
        if (s == null) {
            this.fail("no NTCP2 S");
            return;
        }
        byte[] bk = Base64.decode(s);
        if (bk == null || bk.length != 32 || DataHelper.eq(bk, 0, ZEROKEY, 0, 32)) {
            this.fail("bad NTCP2 S: " + s);
            return;
        }
        this._handshakeState.getRemotePublicKey().setPublicKey(bk, 0);
        this._handshakeState.getLocalKeyPair().setKeys(this._transport.getNTCP2StaticPrivkey(), 0, this._transport.getNTCP2StaticPubkey(), 0);
        try {
            this._handshakeState.start();
            if (this._log.shouldDebug()) {
                this._log.debug("After start: " + this._handshakeState.toString());
            }
            this._handshakeState.writeMessage(this._tmp, 0, options, 0, 16);
        }
        catch (GeneralSecurityException gse) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad msg 1 out", gse);
            }
            this.fail("Bad msg 1 out", gse);
            return;
        }
        catch (RuntimeException re) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad msg 1 out", re);
            }
            this.fail("Bad msg 1 out", re);
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("After msg 1: " + this._handshakeState.toString());
        }
        this._context.aes().encrypt(this._tmp, 0, this._tmp, 0, this._bobHash, this._bobIV, 32);
        System.arraycopy(this._tmp, 16, this._bobIV, 0, 16);
        if (padlen1 > 0) {
            this._context.random().nextBytes(this._tmp, 64, padlen1);
            this._handshakeState.mixHash(this._tmp, 64, padlen1);
            if (this._log.shouldDebug()) {
                this._log.debug("After mixhash padding " + padlen1 + " msg 1: " + this._handshakeState.toString());
            }
        }
        this.changeState(State.OB_SENT_X);
        this._con.wantsWrite(this._tmp, 0, 64 + padlen1);
    }

    private void receiveOutbound(ByteBuffer src) {
        int toGet;
        if (this._state == State.OB_SENT_X && src.hasRemaining()) {
            toGet = Math.min(src.remaining(), 64 - this._received);
            src.get(this._tmp, this._received, toGet);
            this._received += toGet;
            if (this._received < 64) {
                return;
            }
            this._context.aes().decrypt(this._tmp, 0, this._tmp, 0, this._bobHash, this._bobIV, 32);
            if (DataHelper.eqCT(this._tmp, 0, ZEROKEY, 0, 32)) {
                this.fail("Bad msg 2, Y = 0");
                return;
            }
            byte[] options2 = new byte[16];
            try {
                this._handshakeState.readMessage(this._tmp, 0, 64, options2, 0);
            }
            catch (GeneralSecurityException gse) {
                this.fail("Bad msg 2, Y = " + Base64.encode(this._tmp, 0, 32), gse);
                return;
            }
            catch (RuntimeException re) {
                this.fail("Bad msg 2, Y = " + Base64.encode(this._tmp, 0, 32), re);
                return;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("After msg 2: " + this._handshakeState.toString());
            }
            this._padlen2 = (int)DataHelper.fromLong(options2, 2, 2);
            long tsB = DataHelper.fromLong(options2, 8, 4);
            long now = this._context.clock().now();
            long rtt = now - this._con.getCreated();
            this._peerSkew = (now - tsB * 1000L - rtt / 2L + 500L) / 1000L;
            if (this._peerSkew > 60L || this._peerSkew < -60L) {
                this.fail("Clock Skew: " + this._peerSkew, null, true);
                return;
            }
            this.changeState(State.OB_GOT_HXY);
            this._received = 0;
        }
        if (this._state == State.OB_GOT_HXY && src.hasRemaining()) {
            toGet = Math.min(src.remaining(), this._padlen2 - this._received);
            src.get(this._tmp, this._received, toGet);
            this._received += toGet;
            if (this._received < this._padlen2) {
                return;
            }
            if (this._padlen2 > 0) {
                this._handshakeState.mixHash(this._tmp, 0, this._padlen2);
                if (this._log.shouldDebug()) {
                    this._log.debug("After mixhash padding " + this._padlen2 + " msg 2: " + this._handshakeState.toString());
                }
            }
            this.changeState(State.OB_GOT_PADDING);
            if (src.hasRemaining()) {
                this.fail("Extra data after msg 2: " + src.remaining());
                return;
            }
            this.prepareOutbound3();
            return;
        }
        if ((this._state == State.VERIFIED || this._state == State.CORRUPT) && src.hasRemaining() && this._log.shouldWarn()) {
            this._log.warn("Received unexpected " + src.remaining() + " on " + this, new Exception());
        }
    }

    private void prepareOutbound3() {
        int msg3p2len = 4 + this._aliceRISize + 3 + 12 + 3 + this._padlen3;
        byte[] tmp = new byte[48 + msg3p2len + 16];
        ArrayList<NTCP2Payload.Block> blocks = new ArrayList<NTCP2Payload.Block>(3);
        NTCP2Payload.Block block = new NTCP2Payload.RIBlock(this._aliceRI, false);
        blocks.add(block);
        byte[] opts = new byte[12];
        opts[0] = 0;
        opts[1] = 1;
        opts[2] = 0;
        opts[3] = 1;
        DataHelper.toLong(opts, 4, 2, 0L);
        DataHelper.toLong(opts, 6, 2, 0L);
        DataHelper.toLong(opts, 8, 2, 0L);
        DataHelper.toLong(opts, 10, 2, 0L);
        block = new NTCP2Payload.OptionsBlock(opts);
        blocks.add(block);
        block = new NTCP2Payload.PaddingBlock(this._padlen3);
        blocks.add(block);
        int newoff = NTCP2Payload.writePayload(tmp, 48, blocks);
        int expect = 48 + msg3p2len;
        if (newoff != expect) {
            throw new IllegalStateException("msg3 size mismatch expected " + expect + " got " + newoff);
        }
        try {
            this._handshakeState.writeMessage(tmp, 0, tmp, 48, msg3p2len);
        }
        catch (GeneralSecurityException gse) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad msg 3 out", gse);
            }
            this.fail("Bad msg 3 out", gse);
            return;
        }
        catch (RuntimeException re) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad msg 3 out", re);
            }
            this.fail("Bad msg 3 out", re);
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Sending msg3, part 1 is:\n" + HexDump.dump(tmp, 0, 48));
        }
        this._con.wantsWrite(tmp);
        if (this._log.shouldDebug()) {
            this._log.debug("After msg 3: " + this._handshakeState.toString());
        }
        this.setDataPhase();
    }

    private void setDataPhase() {
        CipherStatePair ckp = this._handshakeState.split();
        CipherState rcvr = ckp.getReceiver();
        CipherState sender = ckp.getSender();
        byte[][] sipkeys = OutboundNTCP2State.generateSipHashKeys(this._context, this._handshakeState);
        byte[] sip_ab = sipkeys[0];
        byte[] sip_ba = sipkeys[1];
        if (this._log.shouldDebug()) {
            this._log.debug("Finished establishment for " + this + "\nGenerated SipHash key for A->B: " + Base64.encode(sip_ab) + "\nGenerated SipHash key for B->A: " + Base64.encode(sip_ba));
        }
        this._con.finishOutboundEstablishment(sender, rcvr, sip_ab, sip_ba, this._peerSkew);
        this.changeState(State.VERIFIED);
        this.releaseBufs(true);
        this._handshakeState.destroy();
        Arrays.fill(sip_ab, (byte)0);
        Arrays.fill(sip_ba, (byte)0);
    }

    static byte[][] generateSipHashKeys(RouterContext ctx, HandshakeState state) {
        HKDF hkdf = new HKDF(ctx);
        byte[] ask_master = new byte[32];
        hkdf.calculate(state.getChainingKey(), ZEROLEN, "ask", ask_master);
        byte[] tmp = new byte[32 + SIPHASH.length];
        byte[] hash = state.getHandshakeHash();
        System.arraycopy(hash, 0, tmp, 0, 32);
        System.arraycopy(SIPHASH, 0, tmp, 32, SIPHASH.length);
        byte[] sip_master = new byte[32];
        hkdf.calculate(ask_master, tmp, sip_master);
        Arrays.fill(ask_master, (byte)0);
        Arrays.fill(tmp, (byte)0);
        byte[] sip_ab = new byte[32];
        byte[] sip_ba = new byte[32];
        hkdf.calculate(sip_master, ZEROLEN, sip_ab, sip_ba, 0);
        Arrays.fill(sip_master, (byte)0);
        return new byte[][]{sip_ab, sip_ba};
    }

    @Override
    public synchronized void close(String reason, Exception e) {
        this.fail(reason, e);
    }

    protected void fail(String reason) {
        this.fail(reason, null);
    }

    protected void fail(String reason, Exception e) {
        this.fail(reason, e, false);
    }

    protected synchronized void fail(String reason, Exception e, boolean bySkew) {
        if (this._state == State.CORRUPT || this._state == State.VERIFIED) {
            return;
        }
        this.changeState(State.CORRUPT);
        if (this._log.shouldWarn()) {
            this._log.warn(this + "Failed to establish: " + reason, e);
            this._log.warn("State at failure: " + this._handshakeState.toString());
        }
        this._handshakeState.destroy();
        if (!bySkew) {
            this._context.statManager().addRateData("ntcp.receiveCorruptEstablishment", 1L);
        }
        this.releaseBufs(false);
    }

    private void releaseBufs(boolean isVerified) {
        Arrays.fill(this._tmp, (byte)0);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("OBES2 ");
        buf.append(this._con.toString());
        buf.append(' ').append((Object)this._state);
        if (this._con.isEstablished()) {
            buf.append(" established");
        }
        buf.append(": ");
        return buf.toString();
    }

    private static enum State {
        OB_INIT,
        OB_SENT_X,
        OB_GOT_HXY,
        OB_GOT_PADDING,
        VERIFIED,
        CORRUPT;

    }
}

