/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.app;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.util.Log;
import net.i2p.util.ShellCommand;
import net.i2p.util.SystemVersion;

public class ShellService
implements ClientApp {
    private static final String NAME_OPTION = "-shellservice.name";
    private static final String DISPLAY_NAME_OPTION = "-shellservice.displayname";
    private static final String PLUGIN_DIR = "plugins";
    private final Log _log;
    private final ProcessBuilder _pb;
    private final I2PAppContext _context;
    private final ClientAppManager _cmgr;
    private ClientAppState _state = ClientAppState.UNINITIALIZED;
    private volatile String name = "unnamedClient";
    private volatile String displayName = "unnamedClient";
    private Process _p;
    private volatile long _pid;

    public ShellService(I2PAppContext context, ClientAppManager listener, String[] args) {
        this._context = context;
        this._cmgr = listener;
        this._log = context.logManager().getLog(ShellService.class);
        String[] procArgs = this.trimArgs(args);
        String process = this.writeScript(procArgs);
        if (this._log.shouldLog(10)) {
            this._log.debug("Process: " + process);
            this._log.debug("Name: " + this.getName() + ", DisplayName: " + this.getDisplayName());
        }
        this._pb = new ProcessBuilder(process);
        File pluginDir = new File(this._context.getConfigDir(), "plugins/" + this.getName());
        this._pb.directory(pluginDir);
        this.changeState(ClientAppState.INITIALIZED, "ShellService: " + this.getName() + " set up and initialized");
    }

    private String scriptArgs(String[] procArgs) {
        StringBuilder tidiedArgs = new StringBuilder();
        for (int i = 0; i < procArgs.length; ++i) {
            tidiedArgs.append(" \"").append(procArgs[i]).append("\" ");
        }
        return tidiedArgs.toString();
    }

    private String batchScript(String[] procArgs) {
        if (this._log.shouldLog(10)) {
            String cmd = procArgs[0];
            this._log.debug("cmd: " + cmd);
        }
        String script = "start \"" + this.getName() + "\" " + this.scriptArgs(procArgs) + System.lineSeparator() + "tasklist /V /FI \"WindowTitle eq " + this.getName() + "*\"" + System.lineSeparator();
        return script;
    }

    private String shellScript(String[] procArgs) {
        File file;
        String cmd = procArgs[0];
        if (this._log.shouldLog(10)) {
            this._log.debug("cmd: " + cmd);
        }
        if ((file = new File(cmd)).exists() && !file.isDirectory() && !file.canExecute()) {
            file.setExecutable(true);
        }
        String Script = "nohup " + this.scriptArgs(procArgs) + " 1>/dev/null 2>/dev/null & echo $!" + System.lineSeparator();
        return Script;
    }

    private void deleteScript() {
        File dir = this._context.getTempDir();
        if (SystemVersion.isWindows()) {
            File bat = new File(dir, "shellservice-" + this.getName() + ".bat");
            bat.delete();
        } else {
            File sh = new File(dir, "shellservice-" + this.getName() + ".sh");
            sh.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeScript(File dir, String extension, String[] procArgs) {
        File script = new File(dir, "shellservice-" + this.getName() + extension);
        script.delete();
        if (this._log.shouldLog(10)) {
            this._log.debug("Writing Batch Script " + script.toString());
        }
        OutputStreamWriter scriptWriter = null;
        try {
            script.createNewFile();
            scriptWriter = new FileWriter(script);
            if (extension.equals(".bat") || extension.equals("")) {
                scriptWriter.write(this.batchScript(procArgs));
            } else if (extension.equals(".sh")) {
                scriptWriter.write(this.shellScript(procArgs));
            }
            this.changeState(ClientAppState.INITIALIZED, "ShellService: " + this.getName() + " initialized");
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error writing wrapper script shellservice-" + this.getName() + extension, ioe);
            }
            script.delete();
            this.changeState(ClientAppState.START_FAILED, "ShellService: " + this.getName() + " failed to start, error writing script.", ioe);
        }
        finally {
            block18: {
                try {
                    if (scriptWriter != null) {
                        scriptWriter.close();
                    }
                }
                catch (IOException ioe) {
                    if (!this._log.shouldLog(40)) break block18;
                    this._log.error("Error writing wrapper script shellservice-" + this.getName() + extension, ioe);
                    this.changeState(ClientAppState.START_FAILED, "ShellService: " + this.getName() + " failed to start, error closing script writer", ioe);
                }
            }
        }
        script.setExecutable(true);
        return script.getAbsolutePath();
    }

    private String writeScript(String[] procArgs) {
        File dir = this._context.getTempDir();
        if (SystemVersion.isWindows()) {
            return this.writeScript(dir, ".bat", procArgs);
        }
        return this.writeScript(dir, ".sh", procArgs);
    }

    private String getPID() {
        return String.valueOf(this._pid);
    }

    private boolean isProcessIdRunningOnWindows(String pid) {
        try {
            String[] cmds = new String[]{"cmd", "/c", "tasklist /FI \"PID eq " + pid + "\""};
            ShellCommand _shellCommand = new ShellCommand();
            return _shellCommand.executeSilentAndWaitTimed(cmds, 240);
        }
        catch (Exception ex) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Error checking if process is running", ex);
            }
            this.changeState(ClientAppState.CRASHED, "ShellService: " + this.getName() + " status unknowable", ex);
            return false;
        }
    }

    private boolean isProcessIdRunningOnUnix(String pid) {
        try {
            String[] cmds = new String[]{"ps", "-p", pid};
            ShellCommand _shellCommand = new ShellCommand();
            return _shellCommand.executeSilentAndWaitTimed(cmds, 240);
        }
        catch (Exception ex) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Error checking if process is running", ex);
            }
            this.changeState(ClientAppState.CRASHED, "ShellService: " + this.getName() + " status unknowable", ex);
            return false;
        }
    }

    private boolean isProcessIdRunning(String pid) {
        boolean running = false;
        running = SystemVersion.isWindows() ? this.isProcessIdRunningOnWindows(pid) : this.isProcessIdRunningOnUnix(pid);
        return running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getPidOfProcess() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Finding the PID of: " + this.getName());
        }
        if (this.isProcessIdRunning(this.getPID())) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Read PID in from " + this.getPID());
            }
            return this._pid;
        }
        BufferedInputStream bis = null;
        ByteArrayOutputStream buf = null;
        try {
            if (this._log.shouldLog(10)) {
                this._log.debug("Getting PID from output");
            }
            if (this._p == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Process is null, something is wrong");
                }
                this.changeState(ClientAppState.CRASHED, "ShellService: " + this.getName() + " should be runnning but the process is null.");
                long l = -1L;
                return l;
            }
            bis = new BufferedInputStream(this._p.getInputStream());
            buf = new ByteArrayOutputStream();
            int result = bis.read();
            while (result != -1 && result != 10) {
                buf.write((byte)result);
                result = bis.read();
            }
            String pidString = buf.toString("UTF-8").replaceAll("[\\r\\n\\t ]", "");
            long pid = this._pid;
            if (this._log.shouldLog(10)) {
                this._log.debug("Found " + this.getName() + "process with PID: " + pid);
            }
            long l = pid;
            return l;
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error getting PID of application started by shellservice-" + this.getName(), ioe);
            }
            this.changeState(ClientAppState.CRASHED, "ShellService: " + this.getName() + " PID could not be discovered", ioe);
        }
        finally {
            block35: {
                block34: {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException ioe) {
                            if (!this._log.shouldLog(40)) break block34;
                            this._log.error("Error closing input stream", ioe);
                        }
                    }
                }
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (IOException ioe) {
                        if (!this._log.shouldLog(40)) break block35;
                        this._log.error("Error closing output stream", ioe);
                    }
                }
            }
        }
        return -1L;
    }

    private String[] trimArgs(String[] args) {
        ArrayList<String> newargs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(NAME_OPTION)) {
                if (args[i].contains("=")) {
                    this.name = args[i].split("=")[1];
                    continue;
                }
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].startsWith(DISPLAY_NAME_OPTION)) {
                if (args[i].contains("=")) {
                    this.displayName = args[i].split("=")[1];
                    continue;
                }
                this.displayName = args[i + 1];
                ++i;
                continue;
            }
            newargs.add(args[i]);
        }
        if (this.getName() == null) {
            throw new IllegalArgumentException("ShellService: ShellService passed with args=" + Arrays.toString(args) + " must have a name");
        }
        if (this.getDisplayName() == null) {
            this.displayName = this.name;
        }
        String[] arr = new String[newargs.size()];
        return newargs.toArray(arr);
    }

    private synchronized void changeState(ClientAppState newState, String message, Exception ex) {
        if (this._state != newState) {
            this._state = newState;
            this._cmgr.notify(this, newState, message, ex);
        }
    }

    private synchronized void changeState(ClientAppState newState, String message) {
        this.changeState(newState, message, null);
    }

    @Override
    public synchronized void startup() throws Throwable {
        if (this.getName().equals("unnamedClient")) {
            if (this._log.shouldLog(30)) {
                this._log.warn("ShellService has no name, not starting");
            }
            return;
        }
        this.changeState(ClientAppState.STARTING, "ShellService: " + this.getName() + " starting");
        boolean start = this.checkIsStopped();
        if (start) {
            this._p = this._pb.start();
            long pid = this.getPidOfProcess();
            if (pid == -1L && this._log.shouldLog(40)) {
                this._log.error("Error getting PID of application from recently instantiated shellservice" + this.getName());
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Started " + this.getName() + "process with PID: " + pid);
            }
            this._pid = pid;
            this.deleteScript();
        }
        this.changeState(ClientAppState.RUNNING, "ShellService: " + this.getName() + " started");
        Boolean reg = this._cmgr.register(this);
        if (reg.booleanValue()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("ShellService: " + this.getName() + " registered with the router");
            }
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("ShellService: " + this.getName() + " failed to register with the router");
            }
            this._cmgr.unregister(this);
            this._cmgr.register(this);
        }
    }

    public boolean checkIsStopped() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Checking process status " + this.getName());
        }
        return !this.isProcessIdRunning(this.getPID());
    }

    @Override
    public synchronized void shutdown(String[] args) throws Throwable {
        String pid = this.getPID();
        if (this.getName().equals("unnamedClient")) {
            if (this._log.shouldLog(30)) {
                this._log.warn("ShellService has no name, not shutting down");
            }
            return;
        }
        this.changeState(ClientAppState.STOPPING, "ShellService: " + this.getName() + " stopping");
        if (this._p != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Stopping " + this.getName() + "process started with ShellService, PID: " + pid);
            }
            this._p.destroy();
        }
        ShellCommand _shellCommand = new ShellCommand();
        if (SystemVersion.isWindows()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Stopping " + this.getName() + "process with PID: " + pid + "on Windows");
            }
            String[] cmd = new String[]{"cmd", "/c", "taskkill /F /T /PID " + pid};
            _shellCommand.executeSilentAndWaitTimed(cmd, 240);
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Stopping " + this.getName() + "process with PID: " + pid + "on Unix");
            }
            String[] cmd = new String[]{"kill", pid};
            _shellCommand.executeSilentAndWaitTimed(cmd, 240);
        }
        this.deleteScript();
        this.changeState(ClientAppState.STOPPED, "ShellService: " + this.getName() + " stopped");
        this._cmgr.unregister(this);
    }

    @Override
    public ClientAppState getState() {
        String pid = this.getPID();
        if (!this.isProcessIdRunning(pid)) {
            this.changeState(ClientAppState.STOPPED, "ShellService: " + this.getName() + " stopped");
            this._cmgr.unregister(this);
        }
        return this._state;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }
}

