/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.router.web.FormHandler;

public class ConfigReseedHandler
extends FormHandler {
    private final Map<String, String> changes = new HashMap<String, String>();
    private final List<String> removes = new ArrayList<String>();

    protected void processForm() {
        if (this._action.equals(this._("Save changes and reseed now"))) {
            this.saveChanges();
            if (!this._context.netDb().reseedChecker().requestReseed()) {
                this.addFormError(this._("Reseeding is already in progress"));
            } else {
                this.addFormNotice(this._("Starting reseed process"));
            }
            return;
        }
        if (this._action.equals(this._("Save changes"))) {
            this.saveChanges();
            return;
        }
    }

    private void saveString(String config, String param) {
        String val = this.getJettyString(param);
        if (val != null && val.length() > 0) {
            this.changes.put(config, val);
        } else {
            this.removes.add(config);
        }
    }

    private void saveBoolean(String config, String param) {
        boolean val = this.getJettyString(param) != null;
        this.changes.put(config, Boolean.toString(val));
    }

    private void saveChanges() {
        this.saveString("router.reseedProxyPort", "port");
        this.saveString("router.reseedProxyHost", "host");
        this.saveString("router.reseedProxy.username", "username");
        this.saveString("router.reseedProxy.password", "password");
        this.saveBoolean("router.reseedProxy.authEnable", "auth");
        this.saveString("router.reseedSSLProxyPort", "sport");
        this.saveString("router.reseedSSLProxyHost", "shost");
        this.saveString("router.reseedSSLProxy.username", "susername");
        this.saveString("router.reseedSSLProxy.password", "spassword");
        this.saveBoolean("router.reseedSSLProxy.authEnable", "sauth");
        String url = this.getJettyString("reseedURL");
        if (url != null) {
            if ((url = url.trim().replace("\r\n", ",").replace("\n", ",")).length() <= 0) {
                this.addFormNotice("Restoring default URLs");
                this.removes.add("i2p.reseedURL");
            } else {
                this.changes.put("i2p.reseedURL", url);
            }
        }
        String mode = this.getJettyString("mode");
        boolean req = "1".equals(mode);
        boolean disabled = "2".equals(mode);
        this.changes.put("router.reseedSSLRequired", Boolean.toString(req));
        this.changes.put("router.reseedSSLDisable", Boolean.toString(disabled));
        this.saveBoolean("router.reseedProxyEnable", "enable");
        this.saveBoolean("router.reseedSSLProxyEnable", "senable");
        if (this._context.router().saveConfig(this.changes, this.removes)) {
            this.addFormNotice(this._("Configuration saved successfully."));
        } else {
            this.addFormError(this._("Error saving the configuration (applied but not saved) - please see the error logs"));
        }
    }
}

