/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.Banlist;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;

public class BanlistRenderer {
    private final RouterContext _context;

    public BanlistRenderer(RouterContext context) {
        this._context = context;
    }

    public void renderStatusHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        TreeMap<Hash, Banlist.Entry> entries = new TreeMap<Hash, Banlist.Entry>(new HashComparator());
        entries.putAll(this._context.banlist().getEntries());
        if (entries.isEmpty()) {
            buf.append("<i>").append(this._("none")).append("</i>");
            out.write(buf.toString());
            return;
        }
        buf.append("<ul>");
        for (Map.Entry e : entries.entrySet()) {
            Hash key = (Hash)e.getKey();
            Banlist.Entry entry = (Banlist.Entry)e.getValue();
            long expires = entry.expireOn - this._context.clock().now();
            if (expires <= 0L) continue;
            buf.append("<li>").append(this._context.commSystem().renderPeerHTML(key));
            buf.append(' ');
            String expireString = DataHelper.formatDuration2(expires);
            if (expires < 432000000L) {
                buf.append(this._("Temporary ban expiring in {0}", expireString));
            } else {
                buf.append(this._("Banned until restart or in {0}", expireString));
            }
            Set<String> transports = entry.transports;
            if (transports != null && !transports.isEmpty()) {
                buf.append(" on the following transport: ").append(transports);
            }
            if (entry.cause != null) {
                buf.append("<br>\n");
                if (entry.causeCode != null) {
                    buf.append(this._(entry.cause, entry.causeCode));
                } else {
                    buf.append(this._(entry.cause));
                }
            }
            buf.append(" (<a href=\"configpeer?peer=").append(key.toBase64()).append("#unsh\">").append(this._("unban now")).append("</a>)");
            buf.append("</li>\n");
        }
        buf.append("</ul>\n");
        out.write(buf.toString());
        out.flush();
    }

    private String _(String s) {
        return Messages.getString(s, this._context);
    }

    private String _(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashComparator
    implements Comparator<Hash> {
        private HashComparator() {
        }

        @Override
        public int compare(Hash l, Hash r) {
            return l.toBase64().compareTo(r.toBase64());
        }
    }
}

