/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.net.SocketAddress;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;

public class I2PSocketAddress
extends SocketAddress {
    private final int _port;
    private final Destination _dest;
    private final String _host;

    public I2PSocketAddress(Destination dest, int port) {
        this._port = port;
        this._dest = dest;
        this._host = null;
    }

    public I2PSocketAddress(String host, int port) {
        this._port = port;
        this._dest = I2PAppContext.getGlobalContext().namingService().lookup(host);
        this._host = host;
    }

    public static I2PSocketAddress createUnresolved(String host, int port) {
        return new I2PSocketAddress(port, host);
    }

    private I2PSocketAddress(int port, String host) {
        this._port = port;
        this._dest = null;
        this._host = host;
    }

    public int getPort() {
        return this._port;
    }

    public Destination getAddress() {
        return this._dest;
    }

    public String getHostName() {
        return this._host;
    }

    public boolean isUnresolved() {
        return this._dest == null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this._dest != null) {
            buf.append(this._dest.calculateHash().toString());
        } else {
            buf.append(this._host);
        }
        buf.append(':');
        buf.append(this._port);
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof I2PSocketAddress)) {
            return false;
        }
        I2PSocketAddress o = (I2PSocketAddress)obj;
        if (this._port != o._port) {
            return false;
        }
        if (this._dest != null) {
            return this._dest.equals((Object)o._dest);
        }
        if (o._dest != null) {
            return false;
        }
        if (this._host != null) {
            return this._host.equals(o._host);
        }
        return o._host == null;
    }

    public int hashCode() {
        return DataHelper.hashCode((Object)this._dest) ^ DataHelper.hashCode((Object)this._host) ^ this._port;
    }
}

