/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.MessageWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StoreState {
    private final RouterContext _context;
    private final Hash _key;
    private final DatabaseEntry _data;
    private final HashSet<Hash> _pendingPeers;
    private final Map<Hash, Long> _pendingPeerTimes;
    private final Map<Hash, MessageWrapper.WrappedMessage> _pendingMessages;
    private final HashSet<Hash> _successfulPeers;
    private final HashSet<Hash> _failedPeers;
    private final HashSet<Hash> _attemptedPeers;
    private int _completeCount;
    private volatile long _completed;
    private volatile long _started;

    public StoreState(RouterContext ctx, Hash key, DatabaseEntry data) {
        this(ctx, key, data, null);
    }

    public StoreState(RouterContext ctx, Hash key, DatabaseEntry data, Set<Hash> toSkip) {
        this._context = ctx;
        this._key = key;
        this._data = data;
        this._pendingPeers = new HashSet(4);
        this._pendingPeerTimes = new HashMap<Hash, Long>(4);
        this._pendingMessages = new ConcurrentHashMap<Hash, MessageWrapper.WrappedMessage>(4);
        this._attemptedPeers = new HashSet(8);
        if (toSkip != null) {
            this._attemptedPeers.addAll(toSkip);
            this._completeCount = toSkip.size();
        }
        this._failedPeers = new HashSet(8);
        this._successfulPeers = new HashSet(4);
        this._completed = -1L;
        this._started = this._context.clock().now();
    }

    public Hash getTarget() {
        return this._key;
    }

    public DatabaseEntry getData() {
        return this._data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getPending() {
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            return (Set)this._pendingPeers.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getAttempted() {
        HashSet<Hash> hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            return (Set)this._attemptedPeers.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getSuccessful() {
        HashSet<Hash> hashSet = this._successfulPeers;
        synchronized (hashSet) {
            return (Set)this._successfulPeers.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getFailed() {
        HashSet<Hash> hashSet = this._failedPeers;
        synchronized (hashSet) {
            return (Set)this._failedPeers.clone();
        }
    }

    public boolean completed() {
        return this._completed != -1L;
    }

    public void complete(boolean completed) {
        if (completed && this._completed <= 0L) {
            this._completed = this._context.clock().now();
        }
    }

    public int getCompleteCount() {
        return this._completeCount;
    }

    public long getWhenStarted() {
        return this._started;
    }

    public long getWhenCompleted() {
        return this._completed;
    }

    public void addPending(Hash peer, MessageWrapper.WrappedMessage msg) {
        this.addPending(peer);
        this._pendingMessages.put(peer, msg);
    }

    public MessageWrapper.WrappedMessage getPendingMessage(Hash peer) {
        return this._pendingMessages.remove(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(Hash peer) {
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.add(peer);
            this._pendingPeerTimes.put(peer, this._context.clock().now());
        }
        hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            this._attemptedPeers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(Collection<Hash> pending) {
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.addAll(pending);
            Iterator<Hash> iter = pending.iterator();
            while (iter.hasNext()) {
                this._pendingPeerTimes.put(iter.next(), this._context.clock().now());
            }
        }
        hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            this._attemptedPeers.addAll(pending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSkipped(Hash peer) {
        HashSet<Hash> hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            this._attemptedPeers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long confirmed(Hash peer) {
        long rv = -1L;
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.remove(peer);
            Long when = this._pendingPeerTimes.remove(peer);
            if (when != null) {
                rv = this._context.clock().now() - when;
            }
        }
        hashSet = this._successfulPeers;
        synchronized (hashSet) {
            this._successfulPeers.add(peer);
        }
        ++this._completeCount;
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyTimeout(Hash peer) {
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.remove(peer);
        }
        hashSet = this._failedPeers;
        synchronized (hashSet) {
            this._failedPeers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("Storing ").append(this._key);
        buf.append(" ");
        if (this._completed <= 0L) {
            buf.append(" completed? false ");
        } else {
            buf.append(" completed on ").append(new Date(this._completed));
        }
        buf.append(" Attempted: ");
        HashSet<Hash> hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            buf.append(this._attemptedPeers.size()).append(' ');
            for (Hash peer : this._attemptedPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        buf.append(" Pending: ");
        hashSet = this._pendingPeers;
        synchronized (hashSet) {
            buf.append(this._pendingPeers.size()).append(' ');
            for (Hash peer : this._pendingPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        buf.append(" Failed: ");
        hashSet = this._failedPeers;
        synchronized (hashSet) {
            buf.append(this._failedPeers.size()).append(' ');
            for (Hash peer : this._failedPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        buf.append(" Successful: ");
        hashSet = this._successfulPeers;
        synchronized (hashSet) {
            buf.append(this._successfulPeers.size()).append(' ');
            for (Hash peer : this._successfulPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        return buf.toString();
    }
}

