/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.util.Executor;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleStore;
import net.i2p.util.SystemVersion;

public class SimpleTimer {
    private final Log _log;
    private final TreeMap<Long, TimedEvent> _events;
    private final Map<TimedEvent, Long> _eventTimes;
    private final List<TimedEvent> _readyEvents;
    private SimpleStore runn = new SimpleStore(true);
    private static final int MIN_THREADS = 2;
    private static final int MAX_THREADS = 4;
    private long _occurredTime;
    private long _occurredEventCount;

    public static SimpleTimer getInstance() {
        return I2PAppContext.getGlobalContext().simpleTimer();
    }

    public SimpleTimer(I2PAppContext context) {
        this(context, "SimpleTimer");
    }

    private SimpleTimer(I2PAppContext context, String name) {
        this._log = context.logManager().getLog(SimpleTimer.class);
        this._events = new TreeMap();
        this._eventTimes = new HashMap<TimedEvent, Long>(256);
        this._readyEvents = new ArrayList<TimedEvent>(4);
        I2PThread runner = new I2PThread(new SimpleTimerRunner());
        runner.setName(name);
        runner.setDaemon(true);
        runner.start();
        long maxMemory = SystemVersion.getMaxMemory();
        int threads = (int)Math.max(2L, Math.min(4L, 1L + maxMemory / 0x2000000L));
        for (int i = 1; i <= threads; ++i) {
            I2PThread executor = new I2PThread(new Executor(context, this._log, this._readyEvents, this.runn));
            executor.setName(name + "Executor " + i + '/' + threads);
            executor.setDaemon(true);
            executor.start();
        }
        context.addShutdownTask(new Shutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSimpleTimer() {
        Object object = this._events;
        synchronized (object) {
            this.runn.setAnswer(false);
            this._events.clear();
            this._eventTimes.clear();
            this._events.notifyAll();
        }
        object = this._readyEvents;
        synchronized (object) {
            this._readyEvents.clear();
            this._readyEvents.notifyAll();
        }
    }

    public void reschedule(TimedEvent event, long timeoutMs) {
        this.addEvent(event, timeoutMs, false);
    }

    public void addEvent(TimedEvent event, long timeoutMs) {
        this.addEvent(event, timeoutMs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(TimedEvent event, long timeoutMs, boolean useEarliestTime) {
        long timeToAdd;
        int totalEvents = 0;
        long now = System.currentTimeMillis();
        long eventTime = now + timeoutMs;
        Long time = eventTime;
        TreeMap<Long, TimedEvent> treeMap = this._events;
        synchronized (treeMap) {
            Long oldTime = this._eventTimes.get(event);
            if (oldTime != null) {
                if (useEarliestTime) {
                    if (oldTime < eventTime) {
                        this._events.notifyAll();
                        return;
                    }
                    this._events.remove(oldTime);
                } else {
                    if (oldTime > eventTime) {
                        this._events.notifyAll();
                        return;
                    }
                    this._events.remove(oldTime);
                }
            }
            while (this._events.containsKey(time)) {
                time = new Long(time + 1L);
            }
            this._events.put(time, event);
            this._eventTimes.put(event, time);
            if (this._events.size() != this._eventTimes.size()) {
                this._log.error("Skewed events: " + this._events.size() + " for " + this._eventTimes.size());
                for (TimedEvent evt : this._eventTimes.keySet()) {
                    Long when = this._eventTimes.get(evt);
                    TimedEvent cur = this._events.get(when);
                    if (cur == evt) continue;
                    this._log.error("event " + evt + " @ " + when + ": " + cur);
                }
            }
            totalEvents = this._events.size();
            this._events.notifyAll();
        }
        if (time > eventTime + 100L && this._log.shouldLog(30)) {
            this._log.warn("Lots of timer congestion, had to push " + event + " back " + (time - eventTime) + "ms (# events: " + totalEvents + ")");
        }
        if ((timeToAdd = System.currentTimeMillis() - now) > 50L && this._log.shouldLog(30)) {
            this._log.warn("timer contention: took " + timeToAdd + "ms to add a job with " + totalEvents + " queued");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEvent(TimedEvent evt) {
        if (evt == null) {
            return false;
        }
        TreeMap<Long, TimedEvent> treeMap = this._events;
        synchronized (treeMap) {
            Long when = this._eventTimes.remove(evt);
            if (when != null) {
                this._events.remove(when);
            }
            return null != when;
        }
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        public void run() {
            SimpleTimer.this.removeSimpleTimer();
        }
    }

    private class SimpleTimerRunner
    implements Runnable {
        private SimpleTimerRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList<TimedEvent> eventsToFire = new ArrayList<TimedEvent>(1);
            while (SimpleTimer.this.runn.getAnswer()) {
                try {
                    TreeMap treeMap = SimpleTimer.this._events;
                    synchronized (treeMap) {
                        long now = System.currentTimeMillis();
                        long nextEventDelay = -1L;
                        Object nextEvent = null;
                        while (SimpleTimer.this.runn.getAnswer() && !SimpleTimer.this._events.isEmpty()) {
                            Long when = (Long)SimpleTimer.this._events.firstKey();
                            if (when <= now) {
                                TimedEvent evt = (TimedEvent)SimpleTimer.this._events.remove(when);
                                if (evt == null) continue;
                                SimpleTimer.this._eventTimes.remove(evt);
                                eventsToFire.add(evt);
                                continue;
                            }
                            nextEventDelay = when - now;
                            nextEvent = SimpleTimer.this._events.get(when);
                            break;
                        }
                        if (eventsToFire.isEmpty()) {
                            if (nextEventDelay != -1L) {
                                if (SimpleTimer.this._log.shouldLog(10)) {
                                    SimpleTimer.this._log.debug("Next event in " + nextEventDelay + ": " + nextEvent);
                                }
                                SimpleTimer.this._events.wait(nextEventDelay);
                            } else {
                                SimpleTimer.this._events.wait();
                            }
                        }
                    }
                }
                catch (ThreadDeath td) {
                    return;
                }
                catch (InterruptedException ie) {
                }
                catch (Throwable t) {
                    if (SimpleTimer.this._log != null) {
                        SimpleTimer.this._log.log(50, "Uncaught exception in the SimpleTimer!", t);
                    }
                    System.err.println("Uncaught exception in SimpleTimer");
                    t.printStackTrace();
                }
                long now = System.currentTimeMillis();
                now -= now % 1000L;
                List list = SimpleTimer.this._readyEvents;
                synchronized (list) {
                    for (int i = 0; i < eventsToFire.size(); ++i) {
                        SimpleTimer.this._readyEvents.add(eventsToFire.get(i));
                    }
                    SimpleTimer.this._readyEvents.notifyAll();
                }
                if (SimpleTimer.this._occurredTime == now) {
                    SimpleTimer.this._occurredEventCount += eventsToFire.size();
                } else {
                    SimpleTimer.this._occurredTime = now;
                    if (SimpleTimer.this._occurredEventCount > 2500L) {
                        StringBuilder buf = new StringBuilder(128);
                        buf.append("Too many simpleTimerJobs (").append(SimpleTimer.this._occurredEventCount);
                        buf.append(") in a second!");
                        SimpleTimer.this._log.log(30, buf.toString());
                    }
                    SimpleTimer.this._occurredEventCount = 0L;
                }
                eventsToFire.clear();
            }
        }
    }

    public static interface TimedEvent {
        public void timeReached();
    }
}

