/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class I2PThread
extends Thread {
    private static final Set _listeners = new CopyOnWriteArraySet();

    public I2PThread() {
    }

    public I2PThread(String name) {
        super(name);
    }

    public I2PThread(Runnable r) {
        super(r);
    }

    public I2PThread(Runnable r, String name) {
        super(r, name);
    }

    public I2PThread(Runnable r, String name, boolean isDaemon) {
        super(r, name);
        this.setDaemon(isDaemon);
    }

    public I2PThread(ThreadGroup g, Runnable r) {
        super(g, r);
    }

    public void run() {
        try {
            super.run();
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                this.fireOOM((OutOfMemoryError)t);
            }
            System.out.println("Thread terminated unexpectedly: " + this.getName());
            t.printStackTrace();
        }
    }

    protected void fireOOM(OutOfMemoryError oom) {
        for (OOMEventListener listener : _listeners) {
            listener.outOfMemory(oom);
        }
    }

    public static void addOOMEventListener(OOMEventListener lsnr) {
        _listeners.add(lsnr);
    }

    public static void removeOOMEventListener(OOMEventListener lsnr) {
        _listeners.remove(lsnr);
    }

    public static interface OOMEventListener {
        public void outOfMemory(OutOfMemoryError var1);
    }
}

