/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.data.i2cp.SessionId;

public class ReconfigureSessionMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 2;
    private SessionId _sessionId;
    private SessionConfig _sessionConfig;

    public SessionId getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    public SessionConfig getSessionConfig() {
        return this._sessionConfig;
    }

    public void setSessionConfig(SessionConfig config) {
        this._sessionConfig = config;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            this._sessionConfig = new SessionConfig();
            this._sessionConfig.readBytes(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._sessionId == null || this._sessionConfig == null) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(64);
        try {
            this._sessionId.writeBytes(os);
            this._sessionConfig.writeBytes(os);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    public int getType() {
        return 2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[ReconfigureSessionMessage: ");
        buf.append("\n\tSessionId: ").append(this._sessionId);
        buf.append("\n\tSessionConfig: ").append(this._sessionConfig);
        buf.append("]");
        return buf.toString();
    }
}

