/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;

public class DestReplyMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 35;
    private Destination _dest;
    private Hash _hash;

    public DestReplyMessage() {
    }

    public DestReplyMessage(Destination d) {
        this._dest = d;
    }

    public DestReplyMessage(Hash h) {
        this._hash = h;
    }

    public Destination getDestination() {
        return this._dest;
    }

    public Hash getHash() {
        return this._hash;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        if (size == 0) {
            this._dest = null;
            this._hash = null;
        } else {
            try {
                if (size == 32) {
                    this._hash = Hash.create(in);
                } else {
                    Destination d = new Destination();
                    d.readBytes(in);
                    this._dest = d;
                }
            }
            catch (DataFormatException dfe) {
                this._dest = null;
                this._hash = null;
            }
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._dest == null) {
            if (this._hash == null) {
                return new byte[0];
            }
            return this._hash.getData();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(this._dest.size());
        try {
            this._dest.writeBytes(os);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the dest", dfe);
        }
        return os.toByteArray();
    }

    public int getType() {
        return 35;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[DestReplyMessage: ");
        buf.append("\n\tDestination: ").append(this._dest);
        buf.append("\n\tHash: ").append(this._hash);
        buf.append("]");
        return buf.toString();
    }
}

