/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.KeysAndCert;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;

public class Destination
extends KeysAndCert {
    public Destination() {
    }

    public Destination(String s) throws DataFormatException {
        this.fromBase64(s);
    }

    public int writeBytes(byte[] target, int offset) {
        int cur = offset;
        System.arraycopy(this._publicKey.getData(), 0, target, cur, 256);
        System.arraycopy(this._signingKey.getData(), 0, target, cur += 256, SigningPublicKey.KEYSIZE_BYTES);
        cur += SigningPublicKey.KEYSIZE_BYTES;
        cur += this._certificate.writeBytes(target, cur);
        return cur - offset;
    }

    public int readBytes(byte[] source, int offset) throws DataFormatException {
        if (source == null) {
            throw new DataFormatException("Null source");
        }
        if (source.length <= offset + 256 + SigningPublicKey.KEYSIZE_BYTES) {
            throw new DataFormatException("Not enough data (len=" + source.length + " off=" + offset + ")");
        }
        int cur = offset;
        this._publicKey = PublicKey.create(source, cur);
        this._signingKey = SigningPublicKey.create(source, cur += 256);
        this._certificate = Certificate.create(source, cur += SigningPublicKey.KEYSIZE_BYTES);
        return (cur += this._certificate.size()) - offset;
    }

    public int size() {
        return 256 + SigningPublicKey.KEYSIZE_BYTES + this._certificate.size();
    }
}

