/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Map;
import net.i2p.crypto.SHA1;
import net.i2p.crypto.SHA256Generator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SigType {
    DSA_SHA1(0, 128, 20, 20, 40, "SHA-1", "SHA1withDSA", null),
    ECDSA_SHA1_P192(1, 48, 24, 20, 48, "SHA-1", "SHA1withECDSA", null),
    ECDSA_SHA256_P256(2, 64, 32, 32, 64, "SHA-256", "SHA256withECDSA", null),
    ECDSA_SHA384_P384(3, 96, 48, 48, 96, "SHA-384", "SHA384withECDSA", null),
    ECDSA_SHA512_P521(4, 132, 66, 64, 132, "SHA-512", "SHA512withECDSA", null);

    private final int code;
    private final int pubkeyLen;
    private final int privkeyLen;
    private final int hashLen;
    private final int sigLen;
    private final String digestName;
    private final String algoName;
    private final AlgorithmParameterSpec params;
    private static final Map<Integer, SigType> BY_CODE;

    private SigType(int cod, int pubLen, int privLen, int hLen, int sLen, String mdName, String aName, AlgorithmParameterSpec pSpec) {
        this.code = cod;
        this.pubkeyLen = pubLen;
        this.privkeyLen = privLen;
        this.hashLen = hLen;
        this.sigLen = sLen;
        this.digestName = mdName;
        this.algoName = aName;
        this.params = pSpec;
    }

    public int getCode() {
        return this.code;
    }

    public int getPubkeyLen() {
        return this.pubkeyLen;
    }

    public int getPrivkeyLen() {
        return this.privkeyLen;
    }

    public int getHashLen() {
        return this.hashLen;
    }

    public int getSigLen() {
        return this.sigLen;
    }

    public String getAlgorithmName() {
        return this.algoName;
    }

    public AlgorithmParameterSpec getParams() throws InvalidParameterSpecException {
        if (this.params == null) {
            throw new InvalidParameterSpecException(this.toString() + " is not available in this JVM");
        }
        return this.params;
    }

    public MessageDigest getDigestInstance() {
        if (this.digestName.equals("SHA-1")) {
            return SHA1.getInstance();
        }
        if (this.digestName.equals("SHA-256")) {
            return SHA256Generator.getDigestInstance();
        }
        try {
            return MessageDigest.getInstance(this.digestName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static SigType getByCode(int code) {
        return BY_CODE.get(code);
    }

    static {
        BY_CODE = new HashMap<Integer, SigType>();
        for (SigType type : SigType.values()) {
            BY_CODE.put(type.getCode(), type);
        }
    }
}

