/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SHA1;
import net.i2p.crypto.SHA1Hash;
import net.i2p.crypto.SigType;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SU3File {
    private final I2PAppContext _context;
    private final Map<SigningPublicKey, String> _trustedKeys;
    private final File _file;
    private String _version;
    private int _versionLength;
    private String _signer;
    private int _signerLength;
    private int _contentType;
    private long _contentLength;
    private SigningPublicKey _signerPubkey;
    private boolean _headerVerified;
    private static final byte[] MAGIC = DataHelper.getUTF8("I2Psu3");
    private static final int FILE_VERSION = 0;
    private static final int MIN_VERSION_BYTES = 16;
    private static final int VERSION_OFFSET = Signature.SIGNATURE_BYTES;
    private static final int TYPE_ZIP = 0;
    private static final int CONTENT_ROUTER = 0;
    private static final int CONTENT_ROUTER_P200 = 1;
    private static final int CONTENT_PLUGIN = 2;
    private static final int CONTENT_RESEED = 3;
    private static final int SIG_DSA_160 = SigType.DSA_SHA1.getCode();

    public SU3File(String file) {
        this(new File(file));
    }

    public SU3File(File file) {
        this(file, new TrustedUpdate().getKeys());
    }

    public SU3File(File file, Map<SigningPublicKey, String> trustedKeys) {
        this(I2PAppContext.getGlobalContext(), file, trustedKeys);
    }

    public SU3File(I2PAppContext context, File file, Map<SigningPublicKey, String> trustedKeys) {
        this._context = context;
        this._file = file;
        this._trustedKeys = trustedKeys;
    }

    public String getVersionString() throws IOException {
        this.verifyHeader();
        return this._version;
    }

    public String getSignerString() throws IOException {
        this.verifyHeader();
        return this._signer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyHeader() throws IOException {
        if (this._headerVerified) {
            return;
        }
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(this._file);
                this.verifyHeader(in);
            }
            catch (DataFormatException dfe) {
                IOException ioe = new IOException("foo");
                ioe.initCause(dfe);
                throw ioe;
            }
            Object var5_2 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        ((InputStream)in).close();
        return;
    }

    private void verifyHeader(InputStream in) throws IOException, DataFormatException {
        int zbyte;
        byte[] magic = new byte[MAGIC.length];
        DataHelper.read(in, magic);
        if (!DataHelper.eq(magic, MAGIC)) {
            throw new IOException("Not an su3 file");
        }
        SU3File.skip(in, 1);
        int foo = in.read();
        if (foo != 0) {
            throw new IOException("bad file version");
        }
        SU3File.skip(in, 1);
        int sigType = in.read();
        if (sigType != SIG_DSA_160) {
            throw new IOException("bad sig type");
        }
        this._signerLength = (int)DataHelper.readLong(in, 2);
        if (this._signerLength != Signature.SIGNATURE_BYTES) {
            throw new IOException("bad sig length");
        }
        SU3File.skip(in, 1);
        int _versionLength = in.read();
        if (_versionLength < 16) {
            throw new IOException("bad version length");
        }
        SU3File.skip(in, 1);
        int signerLen = in.read();
        if (signerLen <= 0) {
            throw new IOException("bad signer length");
        }
        this._contentLength = DataHelper.readLong(in, 8);
        if (this._contentLength <= 0L) {
            throw new IOException("bad content length");
        }
        SU3File.skip(in, 1);
        foo = in.read();
        if (foo != 0) {
            throw new IOException("bad type");
        }
        SU3File.skip(in, 1);
        this._contentType = in.read();
        if (this._contentType < 0 || this._contentType > 3) {
            throw new IOException("bad content type");
        }
        SU3File.skip(in, 12);
        byte[] data = new byte[_versionLength];
        int bytesRead = DataHelper.read(in, data);
        if (bytesRead != _versionLength) {
            throw new EOFException();
        }
        for (zbyte = 0; zbyte < _versionLength && data[zbyte] != 0; ++zbyte) {
        }
        this._version = new String(data, 0, zbyte, "UTF-8");
        data = new byte[signerLen];
        bytesRead = DataHelper.read(in, data);
        if (bytesRead != signerLen) {
            throw new EOFException();
        }
        this._signer = DataHelper.getUTF8(data);
        if (this._trustedKeys != null) {
            for (Map.Entry<SigningPublicKey, String> e : this._trustedKeys.entrySet()) {
                if (!e.getValue().equals(this._signer)) continue;
                this._signerPubkey = e.getKey();
                break;
            }
            if (this._signerPubkey == null) {
                throw new IOException("unknown signer: " + this._signer);
            }
        }
        this._headerVerified = true;
    }

    private static void skip(InputStream in, int cnt) throws IOException {
        for (int i = 0; i < cnt; ++i) {
            if (in.read() >= 0) continue;
            throw new EOFException();
        }
    }

    private int getContentOffset() throws IOException {
        this.verifyHeader();
        return VERSION_OFFSET + this._versionLength + this._signerLength;
    }

    /*
     * Loose catch block
     */
    public boolean verifyAndMigrate(File migrateTo) throws IOException {
        boolean rv;
        block22: {
            IOException ioe22;
            OutputStream out;
            FilterInputStream in;
            block20: {
                int read;
                in = null;
                out = null;
                rv = false;
                MessageDigest md = SHA1.getInstance();
                in = new DigestInputStream(new BufferedInputStream(new FileInputStream(this._file)), md);
                if (!this._headerVerified) {
                    this.verifyHeader(in);
                } else {
                    SU3File.skip(in, this.getContentOffset());
                }
                if (this._signerPubkey == null) {
                    throw new IOException("unknown signer: " + this._signer);
                }
                out = new FileOutputStream(migrateTo);
                byte[] buf = new byte[16384];
                for (long tot = 0L; tot < this._contentLength; tot += (long)read) {
                    read = ((DigestInputStream)in).read(buf, 0, (int)Math.min((long)buf.length, this._contentLength - tot));
                    if (read < 0) {
                        throw new EOFException();
                    }
                    out.write(buf, 0, read);
                }
                byte[] sha = md.digest();
                ((DigestInputStream)in).on(false);
                Signature signature = new Signature();
                signature.readBytes(in);
                SHA1Hash hash = new SHA1Hash(sha);
                rv = this._context.dsa().verifySignature(signature, hash, this._signerPubkey);
                Object var13_14 = null;
                if (in == null) break block20;
                try {
                    in.close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            if (!rv) {
                migrateTo.delete();
            }
            break block22;
            {
                catch (DataFormatException dfe) {
                    IOException ioe3 = new IOException("foo");
                    ioe3.initCause(dfe);
                    throw ioe3;
                }
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var13_15 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (!rv) {
                    migrateTo.delete();
                }
                throw throwable;
            }
        }
        return rv;
    }

    /*
     * Loose catch block
     */
    public void write(File content, int contentType, String version, String signer, SigningPrivateKey privkey) throws IOException {
        block24: {
            IOException ioe22;
            boolean ok;
            FilterOutputStream out;
            BufferedInputStream in;
            block22: {
                int read;
                in = null;
                out = null;
                ok = false;
                in = new BufferedInputStream(new FileInputStream(content));
                MessageDigest md = SHA1.getInstance();
                out = new DigestOutputStream(new BufferedOutputStream(new FileOutputStream(this._file)), md);
                out.write(MAGIC);
                ((DigestOutputStream)out).write(0);
                ((DigestOutputStream)out).write(0);
                ((DigestOutputStream)out).write(0);
                ((DigestOutputStream)out).write((byte)SIG_DSA_160);
                DataHelper.writeLong(out, 2, Signature.SIGNATURE_BYTES);
                ((DigestOutputStream)out).write(0);
                byte[] verBytes = DataHelper.getUTF8(version);
                if (verBytes.length == 0 || verBytes.length > 255) {
                    throw new IllegalArgumentException("bad version length");
                }
                int verLen = Math.max(verBytes.length, 16);
                ((DigestOutputStream)out).write((byte)verLen);
                ((DigestOutputStream)out).write(0);
                byte[] signerBytes = DataHelper.getUTF8(signer);
                if (signerBytes.length == 0 || signerBytes.length > 255) {
                    throw new IllegalArgumentException("bad signer length");
                }
                ((DigestOutputStream)out).write((byte)signerBytes.length);
                long contentLength = content.length();
                if (contentLength <= 0L) {
                    throw new IllegalArgumentException("No content");
                }
                DataHelper.writeLong(out, 8, contentLength);
                ((DigestOutputStream)out).write(0);
                ((DigestOutputStream)out).write(0);
                ((DigestOutputStream)out).write(0);
                if (contentType < 0 || contentType > 255) {
                    throw new IllegalArgumentException("bad content type");
                }
                ((DigestOutputStream)out).write((byte)contentType);
                out.write(new byte[12]);
                out.write(verBytes);
                if (verBytes.length < 16) {
                    out.write(new byte[16 - verBytes.length]);
                }
                out.write(signerBytes);
                byte[] buf = new byte[16384];
                for (long tot = 0L; tot < contentLength; tot += (long)read) {
                    read = ((InputStream)in).read(buf, 0, (int)Math.min((long)buf.length, contentLength - tot));
                    if (read < 0) {
                        throw new EOFException();
                    }
                    ((DigestOutputStream)out).write(buf, 0, read);
                }
                byte[] sha = md.digest();
                ((DigestOutputStream)out).on(false);
                SHA1Hash hash = new SHA1Hash(sha);
                Signature signature = this._context.dsa().sign(hash, privkey);
                signature.writeBytes(out);
                ok = true;
                Object var22_22 = null;
                if (in == null) break block22;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            if (!ok) {
                this._file.delete();
            }
            break block24;
            {
                catch (DataFormatException dfe) {
                    IOException ioe3 = new IOException("foo");
                    ioe3.initCause(dfe);
                    throw ioe3;
                }
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var22_23 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (!ok) {
                    this._file.delete();
                }
                throw throwable;
            }
        }
    }

    public static void main(String[] args) {
        boolean ok = false;
        try {
            if ("showversion".equals(args[0])) {
                ok = SU3File.showVersionCLI(args[1]);
            } else if ("sign".equals(args[0])) {
                ok = SU3File.signCLI(args[1], args[2], args[3], args[4], args[5]);
            } else if ("verifysig".equals(args[0])) {
                ok = SU3File.verifySigCLI(args[1]);
            } else {
                SU3File.showUsageCLI();
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            SU3File.showUsageCLI();
        }
        if (!ok) {
            System.exit(1);
        }
    }

    private static final void showUsageCLI() {
        System.err.println("Usage: SU3File showversion   signedFile.su3");
        System.err.println("       SU3File sign          inputFile.zip signedFile.su3 privateKeyFile version signerName@mail.i2p");
        System.err.println("       SU3File verifysig     signedFile.su3");
    }

    private static final boolean showVersionCLI(String signedFile) {
        try {
            SU3File file = new SU3File(new File(signedFile), null);
            String versionString = file.getVersionString();
            if (versionString.equals("")) {
                System.out.println("No version string found in file '" + signedFile + "'");
            } else {
                System.out.println("Version: " + versionString);
            }
            return !versionString.equals("");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static final boolean signCLI(String inputFile, String signedFile, String privateKeyFile, String version, String signerName) {
        boolean bl;
        FileInputStream in;
        block11: {
            in = null;
            in = new FileInputStream(privateKeyFile);
            SigningPrivateKey spk = new SigningPrivateKey();
            spk.readBytes(in);
            ((InputStream)in).close();
            SU3File file = new SU3File(signedFile);
            file.write(new File(inputFile), 0, version, signerName, spk);
            System.out.println("Input file '" + inputFile + "' signed and written to '" + signedFile + "'");
            bl = true;
            Object var10_13 = null;
            if (in == null) break block11;
            try {
                ((InputStream)in).close();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
        }
        return bl;
        catch (DataFormatException dfe) {
            boolean bl2;
            block12: {
                System.out.println("Error signing input file '" + inputFile + "'");
                dfe.printStackTrace();
                bl2 = false;
                Object var10_14 = null;
                if (in == null) break block12;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            return bl2;
        }
        catch (IOException ioe) {
            boolean bl3;
            block13: {
                System.out.println("Error signing input file '" + inputFile + "'");
                ioe.printStackTrace();
                bl3 = false;
                Object var10_15 = null;
                if (in == null) break block13;
                {
                    catch (Throwable throwable) {
                        block14: {
                            Object var10_16 = null;
                            if (in == null) break block14;
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException ioe2) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            return bl3;
        }
    }

    private static final boolean verifySigCLI(String signedFile) {
        Object in = null;
        try {
            SU3File file = new SU3File(signedFile);
            boolean isValidSignature = file.verifyAndMigrate(new File("/dev/null"));
            if (isValidSignature) {
                System.out.println("Signature VALID (signed by " + file.getSignerString() + ')');
            } else {
                System.out.println("Signature INVALID (signed by " + file.getSignerString() + ')');
            }
            return isValidSignature;
        }
        catch (IOException ioe) {
            System.out.println("Error verifying input file '" + signedFile + "'");
            ioe.printStackTrace();
            return false;
        }
    }
}

