/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.MetaNamingService;
import net.i2p.client.naming.NamingService;
import net.i2p.client.naming.SingleFileNamingService;
import net.i2p.data.Destination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostsTxtNamingService
extends MetaNamingService {
    public static final String PROP_HOSTS_FILE = "i2p.hostsfilelist";
    public static final String DEFAULT_HOSTS_FILE = "privatehosts.txt,userhosts.txt,hosts.txt";

    public HostsTxtNamingService(I2PAppContext context) {
        super(context, null);
        for (String name : this.getFilenames()) {
            this.addNamingService(new SingleFileNamingService(context, name), false);
        }
    }

    private List<String> getFilenames() {
        String list = this._context.getProperty(PROP_HOSTS_FILE, DEFAULT_HOSTS_FILE);
        StringTokenizer tok = new StringTokenizer(list, ",");
        ArrayList<String> rv = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            rv.add(tok.nextToken());
        }
        return rv;
    }

    @Override
    public Destination lookup(String hostname, Properties lookupOptions, Properties storedOptions) {
        if (hostname.length() >= 516) {
            return this.lookupBase64(hostname);
        }
        return super.lookup(hostname.toLowerCase(Locale.US), lookupOptions, storedOptions);
    }

    @Override
    public boolean put(String hostname, Destination d, Properties options) {
        return super.put(hostname.toLowerCase(Locale.US), d, options);
    }

    @Override
    public boolean putIfAbsent(String hostname, Destination d, Properties options) {
        return super.putIfAbsent(hostname.toLowerCase(Locale.US), d, options);
    }

    @Override
    public boolean remove(String hostname, Properties options) {
        return super.remove(hostname.toLowerCase(Locale.US), options);
    }

    @Override
    public Set<String> getNames(Properties options) {
        String file = null;
        if (options != null) {
            file = options.getProperty("file");
        }
        if (file == null) {
            return super.getNames(options);
        }
        for (NamingService ns : this._services) {
            String name = ns.getName();
            if (!name.equals(file) && !name.endsWith('/' + file) && !name.endsWith('\\' + file)) continue;
            return ns.getNames(options);
        }
        return new HashSet<String>(0);
    }
}

