/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SHA1;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SecureFile;
import net.i2p.util.SystemVersion;
import org.klomp.snark.BitField;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.PartialPiece;
import org.klomp.snark.StorageListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Storage {
    private final MetaInfo metainfo;
    private long[] lengths;
    private RandomAccessFile[] rafs;
    private String[] names;
    private Object[] RAFlock;
    private long[] RAFtime;
    private File[] RAFfile;
    private int[] priorities;
    private boolean[] isSparse;
    private final StorageListener listener;
    private final I2PSnarkUtil _util;
    private final Log _log;
    private BitField bitfield;
    private int needed;
    private boolean _probablyComplete;
    private final int piece_size;
    private final int pieces;
    private final long total_length;
    private boolean changed;
    private volatile boolean _isChecking;
    private final AtomicInteger _allocateCount = new AtomicInteger();
    private static final int DEFAULT_PIECE_SIZE = 262144;
    public static final int MAX_PIECE_SIZE = 0x400000;
    public static final int MAX_PIECES = 10240;
    public static final long MAX_TOTAL_SIZE = 0xA00000000L;
    private static final Map<String, String> _filterNameCache = new ConcurrentHashMap<String, String>();
    private static final boolean _isWindows = SystemVersion.isWindows();
    private static final int BUFSIZE = 16384;
    private static final ByteCache _cache = ByteCache.getInstance(16, 16384);
    private static final char[] ILLEGAL = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u2028', '\u2029'};
    private static final long RAFCloseDelay = 240000L;

    public Storage(I2PSnarkUtil util, MetaInfo metainfo, StorageListener listener) {
        this._util = util;
        this._log = util.getContext().logManager().getLog(Storage.class);
        this.metainfo = metainfo;
        this.listener = listener;
        this.needed = metainfo.getPieces();
        this.bitfield = new BitField(this.needed);
        this.piece_size = metainfo.getPieceLength(0);
        this.pieces = this.needed;
        this.total_length = metainfo.getTotalLength();
    }

    public Storage(I2PSnarkUtil util, File baseFile, String announce, List<List<String>> announce_list, boolean privateTorrent, StorageListener listener) throws IOException {
        this._util = util;
        this._log = util.getContext().logManager().getLog(Storage.class);
        this.listener = listener;
        this.getFiles(baseFile);
        long total = 0L;
        ArrayList<Long> lengthsList = new ArrayList<Long>();
        for (int i = 0; i < this.lengths.length; ++i) {
            long length = this.lengths[i];
            total += length;
            lengthsList.add(length);
        }
        if (total <= 0L) {
            throw new IOException("Torrent contains no data");
        }
        if (total > 0xA00000000L) {
            throw new IOException("Torrent too big (" + total + " bytes), max is " + 0xA00000000L);
        }
        int pc_size = total <= 0x500000L ? 65536 : (total <= 0xA00000L ? 131072 : 262144);
        int pcs = (int)((total - 1L) / (long)pc_size) + 1;
        while (pcs > 6826 && pc_size < 0x400000) {
            pcs = (int)((total - 1L) / (long)(pc_size *= 2)) + 1;
        }
        this.piece_size = pc_size;
        this.pieces = pcs;
        this.total_length = total;
        this.bitfield = new BitField(this.pieces);
        this.needed = 0;
        ArrayList<List<String>> files = new ArrayList<List<String>>();
        for (int i = 0; i < this.names.length; ++i) {
            ArrayList<String> file = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.names[i], File.separator);
            while (st.hasMoreTokens()) {
                String part = st.nextToken();
                file.add(part);
            }
            files.add(file);
        }
        if (files.size() == 1 && !baseFile.isDirectory()) {
            files = null;
            lengthsList = null;
        }
        byte[] piece_hashes = this.fast_digestCreate();
        this.metainfo = new MetaInfo(announce, baseFile.getName(), null, files, lengthsList, this.piece_size, piece_hashes, total, privateTorrent, announce_list);
    }

    private byte[] fast_digestCreate() throws IOException {
        MessageDigest digest = SHA1.getInstance();
        byte[] piece_hashes = new byte[20 * this.pieces];
        byte[] piece = new byte[this.piece_size];
        for (int i = 0; i < this.pieces; ++i) {
            int length = this.getUncheckedPiece(i, piece);
            digest.update(piece, 0, length);
            byte[] hash = digest.digest();
            System.arraycopy(hash, 0, piece_hashes, 20 * i, 20);
            this.bitfield.set(i);
        }
        return piece_hashes;
    }

    private void getFiles(File base) throws IOException {
        if (base.getAbsolutePath().equals("/")) {
            throw new IOException("Don't seed root");
        }
        ArrayList files = new ArrayList();
        this.addFiles(files, base);
        int size = files.size();
        this.names = new String[size];
        this.lengths = new long[size];
        this.rafs = new RandomAccessFile[size];
        this.RAFlock = new Object[size];
        this.RAFtime = new long[size];
        this.RAFfile = new File[size];
        this.priorities = new int[size];
        this.isSparse = new boolean[size];
        int i = 0;
        for (File f : files) {
            this.names[i] = f.getPath();
            if (base.isDirectory() && this.names[i].startsWith(base.getPath())) {
                this.names[i] = this.names[i].substring(base.getPath().length() + 1);
            }
            this.lengths[i] = f.length();
            this.RAFlock[i] = new Object();
            this.RAFfile[i] = f;
            ++i;
        }
    }

    private void addFiles(List l, File f) throws IOException {
        if (!f.isDirectory()) {
            if (l.size() >= 512) {
                throw new IOException("Too many files, limit is 512, zip them?");
            }
            l.add(f);
        } else {
            File[] files = f.listFiles();
            if (files == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("WARNING: Skipping '" + f + "' not a normal file.");
                }
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                this.addFiles(l, files[i]);
            }
        }
    }

    public MetaInfo getMetaInfo() {
        return this.metainfo;
    }

    public int needed() {
        return this.needed;
    }

    public boolean complete() {
        return this.needed == 0;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isChecking() {
        return this._isChecking;
    }

    public boolean isAllocating() {
        return this._allocateCount.get() > 0;
    }

    public long remaining(String file) {
        long bytes = 0L;
        for (int i = 0; i < this.rafs.length; ++i) {
            File f = this.RAFfile[i];
            String canonical = null;
            if (f != null) {
                try {
                    canonical = f.getCanonicalPath();
                }
                catch (IOException ioe) {
                    f = null;
                }
            }
            if (f != null && canonical.equals(file)) {
                if (this.complete()) {
                    return 0L;
                }
                int psz = this.piece_size;
                long start = bytes;
                long end = start + this.lengths[i];
                int pc = (int)(bytes / (long)psz);
                long rv = 0L;
                if (!this.bitfield.get(pc)) {
                    rv = Math.min((long)psz - start % (long)psz, this.lengths[i]);
                }
                for (int j = pc + 1; (long)j * (long)psz < end && j < this.pieces; ++j) {
                    if (this.bitfield.get(j)) continue;
                    if ((long)(j + 1) * (long)psz < end) {
                        rv += (long)psz;
                        continue;
                    }
                    rv += end - (long)j * (long)psz;
                }
                return rv;
            }
            bytes += this.lengths[i];
        }
        return -1L;
    }

    public int getPriority(String file) {
        if (this.complete() || this.metainfo.getFiles() == null || this.priorities == null) {
            return 0;
        }
        for (int i = 0; i < this.rafs.length; ++i) {
            File f = this.RAFfile[i];
            if (f == null) continue;
            try {
                String canonical = f.getCanonicalPath();
                if (!canonical.equals(file)) continue;
                return this.priorities[i];
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 0;
    }

    public void setPriority(String file, int pri) {
        if (this.complete() || this.metainfo.getFiles() == null || this.priorities == null) {
            return;
        }
        for (int i = 0; i < this.rafs.length; ++i) {
            File f = this.RAFfile[i];
            if (f == null) continue;
            try {
                String canonical = f.getCanonicalPath();
                if (!canonical.equals(file)) continue;
                this.priorities[i] = pri;
                return;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public int[] getFilePriorities() {
        return this.priorities;
    }

    void setFilePriorities(int[] p) {
        this.priorities = p;
    }

    public int[] getPiecePriorities() {
        if (this.complete() || this.metainfo.getFiles() == null || this.priorities == null) {
            return null;
        }
        int[] rv = new int[this.metainfo.getPieces()];
        int file = 0;
        long pcEnd = -1L;
        long fileEnd = this.lengths[0] - 1L;
        int psz = this.piece_size;
        for (int i = 0; i < rv.length; ++i) {
            pcEnd += (long)psz;
            int pri = this.priorities[file];
            while (fileEnd <= pcEnd && file < this.lengths.length - 1) {
                long oldFileEnd = fileEnd;
                fileEnd += this.lengths[++file];
                if (this.priorities[file] <= pri || oldFileEnd >= pcEnd) continue;
                pri = this.priorities[file];
            }
            rv[i] = pri;
        }
        return rv;
    }

    public BitField getBitField() {
        return this.bitfield;
    }

    public String getBaseName() {
        return Storage.filterName(this.metainfo.getName());
    }

    public void check(String rootDir) throws IOException {
        this.check(rootDir, 0L, null);
    }

    public void check(String rootDir, long savedTime, BitField savedBitField) throws IOException {
        boolean areFilesPublic = this._util.getFilesPublic();
        File base = areFilesPublic ? new File(rootDir, Storage.filterName(this.metainfo.getName())) : new SecureFile(rootDir, Storage.filterName(this.metainfo.getName()));
        boolean useSavedBitField = savedTime > 0L && savedBitField != null;
        List<List<String>> files = this.metainfo.getFiles();
        if (files == null) {
            long lm;
            if (this._log.shouldLog(20)) {
                this._log.info("Creating/Checking file: " + base);
            }
            if (!base.createNewFile() && !base.exists()) {
                throw new IOException("Could not create file " + base);
            }
            this.lengths = new long[1];
            this.rafs = new RandomAccessFile[1];
            this.names = new String[1];
            this.RAFlock = new Object[1];
            this.RAFtime = new long[1];
            this.RAFfile = new File[1];
            this.isSparse = new boolean[1];
            this.lengths[0] = this.metainfo.getTotalLength();
            this.RAFlock[0] = new Object();
            this.RAFfile[0] = base;
            if (useSavedBitField && ((lm = base.lastModified()) <= 0L || lm > savedTime)) {
                useSavedBitField = false;
            }
            this.names[0] = base.getName();
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info("Creating/Checking directory: " + base);
            }
            if (!base.mkdir() && !base.isDirectory()) {
                throw new IOException("Could not create directory " + base);
            }
            List<Long> ls = this.metainfo.getLengths();
            int size = files.size();
            long total = 0L;
            this.lengths = new long[size];
            this.rafs = new RandomAccessFile[size];
            this.names = new String[size];
            this.RAFlock = new Object[size];
            this.RAFtime = new long[size];
            this.RAFfile = new File[size];
            this.isSparse = new boolean[size];
            for (int i = 0; i < size; ++i) {
                long lm;
                List<String> path = files.get(i);
                File f = Storage.createFileFromNames(base, path, areFilesPublic);
                for (int j = 0; j < i; ++j) {
                    if (!f.equals(this.RAFfile[j])) continue;
                    int last = path.size() - 1;
                    String lastPath = (path = new ArrayList<String>(path)).get(last);
                    int dot = lastPath.lastIndexOf(46);
                    lastPath = dot >= 0 ? lastPath.substring(0, dot) + '_' + lastPath.substring(dot) : '_' + lastPath;
                    path.set(last, lastPath);
                    f = Storage.createFileFromNames(base, path, areFilesPublic);
                    j = 0;
                }
                this.lengths[i] = ls.get(i);
                this.RAFlock[i] = new Object();
                this.RAFfile[i] = f;
                total += this.lengths[i];
                if (useSavedBitField && ((lm = f.lastModified()) <= 0L || lm > savedTime)) {
                    useSavedBitField = false;
                }
                this.names[i] = f.getName();
            }
            long metalength = this.metainfo.getTotalLength();
            if (total != metalength) {
                throw new IOException("File lengths do not add up " + total + " != " + metalength);
            }
        }
        if (useSavedBitField) {
            this.bitfield = savedBitField;
            this.needed = this.metainfo.getPieces() - this.bitfield.count();
            this._probablyComplete = this.complete();
            if (this._log.shouldLog(20)) {
                this._log.info("Found saved state and files unchanged, skipping check");
            }
        } else {
            this.changed = true;
            this.checkCreateFiles(false);
        }
        if (this.complete()) {
            if (this._log.shouldLog(20)) {
                this._log.info("Torrent is complete");
            }
        } else {
            if (files != null) {
                this.priorities = new int[files.size()];
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Still need " + this.needed + " out of " + this.metainfo.getPieces() + " pieces");
            }
        }
    }

    public void reopen(String rootDir) throws IOException {
        if (this.RAFfile == null) {
            throw new IOException("Storage not checked yet");
        }
        for (int i = 0; i < this.RAFfile.length; ++i) {
            if (this.RAFfile[i].exists()) continue;
            throw new IOException("File does not exist: " + this.RAFfile[i]);
        }
    }

    public static String filterName(String name) {
        String rv = _filterNameCache.get(name);
        if (rv != null) {
            return rv;
        }
        if (name.equals(".") || name.equals(" ")) {
            rv = "_";
        } else {
            rv = name;
            if (rv.startsWith(".")) {
                rv = '_' + rv.substring(1);
            }
            if (rv.endsWith(".") || rv.endsWith(" ")) {
                rv = rv.substring(0, rv.length() - 1) + '_';
            }
            for (int i = 0; i < ILLEGAL.length; ++i) {
                if (rv.indexOf(ILLEGAL[i]) < 0) continue;
                rv = rv.replace(ILLEGAL[i], '_');
            }
            if (!Charset.defaultCharset().name().equals("UTF-8")) {
                try {
                    CharsetEncoder enc = Charset.defaultCharset().newEncoder();
                    if (!enc.canEncode(rv)) {
                        String repl = rv;
                        for (int i = 0; i < rv.length(); ++i) {
                            char c = rv.charAt(i);
                            if (enc.canEncode(c)) continue;
                            repl = repl.replace(c, '_');
                        }
                        rv = repl;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        _filterNameCache.put(name, rv);
        return rv;
    }

    private static File createFileFromNames(File base, List<String> names, boolean areFilesPublic) throws IOException {
        File f = null;
        Iterator<String> it = names.iterator();
        while (it.hasNext()) {
            String name = Storage.filterName(it.next());
            if (it.hasNext()) {
                f = areFilesPublic ? new File(base, name) : new SecureFile(base, name);
                if (!f.mkdir() && !f.isDirectory()) {
                    throw new IOException("Could not create directory " + f);
                }
                base = f;
                continue;
            }
            f = areFilesPublic ? new File(base, name) : new SecureFile(base, name);
            if (f.createNewFile() || f.exists()) continue;
            throw new IOException("Could not create file " + f);
        }
        return f;
    }

    public static File getFileFromNames(File base, List<String> names) {
        Iterator<String> it = names.iterator();
        while (it.hasNext()) {
            String name = Storage.filterName(it.next());
            base = new File(base, name);
        }
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCreateFiles(boolean recheck) throws IOException {
        Storage storage = this;
        synchronized (storage) {
            this._isChecking = true;
            try {
                this.locked_checkCreateFiles(recheck);
            }
            finally {
                this._isChecking = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locked_checkCreateFiles(boolean recheck) throws IOException {
        boolean resume = false;
        this._probablyComplete = true;
        int need = this.metainfo.getPieces();
        BitField bfield = recheck ? new BitField(need) : this.bitfield;
        for (int i = 0; i < this.rafs.length; ++i) {
            long length = this.RAFfile[i].length();
            if (this.RAFfile[i].exists() && length == this.lengths[i]) {
                if (this.listener != null) {
                    this.listener.storageAllocated(this, length);
                }
                resume = true;
                continue;
            }
            if (length == 0L) {
                this.changed = true;
                Object object = this.RAFlock[i];
                synchronized (object) {
                    this.allocateFile(i);
                    try {
                        this.closeRAF(i);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    continue;
                }
            }
            String msg = "File '" + this.names[i] + "' exists, but has wrong length (expected " + this.lengths[i] + " but found " + length + ") - repairing corruption";
            if (this.listener != null) {
                this.listener.addMessage(msg);
            }
            this._log.error(msg);
            this.changed = true;
            resume = true;
            this._probablyComplete = false;
            Object ioe = this.RAFlock[i];
            synchronized (ioe) {
                this.checkRAF(i);
                this.rafs[i].setLength(this.lengths[i]);
                try {
                    this.closeRAF(i);
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (resume) {
            byte[] piece = new byte[this.piece_size];
            int file = 0;
            long fileEnd = this.lengths[0];
            long pieceEnd = 0L;
            for (int i = 0; i < this.pieces; ++i) {
                int length = this.getUncheckedPiece(i, piece);
                boolean correctHash = this.metainfo.checkPiece(i, piece, 0, length);
                pieceEnd += (long)length;
                while (fileEnd <= pieceEnd) {
                    Object object = this.RAFlock[file];
                    synchronized (object) {
                        try {
                            this.closeRAF(file);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    if (++file >= this.rafs.length) break;
                    fileEnd += this.lengths[file];
                }
                if (correctHash) {
                    bfield.set(i);
                    --need;
                }
                if (this.listener == null) continue;
                this.listener.storageChecked(this, i, correctHash);
            }
        }
        this._probablyComplete = this.complete();
        this.needed = need;
        if (recheck && need > 0) {
            BitField bitField = this.bitfield;
            synchronized (bitField) {
                this.bitfield = bfield;
            }
        }
        if (this.listener != null) {
            this.listener.storageAllChecked(this);
            if (this.needed <= 0) {
                this.listener.storageCompleted(this);
            }
        }
    }

    private void allocateFile(int nr) throws IOException {
        this.openRAF(nr, false);
        long remaining = this.lengths[nr];
        if (this.listener != null) {
            this.listener.storageCreateFile(this, this.names[nr], remaining);
        }
        this.rafs[nr].setLength(remaining);
        if (!_isWindows) {
            this.isSparse[nr] = true;
        }
        if (this.listener != null) {
            this.listener.storageAllocated(this, this.lengths[nr]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void balloonFile(int nr) throws IOException {
        if (this._log.shouldLog(20)) {
            this._log.info("Ballooning " + nr + ": " + this.RAFfile[nr]);
        }
        long remaining = this.lengths[nr];
        int ZEROBLOCKSIZE = (int)Math.min(remaining, 32768L);
        byte[] zeros = new byte[ZEROBLOCKSIZE];
        this.rafs[nr].seek(0L);
        if (remaining > 0x1400000L) {
            this._allocateCount.incrementAndGet();
        }
        try {
            while (remaining > 0L) {
                int size = (int)Math.min(remaining, (long)ZEROBLOCKSIZE);
                this.rafs[nr].write(zeros, 0, size);
                remaining -= (long)size;
            }
        }
        finally {
            remaining = this.lengths[nr];
            if (remaining > 0x1400000L) {
                this._allocateCount.decrementAndGet();
            }
        }
        this.isSparse[nr] = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.rafs == null) {
            return;
        }
        for (int i = 0; i < this.rafs.length; ++i) {
            if (this.RAFlock[i] == null) continue;
            try {
                Object object = this.RAFlock[i];
                synchronized (object) {
                    this.closeRAF(i);
                    continue;
                }
            }
            catch (IOException ioe) {
                this._log.error("Error closing " + this.RAFfile[i], ioe);
            }
        }
        this.changed = false;
    }

    public ByteArray getPiece(int piece, int off, int len) throws IOException {
        ByteArray rv;
        if (!this.bitfield.get(piece)) {
            return null;
        }
        try {
            rv = len == 16384 ? _cache.acquire() : new ByteArray(new byte[len]);
        }
        catch (OutOfMemoryError oom) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Out of memory, can't honor request for piece " + piece, oom);
            }
            return null;
        }
        byte[] bs = rv.getData();
        this.getUncheckedPiece(piece, bs, off, len);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean putPiece(PartialPiece pp) throws IOException {
        int piece = pp.getPiece();
        try {
            int len;
            long start;
            BitField bitField = this.bitfield;
            // MONITORENTER : bitField
            if (this.bitfield.get(piece)) {
                boolean bl = true;
                // MONITOREXIT : bitField
                return bl;
            }
            // MONITOREXIT : bitField
            boolean correctHash = this.metainfo.checkPiece(pp);
            if (!correctHash) {
                if (this.listener != null) {
                    this.listener.storageChecked(this, piece, false);
                }
                boolean bl = false;
                return bl;
            }
            int i = 0;
            long raflen = this.lengths[i];
            for (start = (long)piece * (long)this.piece_size; start > raflen; start -= raflen) {
                raflen = this.lengths[++i];
            }
            int off = 0;
            int length = this.metainfo.getPieceLength(piece);
            for (int written = 0; written < length; written += len) {
                int need = length - written;
                len = start + (long)need < raflen ? need : (int)(raflen - start);
                Object object = this.RAFlock[i];
                // MONITORENTER : object
                this.checkRAF(i);
                if (this.isSparse[i]) {
                    if (this.priorities == null || this.priorities[i] >= 0) {
                        this.balloonFile(i);
                    } else {
                        this.isSparse[i] = false;
                    }
                }
                this.rafs[i].seek(start);
                pp.write(this.rafs[i], off + written, len);
                // MONITOREXIT : object
                if (need - len <= 0) continue;
                raflen = this.lengths[++i];
                start = 0L;
            }
        }
        finally {
            pp.release();
        }
        this.changed = true;
        boolean complete = false;
        BitField bitField = this.bitfield;
        // MONITORENTER : bitField
        if (!this.bitfield.get(piece)) {
            this.bitfield.set(piece);
            --this.needed;
            complete = this.needed == 0;
        }
        // MONITOREXIT : bitField
        if (this.listener != null) {
            this.listener.storageChecked(this, piece, true);
        }
        if (!complete) return true;
        this.checkCreateFiles(true);
        if (this.needed <= 0) return true;
        if (this.listener != null) {
            this.listener.setWantedPieces(this);
        }
        if (!this._log.shouldLog(30)) return true;
        this._log.warn("WARNING: Not really done, missing " + this.needed + " pieces");
        return true;
    }

    private int getPieceLength(int piece) {
        if (piece >= 0 && piece < this.pieces - 1) {
            return this.piece_size;
        }
        if (piece == this.pieces - 1) {
            return (int)(this.total_length - (long)piece * (long)this.piece_size);
        }
        throw new IndexOutOfBoundsException("no piece: " + piece);
    }

    private int getUncheckedPiece(int piece, byte[] bs) throws IOException {
        return this.getUncheckedPiece(piece, bs, 0, this.getPieceLength(piece));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUncheckedPiece(int piece, byte[] bs, int off, int length) throws IOException {
        int len;
        long start;
        int i = 0;
        long raflen = this.lengths[i];
        for (start = (long)piece * (long)this.piece_size + (long)off; start > raflen; start -= raflen) {
            raflen = this.lengths[++i];
        }
        for (int read = 0; read < length; read += len) {
            int need = length - read;
            len = start + (long)need < raflen ? need : (int)(raflen - start);
            Object object = this.RAFlock[i];
            synchronized (object) {
                this.checkRAF(i);
                this.rafs[i].seek(start);
                this.rafs[i].readFully(bs, read, len);
                continue;
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanRAFs() {
        long cutoff = System.currentTimeMillis() - 240000L;
        for (int i = 0; i < this.RAFlock.length; ++i) {
            Object object = this.RAFlock[i];
            synchronized (object) {
                if (this.RAFtime[i] > 0L && this.RAFtime[i] < cutoff) {
                    try {
                        this.closeRAF(i);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                continue;
            }
        }
    }

    private void checkRAF(int i) throws IOException {
        if (this.RAFtime[i] > 0L) {
            this.RAFtime[i] = System.currentTimeMillis();
            return;
        }
        this.openRAF(i);
    }

    private void openRAF(int i) throws IOException {
        this.openRAF(i, this._probablyComplete);
    }

    private void openRAF(int i, boolean readonly) throws IOException {
        this.rafs[i] = new RandomAccessFile(this.RAFfile[i], readonly || !this.RAFfile[i].canWrite() ? "r" : "rw");
        this.RAFtime[i] = System.currentTimeMillis();
    }

    private void closeRAF(int i) throws IOException {
        this.RAFtime[i] = 0L;
        if (this.rafs[i] == null) {
            return;
        }
        this.rafs[i].close();
        this.rafs[i] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Usage: Storage file-or-dir [announceURL]");
            System.exit(1);
        }
        File base = new File(args[0]);
        String announce = args.length == 2 ? args[1] : null;
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        I2PSnarkUtil util = new I2PSnarkUtil(ctx);
        File file = null;
        FileOutputStream out = null;
        try {
            Storage storage = new Storage(util, base, announce, null, false, null);
            MetaInfo meta = storage.getMetaInfo();
            file = new File(storage.getBaseName() + ".torrent");
            out = new FileOutputStream(file);
            out.write(meta.getTorrentData());
            String hex = DataHelper.toString(meta.getInfoHash());
            System.out.println("Created:     " + file);
            System.out.println("InfoHash:    " + hex);
            String basename = base.getName().replace(" ", "%20");
            String magnet = "magnet:?xt=urn:btih:" + hex + "&dn=" + basename;
            if (announce != null) {
                magnet = magnet + "&tr=" + announce;
            }
            System.out.println("Magnet:      " + magnet);
        }
        catch (IOException ioe) {
            if (file != null) {
                file.delete();
            }
            ioe.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

