/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.util.Log;
import org.klomp.snark.BitField;
import org.klomp.snark.DataLoader;
import org.klomp.snark.ExtensionHandler;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.PartialPiece;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerConnectionIn;
import org.klomp.snark.PeerConnectionOut;
import org.klomp.snark.PeerListener;
import org.klomp.snark.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PeerState
implements DataLoader {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(PeerState.class);
    private final Peer peer;
    final PeerListener listener;
    private MetaInfo metainfo;
    volatile boolean interesting;
    volatile boolean choking = true;
    volatile boolean interested;
    volatile boolean choked = true;
    BitField bitfield;
    final PeerConnectionIn in;
    final PeerConnectionOut out;
    private final List<Request> outstandingRequests = new ArrayList<Request>();
    private Request lastRequest = null;
    private static final int MAX_PIPELINE = 5;
    private static final int MAX_PIPELINE_BYTES = 131072;
    public static final int PARTSIZE = 16384;
    private static final int MAX_PARTSIZE = 65536;
    private Request pendingRequest;

    PeerState(Peer peer, PeerListener listener, MetaInfo metainfo, PeerConnectionIn in, PeerConnectionOut out) {
        this.peer = peer;
        this.listener = listener;
        this.metainfo = metainfo;
        this.in = in;
        this.out = out;
    }

    void keepAliveMessage() {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " rcv alive");
        }
    }

    void chokeMessage(boolean choke) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " rcv " + (choke ? "" : "un") + "choked");
        }
        boolean resend = this.choked && !choke;
        this.choked = choke;
        this.listener.gotChoke(this.peer, choke);
        if (this.interesting && !this.choked) {
            this.request(resend);
        }
        if (this.choked) {
            this.out.cancelRequestMessages();
            List<Request> pcs = this.returnPartialPieces();
            if (!pcs.isEmpty()) {
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.peer + " got choked, returning partial pieces to the PeerCoordinator: " + pcs);
                }
                this.listener.savePartialPieces(this.peer, pcs);
            }
        }
    }

    void interestedMessage(boolean interest) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " rcv " + (interest ? "" : "un") + "interested");
        }
        this.interested = interest;
        this.listener.gotInterest(this.peer, interest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void haveMessage(int piece) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " rcv have(" + piece + ")");
        }
        if (this.metainfo == null) {
            return;
        }
        if (piece < 0 || piece >= this.metainfo.getPieces()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Got strange 'have: " + piece + "' message from " + this.peer);
            }
            return;
        }
        PeerState peerState = this;
        synchronized (peerState) {
            if (this.bitfield == null) {
                this.bitfield = new BitField(this.metainfo.getPieces());
            }
            this.bitfield.set(piece);
        }
        if (this.listener.gotHave(this.peer, piece)) {
            this.setInteresting(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bitfieldMessage(byte[] bitmap) {
        PeerState peerState = this;
        synchronized (peerState) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.peer + " rcv bitfield");
            }
            if (this.bitfield != null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Got unexpected bitfield message from " + this.peer);
                }
                return;
            }
            this.bitfield = this.metainfo == null ? new BitField(bitmap, bitmap.length * 8) : new BitField(bitmap, this.metainfo.getPieces());
        }
        if (this.metainfo == null) {
            return;
        }
        boolean interest = this.listener.gotBitField(this.peer, this.bitfield);
        this.setInteresting(interest);
        if (this.bitfield.complete() && !interest) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Disconnecting seed that connects to seeds: " + this.peer);
            }
            this.peer.disconnect(true);
        }
    }

    void requestMessage(int piece, int begin, int length) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " rcv request(" + piece + ", " + begin + ", " + length + ") ");
        }
        if (this.metainfo == null) {
            return;
        }
        if (this.choking) {
            if (this._log.shouldLog(20)) {
                this._log.info("Request received, but choking " + this.peer);
            }
            return;
        }
        if (piece < 0 || piece >= this.metainfo.getPieces() || begin < 0 || begin > this.metainfo.getPieceLength(piece) || length <= 0 || length > 65536) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Got strange 'request: " + piece + ", " + begin + ", " + length + "' message from " + this.peer);
            }
            return;
        }
        if (this.out.queuedBytes() + length > 131072) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Discarding request over pipeline limit from " + this.peer);
            }
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Queueing (" + piece + ", " + begin + ", " + length + ")" + " to " + this.peer);
        }
        this.out.sendPiece(piece, begin, length, this);
    }

    @Override
    public ByteArray loadData(int piece, int begin, int length) {
        ByteArray pieceBytes = this.listener.gotRequest(this.peer, piece, begin, length);
        if (pieceBytes == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Got request for unknown piece: " + piece);
            }
            return null;
        }
        if (length != pieceBytes.getData().length) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Got out of range 'request: " + piece + ", " + begin + ", " + length + "' message from " + this.peer);
            }
            return null;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending (" + piece + ", " + begin + ", " + length + ")" + " to " + this.peer);
        }
        return pieceBytes;
    }

    void uploaded(int size) {
        this.peer.uploaded(size);
        this.listener.uploaded(this.peer, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pieceMessage(Request req) {
        int size = req.len;
        this.peer.downloaded(size);
        this.listener.downloaded(this.peer, size);
        if (this._log.shouldLog(10)) {
            this._log.debug("got end of Chunk(" + req.getPiece() + "," + req.off + "," + req.len + ") from " + this.peer);
        }
        if (this.getFirstOutstandingRequest(req.getPiece()) == -1) {
            if (this.listener.gotPiece(this.peer, req.getPartialPiece())) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Got " + req.getPiece() + ": " + this.peer);
                }
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Got BAD " + req.getPiece() + " from " + this.peer);
            }
        }
        PeerState peerState = this;
        synchronized (peerState) {
            this.pendingRequest = null;
        }
    }

    private synchronized int getFirstOutstandingRequest(int piece) {
        for (int i = 0; i < this.outstandingRequests.size(); ++i) {
            if (this.outstandingRequests.get(i).getPiece() != piece) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Request getOutstandingRequest(int piece, int begin, int length) {
        Request req;
        if (this._log.shouldLog(10)) {
            this._log.debug("got start of Chunk(" + piece + "," + begin + "," + length + ") from " + this.peer);
        }
        PeerState peerState = this;
        synchronized (peerState) {
            int r = this.getFirstOutstandingRequest(piece);
            if (r == -1) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Unrequested 'piece: " + piece + ", " + begin + ", " + length + "' received from " + this.peer);
                }
                return null;
            }
            req = this.outstandingRequests.get(r);
            while (req.getPiece() == piece && req.off != begin && r < this.outstandingRequests.size() - 1) {
                req = this.outstandingRequests.get(++r);
            }
            if (req.getPiece() != piece || req.off != begin || req.len != length) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Unrequested or unneeded 'piece: " + piece + ", " + begin + ", " + length + "' received from " + this.peer);
                }
                return null;
            }
            this.pendingRequest = req;
            if (r != 0) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Some requests dropped, got " + req + ", wanted for peer: " + this.peer);
                }
                for (int i = 0; i < r; ++i) {
                    Request dropReq = this.outstandingRequests.remove(0);
                    this.outstandingRequests.add(dropReq);
                    if (!this.choked) {
                        this.out.sendRequest(dropReq);
                    }
                    if (!this._log.shouldLog(30)) continue;
                    this._log.warn("dropped " + dropReq + " with peer " + this.peer);
                }
            }
            this.outstandingRequests.remove(0);
        }
        this.addRequest();
        return req;
    }

    private synchronized Request getLowestOutstandingRequest(int piece) {
        Request rv = null;
        int lowest = Integer.MAX_VALUE;
        for (Request r : this.outstandingRequests) {
            if (r.getPiece() != piece || r.off >= lowest) continue;
            lowest = r.off;
            rv = r;
        }
        if (this.pendingRequest != null && this.pendingRequest.getPiece() == piece && this.pendingRequest.off < lowest) {
            rv = this.pendingRequest;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " lowest for " + piece + " is " + rv + " out of " + this.pendingRequest + " and " + this.outstandingRequests);
        }
        return rv;
    }

    synchronized List<Request> returnPartialPieces() {
        Set<Integer> pcs = this.getRequestedPieces();
        ArrayList<Request> rv = new ArrayList<Request>(pcs.size());
        for (Integer p : pcs) {
            Request req = this.getLowestOutstandingRequest(p);
            if (req == null) continue;
            req.getPartialPiece().setDownloaded(req.off);
            rv.add(req);
        }
        this.outstandingRequests.clear();
        this.pendingRequest = null;
        this.lastRequest = null;
        return rv;
    }

    private synchronized Set<Integer> getRequestedPieces() {
        HashSet<Integer> rv = new HashSet<Integer>(this.outstandingRequests.size() + 1);
        for (Request req : this.outstandingRequests) {
            rv.add(req.getPiece());
            if (this.pendingRequest == null) continue;
            rv.add(this.pendingRequest.getPiece());
        }
        return rv;
    }

    void cancelMessage(int piece, int begin, int length) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Got cancel message (" + piece + ", " + begin + ", " + length + ")");
        }
        this.out.cancelRequest(piece, begin, length);
    }

    void extensionMessage(int id, byte[] bs) {
        if (this.metainfo != null && this.metainfo.isPrivate() && (id == 1 || id == 2)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Private torrent, ignoring ext msg " + id);
            }
            return;
        }
        ExtensionHandler.handleMessage(this.peer, this.listener, id, bs);
        this.listener.gotExtension(this.peer, id, bs);
    }

    public void setMetaInfo(MetaInfo meta) {
        if (this.metainfo != null) {
            return;
        }
        BitField oldBF = this.bitfield;
        if (oldBF != null && oldBF.size() != meta.getPieces()) {
            this.bitfield = new BitField(oldBF.getFieldBytes(), meta.getPieces());
        }
        this.metainfo = meta;
        if (this.bitfield != null && this.bitfield.count() > 0) {
            this.setInteresting(true);
        }
    }

    void portMessage(int port) {
        this.listener.gotPort(this.peer, port, port + 1);
    }

    void unknownMessage(int type, byte[] bs) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Warning: Ignoring unknown message type: " + type + " length: " + bs.length);
        }
    }

    void havePiece(int piece) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Tell " + this.peer + " havePiece(" + piece + ")");
        }
        this.cancelPiece(piece);
        this.out.sendHave(piece);
        this.addRequest();
    }

    synchronized void cancelPiece(int piece) {
        if (this.lastRequest != null && this.lastRequest.getPiece() == piece) {
            this.lastRequest = null;
        }
        Iterator<Request> it = this.outstandingRequests.iterator();
        while (it.hasNext()) {
            Request req = it.next();
            if (req.getPiece() != piece) continue;
            it.remove();
            this.out.sendCancel(req);
            req.getPartialPiece().release();
        }
    }

    synchronized boolean isRequesting(int piece) {
        if (this.pendingRequest != null && this.pendingRequest.getPiece() == piece) {
            return true;
        }
        for (Request req : this.outstandingRequests) {
            if (req.getPiece() != piece) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void request(boolean resend) {
        if (resend) {
            PeerState peerState = this;
            synchronized (peerState) {
                if (!this.outstandingRequests.isEmpty()) {
                    this.out.sendRequests(this.outstandingRequests);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Resending requests to " + this.peer + this.outstandingRequests);
                    }
                }
            }
        }
        this.addRequest();
    }

    synchronized void addRequest() {
        if (this.bitfield == null) {
            return;
        }
        if (this.metainfo == null) {
            return;
        }
        boolean more_pieces = true;
        while (more_pieces) {
            boolean isLastChunk;
            boolean bl = more_pieces = this.outstandingRequests.size() < 5;
            if (more_pieces && this.lastRequest == null) {
                if (!this.interesting) {
                    if (this.listener.needPiece(this.peer, this.bitfield)) {
                        this.setInteresting(true);
                        if (this._log.shouldLog(10)) {
                            this._log.debug(this.peer + " addRequest() we need something, setting interesting, delaying requestNextPiece()");
                        }
                    } else if (this._log.shouldLog(10)) {
                        this._log.debug(this.peer + " addRequest() needs nothing");
                    }
                    return;
                }
                if (this.choked) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.peer + " addRequest() we are choked, delaying requestNextPiece()");
                    }
                    return;
                }
                more_pieces = this.requestNextPiece();
                continue;
            }
            if (!more_pieces) continue;
            int pieceLength = this.metainfo.getPieceLength(this.lastRequest.getPiece());
            boolean bl2 = isLastChunk = this.lastRequest.off + this.lastRequest.len == pieceLength;
            if (isLastChunk) {
                more_pieces = this.requestNextPiece();
                continue;
            }
            PartialPiece nextPiece = this.lastRequest.getPartialPiece();
            int nextBegin = this.lastRequest.off + 16384;
            int maxLength = pieceLength - nextBegin;
            int nextLength = maxLength > 16384 ? 16384 : maxLength;
            Request req = new Request(nextPiece, nextBegin, nextLength);
            this.outstandingRequests.add(req);
            if (!this.choked) {
                this.out.sendRequest(req);
            }
            this.lastRequest = req;
        }
        if (this.interesting && this.lastRequest == null && this.outstandingRequests.isEmpty()) {
            this.setInteresting(false);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " requests " + this.outstandingRequests);
        }
    }

    private boolean requestNextPiece() {
        PartialPiece pp;
        if (this.bitfield != null && (pp = this.listener.getPartialPiece(this.peer, this.bitfield)) != null) {
            if (!this.getRequestedPieces().contains(pp.getPiece())) {
                Request r = pp.getRequest();
                this.outstandingRequests.add(r);
                if (!this.choked) {
                    this.out.sendRequest(r);
                }
                this.lastRequest = r;
                return true;
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Got dup from coord: " + pp);
            }
            pp.release();
        }
        if (this.outstandingRequests.isEmpty()) {
            this.lastRequest = null;
        }
        if (this.interesting && this.lastRequest == null) {
            this.interesting = false;
            this.out.sendInterest(false);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.peer + " nothing more to request, now uninteresting");
            }
        }
        return false;
    }

    synchronized void setInteresting(boolean interest) {
        if (interest != this.interesting) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.peer + " setInteresting(" + interest + ")");
            }
            this.interesting = interest;
            this.out.sendInterest(interest);
            if (this.interesting && !this.choked) {
                this.request(true);
            }
        }
    }

    synchronized void setChoking(boolean choke) {
        if (this.choking != choke) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.peer + " setChoking(" + choke + ")");
            }
            this.choking = choke;
            this.out.sendChoke(choke);
        }
    }

    void keepAlive() {
        this.out.sendAlive();
    }

    synchronized void retransmitRequests() {
        if (this.interesting && !this.choked) {
            this.out.retransmitRequests(this.outstandingRequests);
        }
    }

    synchronized String getRequests() {
        if (this.outstandingRequests.isEmpty()) {
            return null;
        }
        return this.outstandingRequests.toString();
    }
}

