/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.ClientMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.GarlicMessageReceiver;
import net.i2p.util.Log;

class InboundMessageDistributor
implements GarlicMessageReceiver.CloveReceiver {
    private final RouterContext _context;
    private final Log _log;
    private final Hash _client;
    private final GarlicMessageReceiver _receiver;

    public InboundMessageDistributor(RouterContext ctx, Hash client) {
        this._context = ctx;
        this._client = client;
        this._log = ctx.logManager().getLog(InboundMessageDistributor.class);
        this._receiver = new GarlicMessageReceiver(ctx, this, client);
    }

    public void distribute(I2NPMessage msg, Hash target) {
        this.distribute(msg, target, null);
    }

    public void distribute(I2NPMessage msg, Hash target, TunnelId tunnel) {
        int type = msg.getType();
        if (this._client != null && type == 3 && this._client.equals((Object)((DatabaseSearchReplyMessage)msg).getSearchKey())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Removing replies from a DSRM down a tunnel for " + this._client + ": " + msg);
            }
            DatabaseSearchReplyMessage orig = (DatabaseSearchReplyMessage)msg;
            DatabaseSearchReplyMessage newMsg = new DatabaseSearchReplyMessage(this._context);
            newMsg.setFromHash(orig.getFromHash());
            newMsg.setSearchKey(orig.getSearchKey());
            msg = newMsg;
        } else {
            if (this._client != null && type == 1 && ((DatabaseStoreMessage)msg).getEntry().getType() == 0) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping DSM down a tunnel for " + this._client + ": " + msg);
                }
                return;
            }
            if (!(this._client == null || type == 10 || type == 11 || type == 1 && this._client.equals((Object)((DatabaseStoreMessage)msg).getKey()) && ((DatabaseStoreMessage)msg).getReplyToken() == 0L || type == 22 || type == 24)) {
                this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, (long)type);
                this._log.error("Dropped dangerous message down a tunnel for " + this._client + ": " + msg, (Throwable)new Exception("cause"));
                return;
            }
        }
        if (target == null || tunnel == null && this._context.routerHash().equals((Object)target)) {
            if (type == 11) {
                this._context.inNetMessagePool().handleReplies(msg);
                if (this._log.shouldLog(10)) {
                    this._log.debug("received garlic message in the tunnel, parse it out");
                }
                this._receiver.receive((GarlicMessage)msg);
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("distributing inbound tunnel message into our inNetMessagePool: " + msg);
                }
                this._context.inNetMessagePool().add(msg, null, null);
            }
        } else {
            TunnelId outId;
            TunnelInfo out = this._context.tunnelManager().selectOutboundTunnel(this._client);
            if (out == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("no outbound tunnel to send the client message for " + this._client + ": " + msg);
                }
                return;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("distributing inbound tunnel message back out " + out + " targetting " + target);
            }
            if ((outId = out.getSendTunnelId(0)) == null) {
                if (this._log.shouldLog(40)) {
                    this._log.error("wtf, outbound tunnel has no outboundId? " + out + " failing to distribute " + msg);
                }
                return;
            }
            if (msg.getMessageExpiration() < this._context.clock().now() + 10000L) {
                msg.setMessageExpiration(this._context.clock().now() + 10000L);
            }
            this._context.tunnelDispatcher().dispatchOutbound(msg, outId, tunnel, target);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleClove(DeliveryInstructions instructions, I2NPMessage data) {
        switch (instructions.getDeliveryMode()) {
            case 0: {
                if (this._log.shouldLog(10)) {
                    this._log.debug("local delivery instructions for clove: " + data.getClass().getName());
                }
                if (data instanceof GarlicMessage) {
                    this._receiver.receive((GarlicMessage)data);
                    return;
                }
                if (data instanceof DatabaseStoreMessage) {
                    DatabaseStoreMessage dsm = (DatabaseStoreMessage)data;
                    try {
                        if (dsm.getEntry().getType() == 1) {
                            LeaseSet ls = (LeaseSet)dsm.getEntry();
                            LeaseSet old = this._context.netDb().store(dsm.getKey(), ls);
                            if (old != null && old.getReceivedAsPublished()) {
                                ls.setReceivedAsPublished(true);
                            }
                            if (!this._log.shouldLog(20)) return;
                            this._log.info("Storing LS for: " + dsm.getKey() + " sent to: " + this._client);
                            return;
                        }
                        if (this._client != null) {
                            this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, 1L);
                            this._log.error("Dropped dangerous message down a tunnel for " + this._client + ": " + dsm, (Throwable)new Exception("cause"));
                            return;
                        }
                        this._context.netDb().store(dsm.getKey(), (RouterInfo)dsm.getEntry());
                        return;
                    }
                    catch (IllegalArgumentException iae) {
                        if (!this._log.shouldLog(30)) return;
                        this._log.warn("Bad store attempt", (Throwable)iae);
                    }
                    return;
                }
                if (data instanceof DataMessage) {
                    this._context.statManager().addRateData("tunnel.handleLoadClove", 1L, 0L);
                    return;
                }
                if (this._client != null && data.getType() != 10) {
                    this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, (long)data.getType());
                    this._log.error("Dropped dangerous message down a tunnel for " + this._client + ": " + data, (Throwable)new Exception("cause"));
                    return;
                } else {
                    this._context.inNetMessagePool().add(data, null, null);
                }
                return;
            }
            case 1: {
                if (!(data instanceof DataMessage)) {
                    if (!this._log.shouldLog(40)) return;
                    this._log.error("cant send a " + data.getClass().getName() + " to a destination");
                    return;
                } else if (this._client != null && this._client.equals((Object)instructions.getDestination())) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("data message came down a tunnel for " + this._client);
                    }
                    DataMessage dm = (DataMessage)data;
                    Payload payload = new Payload();
                    payload.setEncryptedData(dm.getData());
                    ClientMessage m = new ClientMessage();
                    m.setDestinationHash(this._client);
                    m.setPayload(payload);
                    this._context.clientManager().messageReceived(m);
                    return;
                } else {
                    if (!this._log.shouldLog(40)) return;
                    this._log.error("this data message came down a tunnel for " + (this._client == null ? "no one" : this._client) + " but targetted " + instructions.getDestination());
                }
                return;
            }
            case 2: 
            case 3: {
                if (this._log.shouldLog(20)) {
                    this._log.info("clove targetted " + instructions.getRouter() + ":" + instructions.getTunnelId() + ", treat recursively to prevent leakage");
                }
                this.distribute(data, instructions.getRouter(), instructions.getTunnelId());
                return;
            }
        }
        if (!this._log.shouldLog(40)) return;
        this._log.error("Unknown instruction " + instructions.getDeliveryMode() + ": " + (Object)((Object)instructions));
    }
}

