/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.Job;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportEventListener;
import net.i2p.router.transport.TransportUtil;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransportImpl
implements Transport {
    private final Log _log;
    private TransportEventListener _listener;
    protected final List<RouterAddress> _currentAddresses;
    private final BlockingQueue<OutNetMessage> _sendPool;
    protected final RouterContext _context;
    private final Map<Hash, Long> _unreachableEntries;
    private final Set<Hash> _wasUnreachableEntries;
    private final Set<InetAddress> _localAddresses;
    private static final Map<Hash, byte[]> _IPMap;
    private static final int MAX_CONNECTION_FACTOR = 50;
    private static final int DEFAULT_CAPACITY_PCT = 75;
    protected static final boolean ADJUST_COST = true;
    protected static final int CONGESTION_COST_ADJUSTMENT = 1;
    private static final long UNREACHABLE_PERIOD = 300000L;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public TransportImpl(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(TransportImpl.class);
        this._context.statManager().createRateStat("transport.sendMessageFailureLifetime", "How long the lifetime of messages that fail are?", "Transport", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("transport.sendMessageSize", "Size of sent messages (bytes)", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("transport.receiveMessageSize", "Size of received messages (bytes)", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.receiveMessageTime", "How long it takes to read a message?", "Transport", new long[]{60000L, 300000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.receiveMessageTimeSlow", "How long it takes to read a message (when it takes more than a second)?", "Transport", new long[]{60000L, 300000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("transport.sendProcessingTime", "Time to process and send a message (ms)", "Transport", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.expiredOnQueueLifetime", "How long a message that expires on our outbound queue is processed", "Transport", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._currentAddresses = new CopyOnWriteArrayList<RouterAddress>();
        this._sendPool = this.getStyle().equals("NTCP") ? new ArrayBlockingQueue<OutNetMessage>(8) : null;
        this._unreachableEntries = new HashMap<Hash, Long>(16);
        this._wasUnreachableEntries = new ConcurrentHashSet(16);
        this._localAddresses = new ConcurrentHashSet(4);
        this._context.simpleScheduler().addPeriodicEvent((SimpleTimer.TimedEvent)new CleanupUnreachable(), 600000L, 150000L);
    }

    @Override
    public int countPeers() {
        return this.countActivePeers();
    }

    @Override
    public int countActivePeers() {
        return 0;
    }

    @Override
    public int countActiveSendPeers() {
        return 0;
    }

    public int getMaxConnections() {
        char bw;
        if (this._context.commSystem().isDummy()) {
            return 0;
        }
        String style = this.getStyle();
        String maxProp = style.equals("SSU") ? "i2np.udp.maxConnections" : (style.equals("NTCP") ? "i2np.ntcp.maxConnections" : "i2np." + style.toLowerCase(Locale.US) + ".maxConnections");
        int def = 50;
        RouterInfo ri = this._context.router().getRouterInfo();
        if (ri != null && (bw = ri.getBandwidthTier().charAt(0)) > 'K' && bw <= 'O') {
            def *= '\u0001' + bw - 75;
        }
        if (this._context.netDb().floodfillEnabled()) {
            def *= 17;
            def /= 10;
        }
        if (style.equals("SSU")) {
            def *= 3;
        }
        return this._context.getProperty(maxProp, def);
    }

    @Override
    public boolean haveCapacity() {
        return this.haveCapacity(75);
    }

    @Override
    public boolean haveCapacity(int pct) {
        return this.countPeers() < this.getMaxConnections() * pct / 100;
    }

    @Override
    public Vector getClockSkews() {
        return new Vector();
    }

    @Override
    public List<String> getMostRecentErrorMessages() {
        return Collections.EMPTY_LIST;
    }

    protected OutNetMessage getNextMessage() {
        OutNetMessage msg = (OutNetMessage)this._sendPool.poll();
        if (msg != null) {
            msg.beginSend();
        }
        return msg;
    }

    protected void afterSend(OutNetMessage msg, boolean sendSuccessful) {
        this.afterSend(msg, sendSuccessful, true, 0L);
    }

    protected void afterSend(OutNetMessage msg, boolean sendSuccessful, boolean allowRequeue) {
        this.afterSend(msg, sendSuccessful, allowRequeue, 0L);
    }

    protected void afterSend(OutNetMessage msg, boolean sendSuccessful, long msToSend) {
        this.afterSend(msg, sendSuccessful, true, msToSend);
    }

    protected void afterSend(OutNetMessage msg, boolean sendSuccessful, boolean allowRequeue, long msToSend) {
        long lifetime;
        boolean log = false;
        if (sendSuccessful) {
            msg.timestamp("afterSend(successful)");
        } else {
            msg.timestamp("afterSend(failed)");
        }
        if (!sendSuccessful) {
            msg.transportFailed(this.getStyle());
        }
        if (msToSend > 1500L && this._log.shouldLog(20)) {
            this._log.warn(this.getStyle() + " afterSend slow: " + (sendSuccessful ? "success " : "FAIL ") + msg.getMessageSize() + " byte " + msg.getMessageType() + ' ' + msg.getMessageId() + " to " + msg.getTarget().getIdentity().calculateHash().toBase64().substring(0, 6) + " took " + msToSend + " ms");
        }
        if ((lifetime = msg.getLifetime()) > 3000L) {
            int level = 30;
            if (!sendSuccessful) {
                level = 20;
            }
            if (this._log.shouldLog(level)) {
                this._log.log(level, this.getStyle() + " afterSend slow (" + (sendSuccessful ? "success " : "FAIL ") + lifetime + "/" + msToSend + "): " + msg.getMessageSize() + " byte " + msg.getMessageType() + " " + msg.getMessageId() + " from " + this._context.routerHash().toBase64().substring(0, 6) + " to " + msg.getTarget().getIdentity().calculateHash().toBase64().substring(0, 6) + ": " + msg.toString());
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info(this.getStyle() + " afterSend: " + (sendSuccessful ? "success " : "FAIL ") + msg.getMessageSize() + " byte " + msg.getMessageType() + " " + msg.getMessageId() + " from " + this._context.routerHash().toBase64().substring(0, 6) + " to " + msg.getTarget().getIdentity().calculateHash().toBase64().substring(0, 6) + "\n" + msg.toString());
        }
        if (sendSuccessful) {
            Job j;
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getStyle() + " Sent " + msg.getMessageType() + " successfully to " + msg.getTarget().getIdentity().getHash().toBase64());
            }
            if ((j = msg.getOnSendJob()) != null) {
                this._context.jobQueue().addJob(j);
            }
            log = true;
            msg.discardData();
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getStyle() + " Failed to send " + msg.getMessageType() + " to " + msg.getTarget().getIdentity().getHash().toBase64() + " (details: " + msg + ')');
            }
            if (msg.getExpiration() < this._context.clock().now()) {
                this._context.statManager().addRateData("transport.expiredOnQueueLifetime", lifetime);
            }
            if (allowRequeue) {
                if ((msg.getExpiration() <= 0L || msg.getExpiration() > this._context.clock().now()) && msg.getMessage() != null) {
                    this._context.outNetMessagePool().add(msg);
                } else {
                    MessageSelector selector;
                    if (this._log.shouldLog(20)) {
                        this._log.info("No more time left (" + new Date(msg.getExpiration()) + ", expiring without sending successfully the " + msg.getMessageType());
                    }
                    if (msg.getOnFailedSendJob() != null) {
                        this._context.jobQueue().addJob(msg.getOnFailedSendJob());
                    }
                    if ((selector = msg.getReplySelector()) != null) {
                        this._context.messageRegistry().unregisterPending(msg);
                    }
                    log = true;
                    msg.discardData();
                }
            } else {
                MessageSelector selector = msg.getReplySelector();
                if (this._log.shouldLog(20)) {
                    this._log.info("Failed and no requeue allowed for a " + msg.getMessageSize() + " byte " + msg.getMessageType() + " message with selector " + selector, (Throwable)new Exception("fail cause"));
                }
                if (msg.getOnFailedSendJob() != null) {
                    this._context.jobQueue().addJob(msg.getOnFailedSendJob());
                }
                if (msg.getOnFailedReplyJob() != null) {
                    this._context.jobQueue().addJob(msg.getOnFailedReplyJob());
                }
                if (selector != null) {
                    this._context.messageRegistry().unregisterPending(msg);
                }
                log = true;
                msg.discardData();
            }
        }
        if (log) {
            // empty if block
        }
        long now = this._context.clock().now();
        long sendTime = now - msg.getSendBegin();
        long allTime = now - msg.getCreated();
        if (allTime > 5000L) {
            if (this._log.shouldLog(20)) {
                this._log.info("Took too long from preparation to afterSend(ok? " + sendSuccessful + "): " + allTime + "ms/" + sendTime + "ms after failing on: " + msg.getFailedTransports() + " and succeeding on " + this.getStyle());
            }
            if (allTime > 60000L && sendSuccessful) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("WTF, more than a minute slow? " + msg.getMessageType() + " of id " + msg.getMessageId() + " (send begin on " + new Date(msg.getSendBegin()) + " / created on " + new Date(msg.getCreated()) + "): " + msg);
                }
                this._context.messageHistory().messageProcessingError(msg.getMessageId(), msg.getMessageType(), "Took too long to send [" + allTime + "ms]");
            }
        }
        if (sendSuccessful) {
            this._context.statManager().addRateData("transport.sendProcessingTime", lifetime);
            this._context.profileManager().messageSent(msg.getTarget().getIdentity().getHash(), this.getStyle(), sendTime, msg.getMessageSize());
            this._context.statManager().addRateData("transport.sendMessageSize", msg.getMessageSize(), sendTime);
        } else {
            this._context.profileManager().messageFailed(msg.getTarget().getIdentity().getHash(), this.getStyle());
            this._context.statManager().addRateData("transport.sendMessageFailureLifetime", lifetime);
        }
    }

    @Override
    public void send(OutNetMessage msg) {
        if (msg.getTarget() == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error - bad message enqueued [target is null]: " + msg, (Throwable)new Exception("Added by"));
            }
            return;
        }
        try {
            this._sendPool.put(msg);
        }
        catch (InterruptedException ie) {
            if (this._log.shouldLog(40)) {
                this._log.error("Interrupted during send " + msg);
            }
            return;
        }
        this.outboundMessageReady();
    }

    protected abstract void outboundMessageReady();

    public void messageReceived(I2NPMessage inMsg, RouterIdentity remoteIdent, Hash remoteIdentHash, long msToReceive, int bytesReceived) {
        int level = 20;
        if (msToReceive > 5000L) {
            level = 30;
        }
        if (this._log.shouldLog(level)) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Message received: ").append(inMsg.getClass().getName());
            buf.append(" / ").append(inMsg.getUniqueId());
            buf.append(" in ").append(msToReceive).append("ms containing ");
            buf.append(bytesReceived).append(" bytes ");
            buf.append(" from ");
            if (remoteIdentHash != null) {
                buf.append(remoteIdentHash.toBase64());
            } else if (remoteIdent != null) {
                buf.append(remoteIdent.getHash().toBase64());
            } else {
                buf.append("[unknown]");
            }
            buf.append(" and forwarding to listener: ");
            if (this._listener != null) {
                buf.append(this._listener);
            }
            this._log.log(level, buf.toString());
        }
        if (remoteIdent != null) {
            remoteIdentHash = remoteIdent.getHash();
        }
        if (remoteIdentHash != null) {
            this._context.profileManager().messageReceived(remoteIdentHash, this.getStyle(), msToReceive, bytesReceived);
            this._context.statManager().addRateData("transport.receiveMessageSize", (long)bytesReceived, msToReceive);
        }
        this._context.statManager().addRateData("transport.receiveMessageTime", msToReceive);
        if (msToReceive > 1000L) {
            this._context.statManager().addRateData("transport.receiveMessageTimeSlow", msToReceive);
        }
        if (this._listener != null) {
            this._listener.messageReceived(inMsg, remoteIdent, remoteIdentHash);
        } else if (this._log.shouldLog(40)) {
            this._log.error("WTF! Null listener! this = " + this.toString(), (Throwable)new Exception("Null listener"));
        }
    }

    @Override
    public List<RouterAddress> getCurrentAddresses() {
        return this._currentAddresses;
    }

    public RouterAddress getCurrentAddress(boolean ipv6) {
        for (RouterAddress ra : this._currentAddresses) {
            if (ipv6 != TransportUtil.isIPv6(ra)) continue;
            return ra;
        }
        return null;
    }

    @Override
    public boolean hasCurrentAddress() {
        return !this._currentAddresses.isEmpty();
    }

    @Override
    public List<RouterAddress> updateAddress() {
        return this._currentAddresses;
    }

    protected void replaceAddress(RouterAddress address) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Replacing address with " + address, (Throwable)new Exception());
        }
        if (address == null) {
            this._currentAddresses.clear();
        } else {
            boolean isIPv6 = TransportUtil.isIPv6(address);
            for (RouterAddress ra : this._currentAddresses) {
                if (isIPv6 != TransportUtil.isIPv6(ra)) continue;
                this._currentAddresses.remove(ra);
            }
            this._currentAddresses.add(address);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn(this.getStyle() + " now has " + this._currentAddresses.size() + " addresses");
        }
        if (this._listener != null) {
            this._listener.transportAddressChanged();
        }
    }

    protected void saveLocalAddress(InetAddress address) {
        this._localAddresses.add(address);
    }

    protected Collection<InetAddress> getSavedLocalAddresses() {
        ArrayList<InetAddress> rv = new ArrayList<InetAddress>(this._localAddresses);
        this._localAddresses.clear();
        return rv;
    }

    protected List<RouterAddress> getTargetAddresses(RouterInfo target) {
        int adj;
        List rv = target.getTargetAddresses(this.getStyle());
        if (rv.isEmpty()) {
            return rv;
        }
        if (rv.size() > 1) {
            Collections.shuffle(rv, (Random)this._context.random());
        }
        TransportUtil.IPv6Config config = this.getIPv6Config();
        switch (config) {
            case IPV6_DISABLED: {
                adj = 10;
                break;
            }
            case IPV6_NOT_PREFERRED: {
                adj = 1;
                break;
            }
            default: {
                adj = 0;
                break;
            }
            case IPV6_PREFERRED: {
                adj = -1;
                break;
            }
            case IPV6_ONLY: {
                adj = -10;
            }
        }
        if (rv.size() > 1) {
            Collections.sort(rv, new AddrComparator(adj));
        }
        return rv;
    }

    @Override
    public void externalAddressReceived(Transport.AddressSource source, byte[] ip, int port) {
    }

    @Override
    public void forwardPortStatus(byte[] ip, int port, int externalPort, boolean success, String reason) {
    }

    @Override
    public int getRequestedPort() {
        return -1;
    }

    @Override
    public void setListener(TransportEventListener listener) {
        this._listener = listener;
    }

    public void renderStatusHTML(Writer out) throws IOException {
    }

    @Override
    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        this.renderStatusHTML(out);
    }

    @Override
    public short getReachabilityStatus() {
        return 5;
    }

    @Override
    public void recheckReachability() {
    }

    @Override
    public boolean isBacklogged(Hash dest) {
        return false;
    }

    @Override
    public boolean isEstablished(Hash dest) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnreachable(Hash peer) {
        long now = this._context.clock().now();
        Map<Hash, Long> map = this._unreachableEntries;
        synchronized (map) {
            Long when = this._unreachableEntries.get(peer);
            if (when == null) {
                return false;
            }
            if (when + 300000L < now) {
                this._unreachableEntries.remove(peer);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUnreachable(Hash peer) {
        long now = this._context.clock().now();
        Map<Hash, Long> map = this._unreachableEntries;
        synchronized (map) {
            this._unreachableEntries.put(peer, now);
        }
        this.markWasUnreachable(peer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markReachable(Hash peer, boolean isInbound) {
        this._context.banlist().unbanlistRouter(peer);
        Map<Hash, Long> map = this._unreachableEntries;
        synchronized (map) {
            this._unreachableEntries.remove(peer);
        }
        if (!isInbound) {
            this.markWasUnreachable(peer, false);
        }
    }

    @Override
    public boolean wasUnreachable(Hash peer) {
        if (this._wasUnreachableEntries.contains(peer)) {
            return true;
        }
        RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
        if (ri == null) {
            return false;
        }
        return null == ri.getTargetAddress(this.getStyle());
    }

    public void markWasUnreachable(Hash peer, boolean yes) {
        if (yes) {
            this._wasUnreachableEntries.add(peer);
        } else {
            this._wasUnreachableEntries.remove(peer);
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getStyle() + " setting wasUnreachable to " + yes + " for " + peer, (Throwable)(yes ? new Exception() : null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIP(Hash peer, byte[] ip) {
        byte[] old;
        Map<Hash, byte[]> map = _IPMap;
        synchronized (map) {
            old = _IPMap.put(peer, ip);
        }
        if (!DataHelper.eq((byte[])old, (byte[])ip)) {
            this._context.commSystem().queueLookup(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getIP(Hash peer) {
        Map<Hash, byte[]> map = _IPMap;
        synchronized (map) {
            return _IPMap.get(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCaches() {
        Map<Hash, byte[]> map = _IPMap;
        synchronized (map) {
            _IPMap.clear();
        }
    }

    protected TransportUtil.IPv6Config getIPv6Config() {
        return TransportUtil.getIPv6Config(this._context, this.getStyle());
    }

    protected boolean isPubliclyRoutable(byte[] addr) {
        TransportUtil.IPv6Config cfg = this.getIPv6Config();
        return TransportUtil.isPubliclyRoutable(addr, cfg != TransportUtil.IPv6Config.IPV6_ONLY, cfg != TransportUtil.IPv6Config.IPV6_DISABLED);
    }

    protected String _(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    protected String _(String s, Object o) {
        return Translate.getString((String)s, (Object)o, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    protected String ngettext(String s, String p, int n) {
        return Translate.getString((int)n, (String)s, (String)p, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        long min = 512L;
        long max = 4096L;
        int size = (int)Math.max(min, Math.min(max, 1L + maxMemory / 131072L));
        _IPMap = new LHMCache(size);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddrComparator
    implements Comparator<RouterAddress> {
        private final int adj;

        public AddrComparator(int ipv6Adjustment) {
            this.adj = ipv6Adjustment;
        }

        @Override
        public int compare(RouterAddress l, RouterAddress r) {
            int lc = l.getCost();
            int rc = r.getCost();
            byte[] lip = l.getIP();
            byte[] rip = r.getIP();
            if (lip == null) {
                lc += 20;
            } else if (lip.length == 16) {
                lc += this.adj;
            }
            if (rip == null) {
                rc += 20;
            } else if (rip.length == 16) {
                rc += this.adj;
            }
            if (lc > rc) {
                return 1;
            }
            if (lc < rc) {
                return -1;
            }
            return 0;
        }
    }

    private class CleanupUnreachable
    implements SimpleTimer.TimedEvent {
        private CleanupUnreachable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            long now = TransportImpl.this._context.clock().now();
            Map map = TransportImpl.this._unreachableEntries;
            synchronized (map) {
                Iterator iter = TransportImpl.this._unreachableEntries.values().iterator();
                while (iter.hasNext()) {
                    Long when = (Long)iter.next();
                    if (when + 300000L >= now) continue;
                    iter.remove();
                }
            }
        }
    }
}

