/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.CreateRouterInfoJob;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;

public class RebuildRouterInfoJob
extends JobImpl {
    private final Log _log;
    private static final long REBUILD_DELAY = 45000L;

    public RebuildRouterInfoJob(RouterContext context) {
        super(context);
        this._log = context.logManager().getLog(RebuildRouterInfoJob.class);
    }

    public String getName() {
        return "Rebuild Router Info";
    }

    public void runJob() {
        this._log.debug("Testing to rebuild router info");
        String infoFile = this.getContext().getProperty("router.info.location", "router.info");
        File info = new File(this.getContext().getRouterDir(), infoFile);
        String keyFilename = this.getContext().getProperty("router.keys.location", "router.keys");
        File keyFile = new File(this.getContext().getRouterDir(), keyFilename);
        if (!info.exists() || !keyFile.exists()) {
            this._log.info("Router info file [" + info.getAbsolutePath() + "] or private key file [" + keyFile.getAbsolutePath() + "] deleted, rebuilding");
            this.rebuildRouterInfo();
        } else {
            this._log.debug("Router info file [" + info.getAbsolutePath() + "] exists, not rebuilding");
        }
        this.getTiming().setStartAfter(this.getContext().clock().now() + 45000L);
        this.getContext().jobQueue().addJob(this);
    }

    void rebuildRouterInfo() {
        this.rebuildRouterInfo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebuildRouterInfo(boolean alreadyRunning) {
        this._log.debug("Rebuilding the new router info");
        RouterInfo info = null;
        String infoFilename = this.getContext().getProperty("router.info.location", "router.info");
        File infoFile = new File(this.getContext().getRouterDir(), infoFilename);
        String keyFilename = this.getContext().getProperty("router.keys.location", "router.keys");
        File keyFile = new File(this.getContext().getRouterDir(), keyFilename);
        if (keyFile.exists()) {
            RouterInfo oldinfo = this.getContext().router().getRouterInfo();
            if (oldinfo == null) {
                info = new RouterInfo();
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(keyFile);
                    PrivateKey privkey = new PrivateKey();
                    privkey.readBytes((InputStream)fis);
                    SigningPrivateKey signingPrivKey = new SigningPrivateKey();
                    signingPrivKey.readBytes((InputStream)fis);
                    PublicKey pubkey = new PublicKey();
                    pubkey.readBytes((InputStream)fis);
                    SigningPublicKey signingPubKey = new SigningPublicKey();
                    signingPubKey.readBytes((InputStream)fis);
                    RouterIdentity ident = new RouterIdentity();
                    Certificate cert = this.getContext().router().createCertificate();
                    ident.setCertificate(cert);
                    ident.setPublicKey(pubkey);
                    ident.setSigningPublicKey(signingPubKey);
                    info.setIdentity(ident);
                }
                catch (Exception e) {
                    this._log.log(50, "Error reading in the key data from " + keyFile.getAbsolutePath(), (Throwable)e);
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    fis = null;
                    keyFile.delete();
                    this.rebuildRouterInfo(alreadyRunning);
                    return;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            info = new RouterInfo(oldinfo);
            try {
                info.setAddresses(this.getContext().commSystem().createAddresses());
                Properties stats = this.getContext().statPublisher().publishStatistics();
                stats.setProperty("netId", "2");
                info.setOptions(stats);
                this.getContext().router().addCapabilities(info);
                info.setPublished(CreateRouterInfoJob.getCurrentPublishDate(this.getContext()));
                info.sign(this.getContext().keyManager().getSigningPrivateKey());
            }
            catch (DataFormatException dfe) {
                this._log.log(50, "Error rebuilding the new router info", (Throwable)dfe);
                return;
            }
            if (!info.isValid()) {
                this._log.log(50, "RouterInfo we just built is invalid: " + info, (Throwable)new Exception());
                return;
            }
            SecureFileOutputStream fos = null;
            Object object = this.getContext().router().routerInfoFileLock;
            synchronized (object) {
                try {
                    fos = new SecureFileOutputStream(infoFile);
                    info.writeBytes((OutputStream)fos);
                }
                catch (DataFormatException dfe) {
                    this._log.log(50, "Error rebuilding the router information", (Throwable)dfe);
                }
                catch (IOException ioe) {
                    this._log.log(50, "Error writing out the rebuilt router information", (Throwable)ioe);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
        this._log.warn("Private key file " + keyFile.getAbsolutePath() + " deleted!  Rebuilding a brand new router identity!");
        CreateRouterInfoJob j = new CreateRouterInfoJob(this.getContext(), null);
        info = j.createRouterInfo();
        this.getContext().router().setRouterInfo(info);
        this._log.info("Router info rebuilt and stored at " + infoFilename + " [" + info + "]");
    }
}

