/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Collection;
import java.util.Date;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.Log;

public class HandleFloodfillDatabaseStoreMessageJob
extends JobImpl {
    private final Log _log;
    private final DatabaseStoreMessage _message;
    private final RouterIdentity _from;
    private Hash _fromHash;
    private final FloodfillNetworkDatabaseFacade _facade;

    public HandleFloodfillDatabaseStoreMessageJob(RouterContext ctx, DatabaseStoreMessage receivedMessage, RouterIdentity from, Hash fromHash, FloodfillNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
        this._message = receivedMessage;
        this._from = from;
        this._fromHash = fromHash;
        this._facade = facade;
    }

    public void runJob() {
        Hash key;
        boolean wasNew;
        String invalidMessage;
        long recvBegin;
        block35: {
            recvBegin = System.currentTimeMillis();
            invalidMessage = null;
            wasNew = false;
            RouterInfo prevNetDb = null;
            key = this._message.getKey();
            DatabaseEntry entry = this._message.getEntry();
            if (entry.getType() == 1) {
                this.getContext().statManager().addRateData("netDb.storeLeaseSetHandled", 1L, 0L);
                if (this._log.shouldLog(20)) {
                    this._log.info("Handling dbStore of leaseset " + this._message);
                }
                try {
                    LeaseSet match;
                    if (this.getContext().clientManager().isLocal(key)) {
                        throw new IllegalArgumentException("Peer attempted to store local leaseSet: " + key.toBase64().substring(0, 4));
                    }
                    LeaseSet ls = (LeaseSet)entry;
                    if (!ls.getReceivedAsReply()) {
                        ls.setReceivedAsPublished(true);
                    }
                    if ((match = this.getContext().netDb().store(key, ls)) == null) {
                        wasNew = true;
                        break block35;
                    }
                    if (match.getEarliestLeaseDate() < ls.getEarliestLeaseDate()) {
                        wasNew = true;
                        if (match.getReceivedAsPublished()) {
                            ls.setReceivedAsPublished(true);
                        }
                        break block35;
                    }
                    wasNew = false;
                }
                catch (IllegalArgumentException iae) {
                    invalidMessage = iae.getMessage();
                }
            } else if (entry.getType() == 0) {
                RouterInfo ri = (RouterInfo)entry;
                this.getContext().statManager().addRateData("netDb.storeRouterInfoHandled", 1L, 0L);
                if (this._log.shouldLog(20)) {
                    this._log.info("Handling dbStore of router " + key + " with publishDate of " + new Date(ri.getPublished()));
                }
                try {
                    if (this.getContext().routerHash().equals((Object)key)) {
                        throw new IllegalArgumentException("Peer attempted to store our RouterInfo");
                    }
                    prevNetDb = this.getContext().netDb().store(key, ri);
                    boolean bl = wasNew = null == prevNetDb || prevNetDb.getPublished() < ri.getPublished();
                    if (wasNew) {
                        if (prevNetDb == null) {
                            if (!this.getContext().banlist().isBanlistedForever(key) && this.getContext().blocklist().isBlocklisted(key) && this._log.shouldLog(30)) {
                                this._log.warn("Blocklisting new peer " + key + ' ' + ri);
                            }
                        } else {
                            Collection oldAddr = prevNetDb.getAddresses();
                            Collection newAddr = ri.getAddresses();
                            if (!newAddr.equals(oldAddr) && !this.getContext().banlist().isBanlistedForever(key) && this.getContext().blocklist().isBlocklisted(key) && this._log.shouldLog(30)) {
                                this._log.warn("New address received, Blocklisting old peer " + key + ' ' + ri);
                            }
                        }
                    }
                    this.getContext().profileManager().heardAbout(key);
                }
                catch (IllegalArgumentException iae) {
                    invalidMessage = iae.getMessage();
                }
            } else if (this._log.shouldLog(40)) {
                this._log.error("Invalid DatabaseStoreMessage data type - " + entry.getType() + ": " + this._message);
            }
        }
        long recvEnd = System.currentTimeMillis();
        this.getContext().statManager().addRateData("netDb.storeRecvTime", recvEnd - recvBegin, 0L);
        if (this._message.getReplyToken() > 0L) {
            this.sendAck();
        }
        long ackEnd = System.currentTimeMillis();
        if (this._from != null) {
            this._fromHash = this._from.getHash();
        }
        if (this._fromHash != null) {
            if (invalidMessage == null) {
                this.getContext().profileManager().dbStoreReceived(this._fromHash, wasNew);
                this.getContext().statManager().addRateData("netDb.storeHandled", ackEnd - recvEnd, 0L);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Peer " + this._fromHash.toBase64() + " sent bad data: " + invalidMessage);
            }
        } else if (invalidMessage != null && this._log.shouldLog(30)) {
            this._log.warn("Unknown peer sent bad data: " + invalidMessage);
        }
        if (invalidMessage == null && this.getContext().netDb().floodfillEnabled() && this._message.getReplyToken() > 0L) {
            if (wasNew) {
                if (this._facade.shouldThrottleFlood(key)) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Too many recent stores, not flooding key: " + key);
                    }
                    this.getContext().statManager().addRateData("netDb.floodThrottled", 1L, 0L);
                    return;
                }
                long floodBegin = System.currentTimeMillis();
                this._facade.flood(this._message.getEntry());
                long floodEnd = System.currentTimeMillis();
                this.getContext().statManager().addRateData("netDb.storeFloodNew", floodEnd - floodBegin, 0L);
            } else {
                this.getContext().statManager().addRateData("netDb.storeFloodOld", 1L, 0L);
            }
        }
    }

    private void sendAck() {
        DeliveryStatusMessage msg = new DeliveryStatusMessage(this.getContext());
        msg.setMessageId(this._message.getReplyToken());
        msg.setArrival(this.getContext().clock().now());
        TunnelInfo outTunnel = this.selectOutboundTunnel();
        if (outTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound tunnel could be found");
            }
            return;
        }
        this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnel.getSendTunnelId(0), this._message.getReplyTunnel(), this._message.getReplyGateway());
    }

    private TunnelInfo selectOutboundTunnel() {
        return this.getContext().tunnelManager().selectOutboundTunnel();
    }

    public String getName() {
        return "Handle Database Store Message";
    }

    public void dropped() {
        this.getContext().messageHistory().messageProcessingError(this._message.getUniqueId(), this._message.getClass().getName(), "Dropped due to overload");
    }
}

