/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.networkdb.kademlia.SingleLookupJob;
import net.i2p.util.Log;

class FloodfillVerifyStoreJob
extends JobImpl {
    private final Log _log;
    private final Hash _key;
    private Hash _target;
    private final Hash _sentTo;
    private final FloodfillNetworkDatabaseFacade _facade;
    private long _expiration;
    private long _sendTime;
    private final long _published;
    private final boolean _isRouterInfo;
    private MessageWrapper.WrappedMessage _wrappedMessage;
    private final Set<Hash> _ignore;
    private static final int START_DELAY = 18000;
    private static final int START_DELAY_RAND = 9000;
    private static final int VERIFY_TIMEOUT = 20000;
    private static final int MAX_PEERS_TO_TRY = 4;

    public FloodfillVerifyStoreJob(RouterContext ctx, Hash key, long published, boolean isRouterInfo, Hash sentTo, FloodfillNetworkDatabaseFacade facade) {
        super(ctx);
        facade.verifyStarted(key);
        this._key = key;
        this._published = published;
        this._isRouterInfo = isRouterInfo;
        this._log = ctx.logManager().getLog(this.getClass());
        this._sentTo = sentTo;
        this._facade = facade;
        this._ignore = new HashSet<Hash>(4);
        if (sentTo != null) {
            this._ignore.add(this._sentTo);
        }
        this.getTiming().setStartAfter(ctx.clock().now() + 18000L + (long)ctx.random().nextInt(9000));
        this.getContext().statManager().createRateStat("netDb.floodfillVerifyOK", "How long a floodfill verify takes when it succeeds", "NetworkDatabase", new long[]{3600000L});
        this.getContext().statManager().createRateStat("netDb.floodfillVerifyFail", "How long a floodfill verify takes when it fails", "NetworkDatabase", new long[]{3600000L});
        this.getContext().statManager().createRateStat("netDb.floodfillVerifyTimeout", "How long a floodfill verify takes when it times out", "NetworkDatabase", new long[]{3600000L});
    }

    public String getName() {
        return "Verify netdb store";
    }

    public void runJob() {
        this._target = this.pickTarget();
        if (this._target == null) {
            this._facade.verifyFinished(this._key);
            return;
        }
        DatabaseLookupMessage lookup = this.buildLookup();
        if (lookup == null) {
            this._facade.verifyFinished(this._key);
            return;
        }
        TunnelInfo outTunnel = this._isRouterInfo || this.getContext().keyRing().get((Object)this._key) != null ? this.getContext().tunnelManager().selectOutboundExploratoryTunnel(this._target) : this.getContext().tunnelManager().selectOutboundTunnel(this._key, this._target);
        if (outTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound tunnels to verify a store");
            }
            this._facade.verifyFinished(this._key);
            return;
        }
        RouterInfo peer = this._facade.lookupRouterInfoLocally(this._target);
        if (peer == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Fail finding target RI");
            }
            this._facade.verifyFinished(this._key);
            return;
        }
        if (DatabaseLookupMessage.supportsEncryptedReplies(peer)) {
            MessageWrapper.OneTimeSession sess = MessageWrapper.generateSession(this.getContext());
            if (this._log.shouldLog(20)) {
                this._log.info("Requesting encrypted reply from " + this._target + ' ' + sess.key + ' ' + sess.tag);
            }
            lookup.setReplySession(sess.key, sess.tag);
        }
        Hash fromKey = this._isRouterInfo ? null : this._key;
        this._wrappedMessage = MessageWrapper.wrap(this.getContext(), (I2NPMessage)lookup, fromKey, peer);
        if (this._wrappedMessage == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Fail Garlic encrypting");
            }
            this._facade.verifyFinished(this._key);
            return;
        }
        GarlicMessage sent = this._wrappedMessage.getMessage();
        if (this._log.shouldLog(20)) {
            this._log.info("Starting verify (stored " + this._key + " to " + this._sentTo + "), asking " + this._target);
        }
        this._sendTime = this.getContext().clock().now();
        this._expiration = this._sendTime + 20000L;
        this.getContext().messageRegistry().registerPending(new VerifyReplySelector(), new VerifyReplyJob(this.getContext()), new VerifyTimeoutJob(this.getContext()), 20000);
        this.getContext().tunnelDispatcher().dispatchOutbound(sent, outTunnel.getSendTunnelId(0), this._target);
    }

    private Hash pickTarget() {
        Hash rkey = this.getContext().routingKeyGenerator().getRoutingKey(this._key);
        FloodfillPeerSelector sel = (FloodfillPeerSelector)this._facade.getPeerSelector();
        List<Hash> peers = sel.selectFloodfillParticipants(rkey, 1, this._ignore, this._facade.getKBuckets());
        if (!peers.isEmpty()) {
            return peers.get(0);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("No other peers to verify floodfill with, using the one we sent to");
        }
        return this._sentTo;
    }

    private DatabaseLookupMessage buildLookup() {
        TunnelInfo replyTunnelInfo = this._isRouterInfo || this.getContext().keyRing().get((Object)this._key) != null ? this.getContext().tunnelManager().selectInboundExploratoryTunnel(this._target) : this.getContext().tunnelManager().selectInboundTunnel(this._key, this._target);
        if (replyTunnelInfo == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No inbound tunnels to get a reply from!");
            }
            return null;
        }
        DatabaseLookupMessage m = new DatabaseLookupMessage(this.getContext(), true);
        m.setMessageExpiration(this.getContext().clock().now() + 20000L);
        m.setReplyTunnel(replyTunnelInfo.getReceiveTunnelId(0));
        m.setFrom(replyTunnelInfo.getPeer(0));
        m.setSearchKey(this._key);
        return m;
    }

    private void resend() {
        DatabaseEntry ds = this._facade.lookupLocally(this._key);
        if (ds != null) {
            HashSet<Hash> toSkip = new HashSet<Hash>(2);
            if (this._sentTo != null) {
                toSkip.add(this._sentTo);
            }
            if (this._target != null) {
                toSkip.add(this._target);
            }
            this._facade.sendStore(this._key, ds, null, null, 90000L, toSkip);
        }
    }

    private class VerifyReplyJob
    extends JobImpl
    implements ReplyJob {
        private I2NPMessage _message;

        public VerifyReplyJob(RouterContext ctx) {
            super(ctx);
        }

        public String getName() {
            return "Handle floodfill verification reply";
        }

        public void runJob() {
            long delay = this.getContext().clock().now() - FloodfillVerifyStoreJob.this._sendTime;
            if (FloodfillVerifyStoreJob.this._wrappedMessage != null) {
                FloodfillVerifyStoreJob.this._wrappedMessage.acked();
            }
            FloodfillVerifyStoreJob.this._facade.verifyFinished(FloodfillVerifyStoreJob.this._key);
            if (this._message instanceof DatabaseStoreMessage) {
                boolean success = false;
                DatabaseStoreMessage dsm = (DatabaseStoreMessage)this._message;
                boolean bl = success = dsm.getEntry().getDate() >= FloodfillVerifyStoreJob.this._published;
                if (success) {
                    this.getContext().profileManager().dbLookupSuccessful(FloodfillVerifyStoreJob.this._target, delay);
                    if (FloodfillVerifyStoreJob.this._sentTo != null) {
                        this.getContext().profileManager().dbStoreSuccessful(FloodfillVerifyStoreJob.this._sentTo);
                    }
                    this.getContext().statManager().addRateData("netDb.floodfillVerifyOK", delay, 0L);
                    if (FloodfillVerifyStoreJob.this._log.shouldLog(20)) {
                        FloodfillVerifyStoreJob.this._log.info("Verify success for " + FloodfillVerifyStoreJob.this._key);
                    }
                    return;
                }
                if (FloodfillVerifyStoreJob.this._log.shouldLog(30)) {
                    FloodfillVerifyStoreJob.this._log.warn("Verify failed (older) for " + FloodfillVerifyStoreJob.this._key);
                }
                if (FloodfillVerifyStoreJob.this._log.shouldLog(20)) {
                    FloodfillVerifyStoreJob.this._log.info("Rcvd older data: " + dsm.getEntry());
                }
            } else if (this._message instanceof DatabaseSearchReplyMessage) {
                DatabaseSearchReplyMessage dsrm = (DatabaseSearchReplyMessage)this._message;
                this.getContext().profileManager().dbLookupReply(FloodfillVerifyStoreJob.this._target, 0, dsrm.getNumReplies(), 0, 0, delay);
                if (FloodfillVerifyStoreJob.this._log.shouldLog(30)) {
                    FloodfillVerifyStoreJob.this._log.warn("Verify failed (DSRM) for " + FloodfillVerifyStoreJob.this._key);
                }
                if (FloodfillVerifyStoreJob.this._isRouterInfo) {
                    this.getContext().jobQueue().addJob(new SingleLookupJob(this.getContext(), dsrm));
                }
            }
            if (FloodfillVerifyStoreJob.this._sentTo != null) {
                this.getContext().profileManager().dbStoreFailed(FloodfillVerifyStoreJob.this._sentTo);
            }
            if (FloodfillVerifyStoreJob.this._target != null && !FloodfillVerifyStoreJob.this._target.equals((Object)FloodfillVerifyStoreJob.this._sentTo)) {
                this.getContext().profileManager().dbLookupFailed(FloodfillVerifyStoreJob.this._target);
            }
            this.getContext().statManager().addRateData("netDb.floodfillVerifyFail", delay, 0L);
            FloodfillVerifyStoreJob.this.resend();
        }

        public void setMessage(I2NPMessage message) {
            this._message = message;
        }
    }

    private class VerifyReplySelector
    implements MessageSelector {
        private VerifyReplySelector() {
        }

        public boolean continueMatching() {
            return false;
        }

        public long getExpiration() {
            return FloodfillVerifyStoreJob.this._expiration;
        }

        public boolean isMatch(I2NPMessage message) {
            if (message instanceof DatabaseStoreMessage) {
                DatabaseStoreMessage dsm = (DatabaseStoreMessage)message;
                return FloodfillVerifyStoreJob.this._key.equals((Object)dsm.getKey());
            }
            if (message instanceof DatabaseSearchReplyMessage) {
                DatabaseSearchReplyMessage dsrm = (DatabaseSearchReplyMessage)message;
                return FloodfillVerifyStoreJob.this._key.equals((Object)dsrm.getSearchKey());
            }
            return false;
        }
    }

    private class VerifyTimeoutJob
    extends JobImpl {
        public VerifyTimeoutJob(RouterContext ctx) {
            super(ctx);
        }

        public String getName() {
            return "Floodfill verification timeout";
        }

        public void runJob() {
            if (FloodfillVerifyStoreJob.this._wrappedMessage != null) {
                FloodfillVerifyStoreJob.this._wrappedMessage.fail();
            }
            this.getContext().profileManager().dbLookupFailed(FloodfillVerifyStoreJob.this._target);
            this.getContext().statManager().addRateData("netDb.floodfillVerifyTimeout", this.getContext().clock().now() - FloodfillVerifyStoreJob.this._sendTime, 0L);
            if (FloodfillVerifyStoreJob.this._log.shouldLog(30)) {
                FloodfillVerifyStoreJob.this._log.warn("Verify timed out for: " + FloodfillVerifyStoreJob.this._key);
            }
            if (FloodfillVerifyStoreJob.this._ignore.size() < 4) {
                FloodfillVerifyStoreJob.this._ignore.add(FloodfillVerifyStoreJob.this._target);
                FloodfillVerifyStoreJob.this.runJob();
            } else {
                FloodfillVerifyStoreJob.this._facade.verifyFinished(FloodfillVerifyStoreJob.this._key);
                FloodfillVerifyStoreJob.this.resend();
            }
        }
    }
}

