/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.i2p.data.Certificate;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DeliveryInstructions;

class GarlicConfig {
    private RouterInfo _recipient;
    private PublicKey _recipientPublicKey;
    private Certificate _cert;
    private long _id = -1L;
    private long _expiration = -1L;
    private final List<GarlicConfig> _cloveConfigs = new ArrayList<GarlicConfig>(4);
    private DeliveryInstructions _instructions;
    private static final String NL = System.getProperty("line.separator");

    public void setRecipient(RouterInfo info) {
        this._recipient = info;
    }

    public RouterInfo getRecipient() {
        return this._recipient;
    }

    public void setRecipientPublicKey(PublicKey recipientPublicKey) {
        this._recipientPublicKey = recipientPublicKey;
    }

    public PublicKey getRecipientPublicKey() {
        return this._recipientPublicKey;
    }

    public void setCertificate(Certificate cert) {
        this._cert = cert;
    }

    public Certificate getCertificate() {
        return this._cert;
    }

    public void setId(long id) {
        this._id = id;
    }

    public long getId() {
        return this._id;
    }

    public void setExpiration(long expiration) {
        this._expiration = expiration;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public void setDeliveryInstructions(DeliveryInstructions instructions) {
        this._instructions = instructions;
    }

    public DeliveryInstructions getDeliveryInstructions() {
        return this._instructions;
    }

    public void addClove(GarlicConfig config) {
        if (config != null) {
            this._cloveConfigs.add(config);
        }
    }

    public int getCloveCount() {
        return this._cloveConfigs.size();
    }

    public GarlicConfig getClove(int index) {
        return this._cloveConfigs.get(index);
    }

    public void clearCloves() {
        this._cloveConfigs.clear();
    }

    protected String getSubData() {
        return "";
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<garlicConfig>").append(NL);
        buf.append("<certificate>").append(this.getCertificate()).append("</certificate>").append(NL);
        buf.append("<instructions>").append((Object)this.getDeliveryInstructions()).append("</instructions>").append(NL);
        buf.append("<expiration>").append(new Date(this.getExpiration())).append("</expiration>").append(NL);
        buf.append("<garlicId>").append(this.getId()).append("</garlicId>").append(NL);
        buf.append("<recipient>").append(this.getRecipient()).append("</recipient>").append(NL);
        buf.append("<recipientPublicKey>").append(this.getRecipientPublicKey()).append("</recipientPublicKey>").append(NL);
        buf.append(this.getSubData());
        buf.append("<subcloves>").append(NL);
        for (int i = 0; i < this.getCloveCount(); ++i) {
            buf.append("<clove>").append(this.getClove(i)).append("</clove>").append(NL);
        }
        buf.append("</subcloves>").append(NL);
        buf.append("</garlicConfig>").append(NL);
        return buf.toString();
    }
}

