/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.gettext.GettextResource;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.util.ConcurrentHashSet;

public abstract class Translate {
    public static final String PROP_LANG = "routerconsole.lang";
    private static final String _localeLang = Locale.getDefault().getLanguage();
    private static final Map<String, ResourceBundle> _bundles = new ConcurrentHashMap<String, ResourceBundle>(2);
    private static final Set<String> _missing = new ConcurrentHashSet<String>(2);
    private static final String TEST_LANG = "xx";
    private static final String TEST_STRING = "XXXX";

    public static String getString(String key, I2PAppContext ctx, String bun) {
        String lang = Translate.getLanguage(ctx);
        if (lang.equals("en")) {
            return key;
        }
        if (lang.equals(TEST_LANG)) {
            return TEST_STRING;
        }
        if (key.equals("")) {
            return key;
        }
        ResourceBundle bundle = Translate.findBundle(bun, lang);
        if (bundle == null) {
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getString(String s, Object o, I2PAppContext ctx, String bun) {
        String lang = Translate.getLanguage(ctx);
        if (lang.equals(TEST_LANG)) {
            return "XXXX(" + o + ')' + TEST_STRING;
        }
        String x = Translate.getString(s, ctx, bun);
        Object[] oArray = new Object[]{o};
        try {
            MessageFormat fmt = new MessageFormat(x, new Locale(lang));
            return fmt.format(oArray, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Bad format: orig: \"" + s + "\" trans: \"" + x + "\" param: \"" + o + "\" lang: " + lang);
            return "FIXME: " + x + ' ' + o;
        }
    }

    public static String getString(String s, Object o, Object o2, I2PAppContext ctx, String bun) {
        String lang = Translate.getLanguage(ctx);
        if (lang.equals(TEST_LANG)) {
            return "XXXX(" + o + ',' + o2 + ')' + TEST_STRING;
        }
        String x = Translate.getString(s, ctx, bun);
        Object[] oArray = new Object[]{o, o2};
        try {
            MessageFormat fmt = new MessageFormat(x, new Locale(lang));
            return fmt.format(oArray, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Bad format: orig: \"" + s + "\" trans: \"" + x + "\" param1: \"" + o + "\" param2: \"" + o2 + "\" lang: " + lang);
            return "FIXME: " + x + ' ' + o + ',' + o2;
        }
    }

    public static String getString(int n, String s, String p, I2PAppContext ctx, String bun) {
        String lang = Translate.getLanguage(ctx);
        if (lang.equals(TEST_LANG)) {
            return "XXXX(" + n + ')' + TEST_STRING;
        }
        ResourceBundle bundle = null;
        if (!lang.equals("en")) {
            bundle = Translate.findBundle(bun, lang);
        }
        String x = bundle == null ? (n == 1 ? s : p) : GettextResource.ngettext(bundle, s, p, n);
        Object[] oArray = new Object[]{n};
        try {
            MessageFormat fmt = new MessageFormat(x, new Locale(lang));
            return fmt.format(oArray, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Bad format: sing: \"" + s + "\" plural: \"" + p + "\" lang: " + lang);
            return "FIXME: " + s + ' ' + p + ',' + n;
        }
    }

    public static String getLanguage(I2PAppContext ctx) {
        String lang = ctx.getProperty(PROP_LANG);
        if (lang == null || lang.length() <= 0) {
            lang = _localeLang;
        }
        return lang;
    }

    private static ResourceBundle findBundle(String bun, String lang) {
        String key = bun + '-' + lang;
        ResourceBundle rv = _bundles.get(key);
        if (rv == null && !_missing.contains(key)) {
            try {
                rv = ResourceBundle.getBundle(bun, new Locale(lang), Thread.currentThread().getContextClassLoader());
                if (rv != null) {
                    _bundles.put(key, rv);
                }
            }
            catch (MissingResourceException e) {
                _missing.add(key);
            }
        }
        return rv;
    }

    public static String getDisplayLanguage(String langCode, String dflt, I2PAppContext ctx, String bun) {
        String curLang = Translate.getLanguage(ctx);
        if (!"en".equals(curLang)) {
            String rv = Translate.getString(dflt, ctx, bun);
            if (!rv.equals(dflt)) {
                return rv;
            }
            Locale curLocale = new Locale(curLang);
            rv = new Locale(langCode).getDisplayLanguage(curLocale);
            if (rv.length() > 0 && !rv.equals(langCode)) {
                return rv;
            }
        }
        return dflt;
    }

    public static void clearCache() {
        _missing.clear();
    }
}

