/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.util.HashSet;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.Destination;
import net.i2p.data.SessionKey;
import net.i2p.data.i2cp.MessageId;
import net.i2p.util.Log;

class MessageState {
    private final I2PAppContext _context;
    private final Log _log;
    private final long _nonce;
    private final String _prefix;
    private MessageId _id;
    private final Set<Integer> _receivedStatus;
    private SessionKey _key;
    private SessionKey _newKey;
    private Set _tags;
    private Destination _to;
    private boolean _cancelled;
    private final long _created;
    private static long __stateId = 0L;
    private long _stateId = ++__stateId;

    public MessageState(I2PAppContext ctx, long nonce, String prefix) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(MessageState.class);
        this._nonce = nonce;
        this._prefix = prefix + "[" + this._stateId + "]: ";
        this._receivedStatus = new HashSet<Integer>();
        this._created = ctx.clock().now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(int status) {
        Set<Integer> set = this._receivedStatus;
        synchronized (set) {
            this._receivedStatus.add(status);
            this._receivedStatus.notifyAll();
        }
    }

    public void setMessageId(MessageId id) {
        this._id = id;
    }

    public MessageId getMessageId() {
        return this._id;
    }

    public long getNonce() {
        return this._nonce;
    }

    public void setKey(SessionKey key) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this._prefix + "Setting key [" + this._key + "] to [" + key + "]");
        }
        this._key = key;
    }

    public SessionKey getKey() {
        return this._key;
    }

    public void setNewKey(SessionKey key) {
        this._newKey = key;
    }

    public SessionKey getNewKey() {
        return this._newKey;
    }

    public void setTags(Set tags) {
        this._tags = tags;
    }

    public Set getTags() {
        return this._tags;
    }

    public void setTo(Destination dest) {
        this._to = dest;
    }

    public Destination getTo() {
        return this._to;
    }

    public long getElapsed() {
        return this._context.clock().now() - this._created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(int status, long expiration) {
        boolean found = false;
        while (!found) {
            if (this._cancelled) {
                return;
            }
            long timeToWait = expiration - this._context.clock().now();
            if (timeToWait <= 0L) {
                if (this._log.shouldLog(30)) {
                    this._log.warn(this._prefix + "Expired waiting for the status [" + status + "]");
                }
                return;
            }
            found = false;
            Set<Integer> set = this._receivedStatus;
            synchronized (set) {
                if (this.locked_isSuccess(status) || this.locked_isFailure(status)) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this._prefix + "Received a confirm (one way or the other)");
                    }
                    found = true;
                }
                if (!found) {
                    if (timeToWait > 5000L) {
                        timeToWait = 5000L;
                    }
                    try {
                        this._receivedStatus.wait(timeToWait);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private boolean locked_isSuccess(int wantedStatus) {
        boolean rv = false;
        if (this._log.shouldLog(10)) {
            this._log.debug(this._prefix + "isSuccess(" + wantedStatus + "): " + this._receivedStatus);
        }
        block8: for (Integer val : this._receivedStatus) {
            int recv = val;
            switch (recv) {
                case 3: {
                    if (this._log.shouldLog(30)) {
                        this._log.warn(this._prefix + "Received best effort failure after " + this.getElapsed() + " from " + this.toString());
                    }
                    rv = false;
                    continue block8;
                }
                case 5: {
                    if (this._log.shouldLog(30)) {
                        this._log.warn(this._prefix + "Received guaranteed failure after " + this.getElapsed() + " from " + this.toString());
                    }
                    rv = false;
                    continue block8;
                }
                case 1: {
                    if (wantedStatus == 1) {
                        return true;
                    }
                    if (!this._log.shouldLog(10)) continue block8;
                    this._log.debug(this._prefix + "Got accepted, but we're waiting for more from " + this.toString());
                    continue block8;
                }
                case 2: {
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this._prefix + "Received best effort success after " + this.getElapsed() + " from " + this.toString());
                    }
                    if (wantedStatus == recv) {
                        rv = true;
                        continue block8;
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this._prefix + "Not guaranteed success, but best effort after " + this.getElapsed() + " will do... from " + this.toString());
                    }
                    rv = true;
                    continue block8;
                }
                case 4: {
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this._prefix + "Received guaranteed success after " + this.getElapsed() + " from " + this.toString());
                    }
                    rv = true;
                    continue block8;
                }
                case -1: {
                    continue block8;
                }
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug(this._prefix + "Received something else [" + recv + "]...");
        }
        return rv;
    }

    private boolean locked_isFailure(int wantedStatus) {
        boolean rv = false;
        if (this._log.shouldLog(10)) {
            this._log.debug(this._prefix + "isFailure(" + wantedStatus + "): " + this._receivedStatus);
        }
        block8: for (Integer val : this._receivedStatus) {
            int recv = val;
            switch (recv) {
                case 3: {
                    if (this._log.shouldLog(10)) {
                        this._log.warn(this._prefix + "Received best effort failure after " + this.getElapsed() + " from " + this.toString());
                    }
                    rv = true;
                    continue block8;
                }
                case 5: {
                    if (this._log.shouldLog(10)) {
                        this._log.warn(this._prefix + "Received guaranteed failure after " + this.getElapsed() + " from " + this.toString());
                    }
                    rv = true;
                    continue block8;
                }
                case 1: {
                    if (wantedStatus == 1) {
                        rv = false;
                        continue block8;
                    }
                    if (!this._log.shouldLog(10)) continue block8;
                    this._log.debug(this._prefix + "Got accepted, but we're waiting for more from " + this.toString());
                    continue block8;
                }
                case 2: {
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this._prefix + "Received best effort success after " + this.getElapsed() + " from " + this.toString());
                    }
                    if (wantedStatus == recv) {
                        rv = false;
                        continue block8;
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this._prefix + "Not guaranteed success, but best effort after " + this.getElapsed() + " will do... from " + this.toString());
                    }
                    rv = false;
                    continue block8;
                }
                case 4: {
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this._prefix + "Received guaranteed success after " + this.getElapsed() + " from " + this.toString());
                    }
                    rv = false;
                    continue block8;
                }
                case -1: {
                    continue block8;
                }
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug(this._prefix + "Received something else [" + recv + "]...");
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean received(int status) {
        Set<Integer> set = this._receivedStatus;
        synchronized (set) {
            return this.locked_isSuccess(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this._cancelled = true;
        Set<Integer> set = this._receivedStatus;
        synchronized (set) {
            this._receivedStatus.notifyAll();
        }
    }
}

