/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class ACKSender
implements Runnable {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final PacketBuilder _builder;
    private final BlockingQueue<PeerState> _peersToACK;
    private volatile boolean _alive;
    private static final long POISON_PS = -9999999999L;
    static final int ACK_FREQUENCY = 350;

    public ACKSender(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(ACKSender.class);
        this._transport = transport;
        this._peersToACK = new LinkedBlockingQueue<PeerState>();
        this._builder = new PacketBuilder(this._context, transport);
        this._alive = true;
        this._context.statManager().createRateStat("udp.sendACKCount", "how many ack messages were sent to a peer", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.ackFrequency", "how long ago did we send an ACK to this peer?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendACKRemaining", "when we ack a peer, how many peers are left waiting to ack?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.abortACK", "How often do we schedule up an ACK send only to find it had already been sent (through piggyback)?", "udp", UDPTransport.RATES);
    }

    public void ackPeer(PeerState peer) {
        if (this._alive) {
            this._peersToACK.offer(peer);
        }
    }

    public synchronized void startup() {
        this._alive = true;
        this._peersToACK.clear();
        I2PThread t = new I2PThread((Runnable)this, "UDP ACK sender", true);
        t.start();
    }

    public synchronized void shutdown() {
        this._alive = false;
        PeerState poison = new PeerState(this._context, this._transport, null, 0, null, false);
        poison.setTheyRelayToUsAs(-9999999999L);
        this._peersToACK.offer(poison);
        for (int i = 1; i <= 5 && !this._peersToACK.isEmpty(); ++i) {
            try {
                Thread.sleep(i * 50);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._peersToACK.clear();
    }

    private static long ackFrequency(long timeSinceACK, long rtt) {
        if (timeSinceACK < 2000L) {
            return Math.max(rtt / 2L, 350L);
        }
        return 350L;
    }

    public void run() {
        HashSet<PeerState> notYet = new HashSet<PeerState>();
        while (this._alive) {
            PeerState peer = null;
            long now = 0L;
            long remaining = -1L;
            long wanted = 0L;
            while (this._alive) {
                PeerState cur = null;
                try {
                    cur = notYet.isEmpty() ? this._peersToACK.take() : (PeerState)this._peersToACK.poll();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (cur != null) {
                    if (cur.getTheyRelayToUsAs() == -9999999999L) {
                        return;
                    }
                    wanted = cur.getWantedACKSendSince();
                    now = this._context.clock().now();
                    long delta = wanted + ACKSender.ackFrequency(now - cur.getLastACKSend(), cur.getRTT()) - now;
                    if (wanted <= 0L) {
                        notYet.remove(cur);
                        continue;
                    }
                    if (delta <= 0L || cur.unsentACKThresholdReached()) {
                        peer = cur;
                        notYet.remove(cur);
                        try {
                            this._peersToACK.addAll(notYet);
                        }
                        catch (NoSuchElementException nsee) {
                            // empty catch block
                        }
                        notYet.clear();
                        break;
                    }
                    boolean added = notYet.add(cur);
                    if (!added || !this._log.shouldLog(10)) continue;
                    this._log.debug("Pending ACK (delta = " + delta + ") for " + cur);
                    continue;
                }
                if (notYet.isEmpty()) continue;
                try {
                    this._peersToACK.addAll(notYet);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("sleeping, pending size = " + notYet.size());
                }
                notYet.clear();
                try {
                    Thread.sleep(121L);
                }
                catch (InterruptedException ie) {}
            }
            if (peer == null) continue;
            long lastSend = peer.getLastACKSend();
            List<ACKBitfield> ackBitfields = peer.retrieveACKBitfields(false);
            if (wanted < 0L) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("wtf, why are we acking something they dont want?  remaining=" + remaining + ", peer=" + peer + ", bitfields=" + ackBitfields);
                continue;
            }
            if (!ackBitfields.isEmpty()) {
                this._context.statManager().addRateData("udp.sendACKCount", (long)ackBitfields.size());
                if (remaining > 0L) {
                    this._context.statManager().addRateData("udp.sendACKRemaining", remaining);
                }
                if (lastSend < 0L) {
                    lastSend = now - 1L;
                }
                this._context.statManager().addRateData("udp.ackFrequency", now - lastSend, now - wanted);
                UDPPacket ack = this._builder.buildACK(peer, ackBitfields);
                ack.markType(1);
                ack.setFragmentCount(-1);
                ack.setMessageType(42);
                if (this._log.shouldLog(20)) {
                    this._log.info("Sending ACK for " + ackBitfields);
                }
                this._transport.send(ack);
                if (wanted <= 0L || wanted > peer.getWantedACKSendSince()) continue;
                if (this._log.shouldLog(30)) {
                    this._log.warn("Rerequesting ACK for peer " + peer);
                }
                this.ackPeer(peer);
                continue;
            }
            this._context.statManager().addRateData("udp.abortACK", 1L);
        }
    }
}

