/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.Adler32;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.ntcp.EstablishState;
import net.i2p.router.transport.ntcp.EventPumper;
import net.i2p.router.transport.ntcp.NTCPAddress;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.router.util.PriBlockingQueue;
import net.i2p.util.ByteCache;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

class NTCPConnection {
    private final RouterContext _context;
    private final Log _log;
    private SocketChannel _chan;
    private SelectionKey _conKey;
    private final FIFOBandwidthLimiter.CompleteListener _inboundListener;
    private final FIFOBandwidthLimiter.CompleteListener _outboundListener;
    private final Queue<ByteBuffer> _readBufs;
    private final Queue<ByteBuffer> _writeBufs;
    private final Set<FIFOBandwidthLimiter.Request> _bwInRequests;
    private final Set<FIFOBandwidthLimiter.Request> _bwOutRequests;
    private boolean _established;
    private long _establishedOn;
    private EstablishState _establishState;
    private final NTCPTransport _transport;
    private final boolean _isInbound;
    private volatile boolean _closed;
    private NTCPAddress _remAddr;
    private RouterIdentity _remotePeer;
    private long _clockSkew;
    private final PriBlockingQueue<OutNetMessage> _outbound;
    private OutNetMessage _currentOutbound;
    private SessionKey _sessionKey;
    private byte[] _curReadBlock;
    private int _curReadBlockIndex;
    private final byte[] _decryptBlockBuf;
    private byte[] _prevReadBlock;
    private byte[] _prevWriteEnd;
    private final ReadState _curReadState;
    private long _messagesRead;
    private long _messagesWritten;
    private long _lastSendTime;
    private long _lastReceiveTime;
    private long _lastRateUpdated;
    private final long _created;
    private long _nextMetaTime;
    private int _consecutiveZeroReads;
    private static final int BLOCK_SIZE = 16;
    private static final int META_SIZE = 16;
    private final byte[] _meta = new byte[16];
    private boolean _sendingMeta;
    private long _nextInfoTime;
    private static final long STAT_UPDATE_TIME_MS = 30000L;
    private static final int META_FREQUENCY = 2700000;
    private static final int INFO_FREQUENCY = 5400000;
    public static final int BUFFER_SIZE = 16384;
    private static final int MAX_DATA_READ_BUFS = 16;
    private static final ByteCache _dataReadBufs = ByteCache.getInstance((int)16, (int)16384);
    public static final int MAX_MSG_SIZE = 16378;
    private static final int PRIORITY = 300;
    private static final boolean FAST_LARGE = true;
    private static final int MIN_BUFS = 4;
    private static final int MAX_BUFS = 16;
    private static int NUM_PREP_BUFS;
    private static final LinkedBlockingQueue<PrepBuffer> _bufs;
    private long _bytesReceived;
    private long _bytesSent;
    private long _lastBytesReceived;
    private long _lastBytesSent;
    private float _sendBps;
    private float _recvBps;
    private static final int MAX_HANDLERS = 4;
    private static final LinkedBlockingQueue<I2NPMessageHandler> _i2npHandlers;

    public NTCPConnection(RouterContext ctx, NTCPTransport transport, SocketChannel chan, SelectionKey key) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._created = System.currentTimeMillis();
        this._transport = transport;
        this._chan = chan;
        this._readBufs = new ConcurrentLinkedQueue<ByteBuffer>();
        this._writeBufs = new ConcurrentLinkedQueue<ByteBuffer>();
        this._bwInRequests = new ConcurrentHashSet(2);
        this._bwOutRequests = new ConcurrentHashSet(8);
        this._outbound = new PriBlockingQueue(ctx, "NTCP-Connection", 32);
        this._isInbound = true;
        this._decryptBlockBuf = new byte[16];
        this._curReadState = new ReadState();
        this._establishState = new EstablishState(ctx, transport, this);
        this._conKey = key;
        this._conKey.attach(this);
        this._inboundListener = new InboundListener();
        this._outboundListener = new OutboundListener();
        this.initialize();
    }

    public NTCPConnection(RouterContext ctx, NTCPTransport transport, RouterIdentity remotePeer, NTCPAddress remAddr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._created = System.currentTimeMillis();
        this._transport = transport;
        this._remotePeer = remotePeer;
        this._remAddr = remAddr;
        this._readBufs = new ConcurrentLinkedQueue<ByteBuffer>();
        this._writeBufs = new ConcurrentLinkedQueue<ByteBuffer>();
        this._bwInRequests = new ConcurrentHashSet(2);
        this._bwOutRequests = new ConcurrentHashSet(8);
        this._outbound = new PriBlockingQueue(ctx, "NTCP-Connection", 32);
        this._isInbound = false;
        this._decryptBlockBuf = new byte[16];
        this._curReadState = new ReadState();
        this._inboundListener = new InboundListener();
        this._outboundListener = new OutboundListener();
        this.initialize();
    }

    private void initialize() {
        this._lastSendTime = this._created;
        this._lastReceiveTime = this._created;
        this._lastRateUpdated = this._created;
        this._curReadBlock = new byte[16];
        this._prevReadBlock = new byte[16];
        this._transport.establishing(this);
    }

    public SocketChannel getChannel() {
        return this._chan;
    }

    public SelectionKey getKey() {
        return this._conKey;
    }

    public void setChannel(SocketChannel chan) {
        this._chan = chan;
    }

    public void setKey(SelectionKey key) {
        this._conKey = key;
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public boolean isEstablished() {
        return this._established;
    }

    public EstablishState getEstablishState() {
        return this._establishState;
    }

    public NTCPAddress getRemoteAddress() {
        return this._remAddr;
    }

    public RouterIdentity getRemotePeer() {
        return this._remotePeer;
    }

    public void setRemotePeer(RouterIdentity ident) {
        this._remotePeer = ident;
    }

    public synchronized void finishInboundEstablishment(SessionKey key, long clockSkew, byte[] prevWriteEnd, byte[] prevReadEnd) {
        this._sessionKey = key;
        this._clockSkew = clockSkew;
        this._prevWriteEnd = prevWriteEnd;
        System.arraycopy(prevReadEnd, prevReadEnd.length - 16, this._prevReadBlock, 0, 16);
        this._established = true;
        this._establishedOn = System.currentTimeMillis();
        this._transport.inboundEstablished(this);
        this._establishState = null;
        this._nextMetaTime = System.currentTimeMillis() + 1350000L + (long)this._context.random().nextInt(2700000);
        this._nextInfoTime = System.currentTimeMillis() + 2700000L + (long)this._context.random().nextInt(5400000);
    }

    public long getClockSkew() {
        return this._clockSkew;
    }

    public long getUptime() {
        if (!this._established) {
            return this.getTimeSinceCreated();
        }
        return System.currentTimeMillis() - this._establishedOn;
    }

    public long getMessagesSent() {
        return this._messagesWritten;
    }

    public long getMessagesReceived() {
        return this._messagesRead;
    }

    public long getOutboundQueueSize() {
        int queued = this._outbound.size();
        if (this._currentOutbound != null) {
            ++queued;
        }
        return queued;
    }

    public long getTimeSinceSend() {
        return System.currentTimeMillis() - this._lastSendTime;
    }

    public long getTimeSinceReceive() {
        return System.currentTimeMillis() - this._lastReceiveTime;
    }

    public long getTimeSinceCreated() {
        return System.currentTimeMillis() - this._created;
    }

    public void clearZeroRead() {
        this._consecutiveZeroReads = 0;
    }

    public int gotZeroRead() {
        return ++this._consecutiveZeroReads;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void close() {
        this.close(false);
    }

    public synchronized void close(boolean allowRequeue) {
        ByteBuffer bb;
        if (this._log.shouldLog(20)) {
            this._log.info("Closing connection " + this.toString(), (Throwable)new Exception("cause"));
        }
        this._closed = true;
        if (this._chan != null) {
            try {
                this._chan.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (this._conKey != null) {
            this._conKey.cancel();
        }
        this._establishState = null;
        this._transport.removeCon(this);
        this._transport.getReader().connectionClosed(this);
        this._transport.getWriter().connectionClosed(this);
        for (FIFOBandwidthLimiter.Request req : this._bwInRequests) {
            req.abort();
        }
        this._bwInRequests.clear();
        for (FIFOBandwidthLimiter.Request req : this._bwOutRequests) {
            req.abort();
        }
        this._bwOutRequests.clear();
        this._writeBufs.clear();
        while ((bb = this._readBufs.poll()) != null) {
            EventPumper.releaseBuf(bb);
        }
        ArrayList pending = new ArrayList();
        this._outbound.drainTo(pending);
        for (OutNetMessage msg : pending) {
            Object buf = msg.releasePreparationBuffer();
            if (buf != null) {
                NTCPConnection.releaseBuf((PrepBuffer)buf);
            }
            this._transport.afterSend(msg, false, allowRequeue, msg.getLifetime());
        }
        OutNetMessage msg = this._currentOutbound;
        if (msg != null) {
            Object buf = msg.releasePreparationBuffer();
            if (buf != null) {
                NTCPConnection.releaseBuf((PrepBuffer)buf);
            }
            this._transport.afterSend(msg, false, allowRequeue, msg.getLifetime());
        }
    }

    public void send(OutNetMessage msg) {
        boolean noOutbound;
        this.bufferedPrepare(msg);
        this._outbound.offer(msg);
        boolean bl = noOutbound = this._currentOutbound == null;
        if (this._established && noOutbound) {
            this._transport.getWriter().wantsWrite(this, "enqueued");
        }
    }

    public boolean isBacklogged() {
        return this._outbound.isBacklogged();
    }

    public boolean tooBacklogged() {
        if (this.getUptime() < 10000L) {
            return false;
        }
        if (this._outbound.isBacklogged()) {
            int size = this._outbound.size();
            if (this._log.shouldLog(30)) {
                int writeBufs = this._writeBufs.size();
                boolean currentOutboundSet = this._currentOutbound != null;
                try {
                    this._log.warn("Too backlogged: size is " + size + ", wantsWrite? " + (0 != (this._conKey.interestOps() & 4)) + ", currentOut set? " + currentOutboundSet + ", writeBufs: " + writeBufs + " on " + this.toString());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public void enqueueInfoMessage() {
        OutNetMessage infoMsg = new OutNetMessage(this._context);
        infoMsg.setExpiration(this._context.clock().now() + 10000L);
        DatabaseStoreMessage dsm = new DatabaseStoreMessage(this._context);
        dsm.setEntry((DatabaseEntry)this._context.router().getRouterInfo());
        infoMsg.setMessage(dsm);
        infoMsg.setPriority(300);
        RouterInfo target = this._context.netDb().lookupRouterInfoLocally(this._remotePeer.calculateHash());
        if (target != null) {
            infoMsg.setTarget(target);
            infoMsg.beginSend();
            this._context.statManager().addRateData("ntcp.infoMessageEnqueued", 1L);
            this.send(infoMsg);
        } else if (this._isInbound) {
            // empty if block
        }
    }

    public synchronized void finishOutboundEstablishment(SessionKey key, long clockSkew, byte[] prevWriteEnd, byte[] prevReadEnd) {
        if (this._log.shouldLog(10)) {
            this._log.debug("outbound established (key=" + key + " skew=" + clockSkew + " prevWriteEnd=" + Base64.encode((byte[])prevWriteEnd) + ")");
        }
        this._sessionKey = key;
        this._clockSkew = clockSkew;
        this._prevWriteEnd = prevWriteEnd;
        System.arraycopy(prevReadEnd, prevReadEnd.length - 16, this._prevReadBlock, 0, 16);
        if (this._log.shouldLog(10)) {
            this._log.debug("Outbound established, prevWriteEnd: " + Base64.encode((byte[])prevWriteEnd) + " prevReadEnd: " + Base64.encode((byte[])prevReadEnd));
        }
        this._established = true;
        this._establishedOn = System.currentTimeMillis();
        this._establishState = null;
        this._transport.markReachable(this.getRemotePeer().calculateHash(), false);
        boolean msgs = !this._outbound.isEmpty();
        this._nextMetaTime = System.currentTimeMillis() + 1350000L + (long)this._context.random().nextInt(2700000);
        this._nextInfoTime = System.currentTimeMillis() + 2700000L + (long)this._context.random().nextInt(5400000);
        if (msgs) {
            this._transport.getWriter().wantsWrite(this, "outbound established");
        }
    }

    synchronized void prepareNextWrite() {
        this.prepareNextWriteFast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNextWriteFast() {
        if (this._closed) {
            return;
        }
        if (!this._isInbound && !this._established) {
            if (this._establishState == null) {
                this._establishState = new EstablishState(this._context, this._transport, this);
                this._establishState.prepareOutbound();
            } else if (this._log.shouldLog(10)) {
                this._log.debug("prepare next write, but we have already prepared the first outbound and we are not yet established..." + this.toString());
            }
            return;
        }
        if (this._nextMetaTime <= System.currentTimeMillis()) {
            this.sendMeta();
            this._nextMetaTime = System.currentTimeMillis() + 1350000L + (long)this._context.random().nextInt(1350000);
        }
        OutNetMessage msg = null;
        PriBlockingQueue<OutNetMessage> priBlockingQueue = this._outbound;
        synchronized (priBlockingQueue) {
            if (this._currentOutbound != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("attempt for multiple outbound messages with " + System.identityHashCode(this._currentOutbound) + " already waiting and " + this._outbound.size() + " queued");
                }
                return;
            }
            msg = (OutNetMessage)this._outbound.poll();
            if (msg == null) {
                return;
            }
            this._currentOutbound = msg;
        }
        PrepBuffer buf = (PrepBuffer)msg.releasePreparationBuffer();
        if (buf == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Null prep buf for " + msg);
            }
            return;
        }
        this._context.aes().encrypt(buf.unencrypted, 0, buf.encrypted, 0, this._sessionKey, this._prevWriteEnd, 0, buf.unencryptedLength);
        System.arraycopy(buf.encrypted, buf.encrypted.length - 16, this._prevWriteEnd, 0, this._prevWriteEnd.length);
        this._transport.getPumper().wantsWrite(this, buf.encrypted);
        NTCPConnection.releaseBuf(buf);
        if (this._nextInfoTime <= System.currentTimeMillis()) {
            this.enqueueInfoMessage();
            this._nextInfoTime = System.currentTimeMillis() + 2700000L + (long)this._context.random().nextInt(5400000);
        }
    }

    private void bufferedPrepare(OutNetMessage msg) {
        PrepBuffer buf = NTCPConnection.acquireBuf();
        I2NPMessage m = msg.getMessage();
        int sz = buf.baseLength = m.toByteArray(buf.base);
        int min = 2 + sz + 4;
        int rem = min % 16;
        int padding = 0;
        if (rem > 0) {
            padding = 16 - rem;
        }
        buf.unencryptedLength = min + padding;
        DataHelper.toLong((byte[])buf.unencrypted, (int)0, (int)2, (long)sz);
        System.arraycopy(buf.base, 0, buf.unencrypted, 2, buf.baseLength);
        if (padding > 0) {
            this._context.random().nextBytes(buf.unencrypted, 2 + sz, padding);
        }
        buf.crc.update(buf.unencrypted, 0, buf.unencryptedLength - 4);
        long val = buf.crc.getValue();
        if (this._log.shouldLog(10)) {
            this._log.debug("Outbound message " + this._messagesWritten + " has crc " + val + " sz=" + sz + " rem=" + rem + " padding=" + padding);
        }
        DataHelper.toLong((byte[])buf.unencrypted, (int)(buf.unencryptedLength - 4), (int)4, (long)val);
        buf.encrypted = new byte[buf.unencryptedLength];
        msg.prepared(buf);
    }

    private static PrepBuffer acquireBuf() {
        PrepBuffer b = _bufs.poll();
        if (b == null) {
            b = new PrepBuffer();
        }
        return b;
    }

    private static void releaseBuf(PrepBuffer buf) {
        buf.init();
        _bufs.offer(buf);
    }

    public void outboundConnected() {
        this._conKey.interestOps(1);
        this._transport.getWriter().wantsWrite(this, "outbound connected");
    }

    private void removeIBRequest(FIFOBandwidthLimiter.Request req) {
        this._bwInRequests.remove(req);
    }

    private void addIBRequest(FIFOBandwidthLimiter.Request req) {
        this._bwInRequests.add(req);
    }

    private void removeOBRequest(FIFOBandwidthLimiter.Request req) {
        this._bwOutRequests.remove(req);
    }

    private void addOBRequest(FIFOBandwidthLimiter.Request req) {
        this._bwOutRequests.add(req);
    }

    public void queuedRecv(ByteBuffer buf, FIFOBandwidthLimiter.Request req) {
        req.attach(buf);
        req.setCompleteListener(this._inboundListener);
        this.addIBRequest(req);
    }

    public void queuedWrite(ByteBuffer buf, FIFOBandwidthLimiter.Request req) {
        req.attach(buf);
        req.setCompleteListener(this._outboundListener);
        this.addOBRequest(req);
    }

    public void recv(ByteBuffer buf) {
        this._bytesReceived += (long)buf.remaining();
        this._readBufs.offer(buf);
        this._transport.getReader().wantsRead(this);
        this.updateStats();
    }

    public void write(ByteBuffer buf) {
        this._writeBufs.offer(buf);
        this._transport.getPumper().wantsWrite(this);
    }

    public ByteBuffer getNextReadBuf() {
        return this._readBufs.poll();
    }

    public boolean isWriteBufEmpty() {
        return this._writeBufs.isEmpty();
    }

    public ByteBuffer getNextWriteBuf() {
        return this._writeBufs.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriteBuf(ByteBuffer buf) {
        boolean msgs;
        this._bytesSent += (long)buf.capacity();
        OutNetMessage msg = null;
        boolean clearMessage = false;
        if (this._sendingMeta && buf.capacity() == this._meta.length) {
            this._sendingMeta = false;
        } else {
            clearMessage = true;
        }
        this._writeBufs.remove(buf);
        if (clearMessage) {
            PriBlockingQueue<OutNetMessage> priBlockingQueue = this._outbound;
            synchronized (priBlockingQueue) {
                if (this._currentOutbound != null) {
                    msg = this._currentOutbound;
                    this._currentOutbound = null;
                }
            }
            if (msg != null) {
                this._lastSendTime = System.currentTimeMillis();
                this._context.statManager().addRateData("ntcp.sendTime", msg.getSendTime());
                if (this._log.shouldLog(20)) {
                    this._log.info("I2NP message " + this._messagesWritten + "/" + msg.getMessageId() + " sent after " + msg.getSendTime() + "/" + msg.getLifetime() + " with " + buf.capacity() + " bytes (uid=" + System.identityHashCode(msg) + " on " + this.toString() + ")");
                }
                ++this._messagesWritten;
                this._transport.sendComplete(msg);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("I2NP meta message sent completely");
        }
        boolean bl = msgs = !this._outbound.isEmpty() || this._currentOutbound != null;
        if (msgs) {
            this._transport.getWriter().wantsWrite(this, "write completed");
        }
        this.updateStats();
    }

    public float getSendRate() {
        return this._sendBps;
    }

    public float getRecvRate() {
        return this._recvBps;
    }

    private void updateStats() {
        long now = System.currentTimeMillis();
        long time = now - this._lastRateUpdated;
        if (time >= 30000L) {
            long totS = this._bytesSent;
            long totR = this._bytesReceived;
            long sent = totS - this._lastBytesSent;
            long recv = totR - this._lastBytesReceived;
            this._lastBytesSent = totS;
            this._lastBytesReceived = totR;
            this._lastRateUpdated = now;
            this._sendBps = 0.9f * this._sendBps + 0.1f * ((float)sent * 1000.0f) / (float)time;
            this._recvBps = 0.9f * this._recvBps + 0.1f * ((float)recv * 1000.0f) / (float)time;
        }
    }

    synchronized void recvEncryptedI2NP(ByteBuffer buf) {
        int tot;
        if (this._curReadBlockIndex == 0 && buf.hasArray() && (tot = buf.remaining()) >= 32 && tot % 16 == 0) {
            this.recvEncryptedFast(buf);
            return;
        }
        while (buf.hasRemaining() && !this._closed) {
            int want = Math.min(buf.remaining(), 16 - this._curReadBlockIndex);
            if (want > 0) {
                buf.get(this._curReadBlock, this._curReadBlockIndex, want);
                this._curReadBlockIndex += want;
            }
            if (this._curReadBlockIndex < 16) continue;
            this._context.aes().decryptBlock(this._curReadBlock, 0, this._sessionKey, this._decryptBlockBuf, 0);
            for (int i = 0; i < 16; ++i) {
                int n = i;
                this._decryptBlockBuf[n] = (byte)(this._decryptBlockBuf[n] ^ this._prevReadBlock[i]);
            }
            boolean ok = this.recvUnencryptedI2NP();
            if (!ok) {
                this._log.error("Read buffer " + System.identityHashCode(buf) + " contained corrupt data");
                this._context.statManager().addRateData("ntcp.corruptDecryptedI2NP", 1L);
                return;
            }
            byte[] swap = this._prevReadBlock;
            this._prevReadBlock = this._curReadBlock;
            this._curReadBlock = swap;
            this._curReadBlockIndex = 0;
        }
    }

    private void recvEncryptedFast(ByteBuffer buf) {
        int pos;
        byte[] array = buf.array();
        int end = pos + buf.remaining();
        boolean first = true;
        for (pos = buf.arrayOffset(); pos < end && !this._closed; pos += 16) {
            this._context.aes().decryptBlock(array, pos, this._sessionKey, this._decryptBlockBuf, 0);
            if (first) {
                for (int i = 0; i < 16; ++i) {
                    int n = i;
                    this._decryptBlockBuf[n] = (byte)(this._decryptBlockBuf[n] ^ this._prevReadBlock[i]);
                }
                first = false;
            } else {
                int start = pos - 16;
                for (int i = 0; i < 16; ++i) {
                    int n = i;
                    this._decryptBlockBuf[n] = (byte)(this._decryptBlockBuf[n] ^ array[start + i]);
                }
            }
            boolean ok = this.recvUnencryptedI2NP();
            if (ok) continue;
            this._log.error("Read buffer " + System.identityHashCode(buf) + " contained corrupt data");
            this._context.statManager().addRateData("ntcp.corruptDecryptedI2NP", 1L);
            return;
        }
        System.arraycopy(array, end - 16, this._prevReadBlock, 0, 16);
    }

    private boolean recvUnencryptedI2NP() {
        this._curReadState.receiveBlock(this._decryptBlockBuf);
        if (this._curReadState.getSize() > 16384) {
            this._log.error("I2NP message too big - size: " + this._curReadState.getSize() + " Dropping " + this.toString());
            this._context.statManager().addRateData("ntcp.corruptTooLargeI2NP", (long)this._curReadState.getSize());
            this.close();
            return false;
        }
        return true;
    }

    private void readMeta(byte[] unencrypted) {
        long ourTs = (this._context.clock().now() + 500L) / 1000L;
        long ts = DataHelper.fromLong((byte[])unencrypted, (int)2, (int)4);
        Adler32 crc = new Adler32();
        crc.update(unencrypted, 0, unencrypted.length - 4);
        long expected = crc.getValue();
        long read = DataHelper.fromLong((byte[])unencrypted, (int)(unencrypted.length - 4), (int)4);
        if (read != expected) {
            if (this._log.shouldLog(30)) {
                this._log.warn("I2NP metadata message had a bad CRC value");
            }
            this._context.statManager().addRateData("ntcp.corruptMetaCRC", 1L);
            this.close();
            return;
        }
        long newSkew = ourTs - ts;
        if (Math.abs(newSkew * 1000L) > 60000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer's skew jumped too far (from " + this._clockSkew + " s to " + newSkew + " s): " + this.toString());
            }
            this._context.statManager().addRateData("ntcp.corruptSkew", newSkew);
            this.close();
            return;
        }
        this._context.statManager().addRateData("ntcp.receiveMeta", newSkew);
        if (this._log.shouldLog(10)) {
            this._log.debug("Received NTCP metadata, old skew of " + this._clockSkew + " s, new skew of " + newSkew + "s.");
        }
        this._clockSkew = newSkew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMeta() {
        byte[] encrypted = new byte[this._meta.length];
        byte[] byArray = this._meta;
        synchronized (this._meta) {
            DataHelper.toLong((byte[])this._meta, (int)0, (int)2, (long)0L);
            DataHelper.toLong((byte[])this._meta, (int)2, (int)4, (long)((this._context.clock().now() + 500L) / 1000L));
            this._context.random().nextBytes(this._meta, 6, 6);
            Adler32 crc = new Adler32();
            crc.update(this._meta, 0, this._meta.length - 4);
            DataHelper.toLong((byte[])this._meta, (int)(this._meta.length - 4), (int)4, (long)crc.getValue());
            this._context.aes().encrypt(this._meta, 0, encrypted, 0, this._sessionKey, this._prevWriteEnd, 0, this._meta.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            System.arraycopy(encrypted, encrypted.length - 16, this._prevWriteEnd, 0, this._prevWriteEnd.length);
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending NTCP metadata");
            }
            this._sendingMeta = true;
            this._transport.getPumper().wantsWrite(this, encrypted);
            return;
        }
    }

    private static final I2NPMessageHandler acquireHandler(RouterContext ctx) {
        I2NPMessageHandler rv = _i2npHandlers.poll();
        if (rv == null) {
            rv = new I2NPMessageHandler(ctx);
        }
        return rv;
    }

    private static void releaseHandler(I2NPMessageHandler handler) {
        _i2npHandlers.offer(handler);
    }

    private static ByteArray acquireReadBuf() {
        return _dataReadBufs.acquire();
    }

    private static void releaseReadBuf(ByteArray buf) {
        _dataReadBufs.release(buf, false);
    }

    static void releaseResources() {
        _i2npHandlers.clear();
        _bufs.clear();
    }

    public String toString() {
        return "NTCP conn " + (this._isInbound ? "from " : "to ") + (this._remotePeer == null ? "unknown" : this._remotePeer.calculateHash().toBase64().substring(0, 6)) + (this._established ? "" : " not established") + " created " + DataHelper.formatDuration((long)this.getTimeSinceCreated()) + " ago";
    }

    static {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = 0x6000000L;
        }
        NUM_PREP_BUFS = (int)Math.max(4L, Math.min(16L, 1L + maxMemory / 0x1000000L));
        _bufs = new LinkedBlockingQueue(NUM_PREP_BUFS);
        _i2npHandlers = new LinkedBlockingQueue(4);
    }

    private class InboundListener
    implements FIFOBandwidthLimiter.CompleteListener {
        private InboundListener() {
        }

        public void complete(FIFOBandwidthLimiter.Request req) {
            NTCPConnection.this.removeIBRequest(req);
            ByteBuffer buf = (ByteBuffer)req.attachment();
            if (NTCPConnection.this._closed) {
                EventPumper.releaseBuf(buf);
                return;
            }
            NTCPConnection.this._context.statManager().addRateData("ntcp.throttledReadComplete", System.currentTimeMillis() - req.getRequestTime());
            NTCPConnection.this.recv(buf);
            NTCPConnection.this._transport.getPumper().wantsRead(NTCPConnection.this);
        }
    }

    private class OutboundListener
    implements FIFOBandwidthLimiter.CompleteListener {
        private OutboundListener() {
        }

        public void complete(FIFOBandwidthLimiter.Request req) {
            NTCPConnection.this.removeOBRequest(req);
            ByteBuffer buf = (ByteBuffer)req.attachment();
            if (!NTCPConnection.this._closed) {
                NTCPConnection.this._context.statManager().addRateData("ntcp.throttledWriteComplete", System.currentTimeMillis() - req.getRequestTime());
                NTCPConnection.this.write(buf);
            }
        }
    }

    private static class PrepBuffer {
        final byte[] unencrypted = new byte[16384];
        int unencryptedLength;
        final byte[] base = new byte[16384];
        int baseLength;
        final Adler32 crc = new Adler32();
        byte[] encrypted;

        PrepBuffer() {
        }

        private void init() {
            this.unencryptedLength = 0;
            this.baseLength = 0;
            this.encrypted = null;
            this.crc.reset();
        }
    }

    private class ReadState {
        private int _size;
        private ByteArray _dataBuf;
        private int _nextWrite;
        private long _expectedCrc;
        private final Adler32 _crc = new Adler32();
        private long _stateBegin;
        private int _blocks;

        public ReadState() {
            this.init();
        }

        private void init() {
            this._size = -1;
            this._nextWrite = 0;
            this._expectedCrc = -1L;
            this._stateBegin = -1L;
            this._blocks = -1;
            this._crc.reset();
            if (this._dataBuf != null) {
                NTCPConnection.releaseReadBuf(this._dataBuf);
            }
            this._dataBuf = null;
        }

        public int getSize() {
            return this._size;
        }

        public void receiveBlock(byte[] buf) {
            if (this._size == -1) {
                this.receiveInitial(buf);
            } else {
                this.receiveSubsequent(buf);
            }
        }

        private void receiveInitial(byte[] buf) {
            this._size = (int)DataHelper.fromLong((byte[])buf, (int)0, (int)2);
            if (this._size == 0) {
                NTCPConnection.this.readMeta(buf);
                this.init();
            } else {
                this._stateBegin = System.currentTimeMillis();
                this._dataBuf = NTCPConnection.acquireReadBuf();
                System.arraycopy(buf, 2, this._dataBuf.getData(), 0, buf.length - 2);
                this._nextWrite += buf.length - 2;
                this._crc.update(buf);
                ++this._blocks;
                if (NTCPConnection.this._log.shouldLog(10)) {
                    NTCPConnection.this._log.debug("new I2NP message with size: " + this._size + " for message " + NTCPConnection.this._messagesRead);
                }
            }
        }

        private void receiveSubsequent(byte[] buf) {
            ++this._blocks;
            int remaining = this._size - this._nextWrite;
            int blockUsed = Math.min(buf.length, remaining);
            if (remaining > 0) {
                System.arraycopy(buf, 0, this._dataBuf.getData(), this._nextWrite, blockUsed);
                this._nextWrite += blockUsed;
                remaining -= blockUsed;
            }
            if (remaining <= 0 && buf.length - blockUsed < 4) {
                if (NTCPConnection.this._log.shouldLog(10)) {
                    NTCPConnection.this._log.debug("crc wraparound required on block " + this._blocks + " in message " + NTCPConnection.this._messagesRead);
                }
                this._crc.update(buf);
                return;
            }
            if (remaining <= 0) {
                this.receiveLastBlock(buf);
            } else {
                this._crc.update(buf);
            }
        }

        private void receiveLastBlock(byte[] buf) {
            this._expectedCrc = DataHelper.fromLong((byte[])buf, (int)(buf.length - 4), (int)4);
            this._crc.update(buf, 0, buf.length - 4);
            long val = this._crc.getValue();
            if (val == this._expectedCrc) {
                try {
                    I2NPMessageHandler h = NTCPConnection.acquireHandler(NTCPConnection.this._context);
                    h.readMessage(this._dataBuf.getData(), 0, this._size);
                    I2NPMessage read = h.lastRead();
                    long timeToRecv = System.currentTimeMillis() - this._stateBegin;
                    NTCPConnection.releaseHandler(h);
                    if (NTCPConnection.this._log.shouldLog(20)) {
                        NTCPConnection.this._log.info("I2NP message " + NTCPConnection.this._messagesRead + "/" + (read != null ? read.getUniqueId() : 0L) + " received after " + timeToRecv + " with " + this._size + "/" + this._blocks * 16 + " bytes on " + NTCPConnection.this.toString());
                    }
                    NTCPConnection.this._context.statManager().addRateData("ntcp.receiveTime", timeToRecv);
                    NTCPConnection.this._context.statManager().addRateData("ntcp.receiveSize", (long)this._size);
                    if (read != null) {
                        NTCPConnection.this._transport.messageReceived(read, NTCPConnection.this._remotePeer, null, timeToRecv, this._size);
                        if (NTCPConnection.this._messagesRead <= 0L) {
                            NTCPConnection.this.enqueueInfoMessage();
                        }
                        NTCPConnection.this._lastReceiveTime = System.currentTimeMillis();
                        NTCPConnection.this._messagesRead++;
                    }
                }
                catch (I2NPMessageException ime) {
                    if (NTCPConnection.this._log.shouldLog(30)) {
                        NTCPConnection.this._log.warn("Error parsing I2NP message", (Throwable)((Object)ime));
                        NTCPConnection.this._log.warn("DUMP:\n" + HexDump.dump((byte[])this._dataBuf.getData(), (int)0, (int)this._size));
                        NTCPConnection.this._log.warn("RAW:\n" + Base64.encode((byte[])this._dataBuf.getData(), (int)0, (int)this._size));
                    }
                    NTCPConnection.this._context.statManager().addRateData("ntcp.corruptI2NPIME", 1L);
                }
            } else {
                if (NTCPConnection.this._log.shouldLog(30)) {
                    NTCPConnection.this._log.warn("CRC incorrect for message " + NTCPConnection.this._messagesRead + " (calc=" + val + " expected=" + this._expectedCrc + ") size=" + this._size + " blocks " + this._blocks);
                }
                NTCPConnection.this._context.statManager().addRateData("ntcp.corruptI2NPCRC", 1L);
            }
            this.init();
        }
    }
}

