/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProfilePersistenceHelper {
    private final Log _log;
    private final RouterContext _context;
    public static final String PROP_PEER_PROFILE_DIR = "router.profileDir";
    public static final String DEFAULT_PEER_PROFILE_DIR = "peerProfiles";
    private static final String NL = System.getProperty("line.separator");
    private static final String PREFIX = "profile-";
    private static final String SUFFIX = ".txt.gz";
    private static final String UNCOMPRESSED_SUFFIX = ".txt";
    private static final String OLD_SUFFIX = ".dat";
    private static final String DIR_PREFIX = "p";
    private static final String B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~";
    private static final long EXPIRE_AGE = 259200000L;
    private final File _profileDir;
    private Hash _us;

    public ProfilePersistenceHelper(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(ProfilePersistenceHelper.class);
        String dir = this._context.getProperty(PROP_PEER_PROFILE_DIR, DEFAULT_PEER_PROFILE_DIR);
        this._profileDir = new SecureDirectory(this._context.getRouterDir(), dir);
        if (!this._profileDir.exists()) {
            this._profileDir.mkdirs();
        }
        for (int j = 0; j < B64.length(); ++j) {
            SecureDirectory subdir = new SecureDirectory(this._profileDir, DIR_PREFIX + B64.charAt(j));
            if (subdir.exists()) continue;
            subdir.mkdir();
        }
    }

    public void setUs(Hash routerIdentHash) {
        this._us = routerIdentHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProfile(PeerProfile profile) {
        if (this.isExpired(profile.getLastSendSuccessful())) {
            return;
        }
        File f = this.pickFile(profile);
        long before = this._context.clock().now();
        OutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new GZIPOutputStream((OutputStream)new SecureFileOutputStream(f)));
            this.writeProfile(profile, fos);
        }
        catch (IOException ioe) {
            this._log.error("Error writing profile to " + f);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
        long delay = this._context.clock().now() - before;
        if (this._log.shouldLog(10)) {
            this._log.debug("Writing the profile to " + f.getName() + " took " + delay + "ms");
        }
    }

    public void writeProfile(PeerProfile profile, OutputStream out) throws IOException {
        String groups = null;
        if (this._context.profileOrganizer().isFailing(profile.getPeer())) {
            groups = "Failing";
        } else if (!this._context.profileOrganizer().isHighCapacity(profile.getPeer())) {
            groups = "Standard";
        } else {
            groups = this._context.profileOrganizer().isFast(profile.getPeer()) ? "Fast, High Capacity" : "High Capacity";
            if (this._context.profileOrganizer().isWellIntegrated(profile.getPeer())) {
                groups = groups + ", Integrated";
            }
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("########################################################################").append(NL);
        buf.append("# Profile for peer ").append(profile.getPeer().toBase64()).append(NL);
        if (this._us != null) {
            buf.append("# as calculated by ").append(this._us.toBase64()).append(NL);
        }
        buf.append("#").append(NL);
        buf.append("# Speed: ").append(profile.getSpeedValue()).append(NL);
        buf.append("# Capacity: ").append(profile.getCapacityValue()).append(NL);
        buf.append("# Integration: ").append(profile.getIntegrationValue()).append(NL);
        buf.append("# Groups: ").append(groups).append(NL);
        buf.append("#").append(NL);
        buf.append("########################################################################").append(NL);
        buf.append("##").append(NL);
        ProfilePersistenceHelper.add(buf, "speedBonus", profile.getSpeedBonus(), "Manual adjustment to the speed score");
        ProfilePersistenceHelper.add(buf, "capacityBonus", profile.getCapacityBonus(), "Manual adjustment to the capacity score");
        ProfilePersistenceHelper.add(buf, "integrationBonus", profile.getIntegrationBonus(), "Manual adjustment to the integration score");
        ProfilePersistenceHelper.addDate(buf, "firstHeardAbout", profile.getFirstHeardAbout(), "When did we first get a reference to this peer?");
        ProfilePersistenceHelper.addDate(buf, "lastHeardAbout", profile.getLastHeardAbout(), "When did we last get a reference to this peer?");
        ProfilePersistenceHelper.addDate(buf, "lastHeardFrom", profile.getLastHeardFrom(), "When did we last get a message from the peer?");
        ProfilePersistenceHelper.addDate(buf, "lastSentToSuccessfully", profile.getLastSendSuccessful(), "When did we last send the peer a message successfully?");
        ProfilePersistenceHelper.addDate(buf, "lastFailedSend", profile.getLastSendFailed(), "When did we last fail to send a message to the peer?");
        ProfilePersistenceHelper.add(buf, "tunnelTestTimeAverage", profile.getTunnelTestTimeAverage(), "Moving average as to how fast the peer replies");
        ProfilePersistenceHelper.add(buf, "tunnelPeakThroughput", profile.getPeakThroughputKBps(), "KBytes/sec");
        ProfilePersistenceHelper.add(buf, "tunnelPeakTunnelThroughput", profile.getPeakTunnelThroughputKBps(), "KBytes/sec");
        ProfilePersistenceHelper.add(buf, "tunnelPeakTunnel1mThroughput", profile.getPeakTunnel1mThroughputKBps(), "KBytes/sec");
        buf.append(NL);
        out.write(buf.toString().getBytes());
        if (profile.getIsExpanded()) {
            profile.getTunnelHistory().store(out);
            profile.getTunnelCreateResponseTime().store(out, "tunnelCreateResponseTime");
            profile.getTunnelTestResponseTime().store(out, "tunnelTestResponseTime");
        }
        if (profile.getIsExpandedDB()) {
            profile.getDBHistory().store(out);
            profile.getDbIntroduction().store(out, "dbIntroduction");
            profile.getDbResponseTime().store(out, "dbResponseTime");
        }
    }

    private static void addDate(StringBuilder buf, String name, long val, String description) {
        String when = val > 0L ? new Date(val).toString() : "Never";
        ProfilePersistenceHelper.add(buf, name, val, description + ' ' + when);
    }

    private static void add(StringBuilder buf, String name, long val, String description) {
        buf.append("# ").append(name).append(NL).append("# ").append(description).append(NL);
        buf.append(name).append('=').append(val).append(NL).append(NL);
    }

    private static void add(StringBuilder buf, String name, double val, String description) {
        buf.append("# ").append(name).append(NL).append("# ").append(description).append(NL);
        buf.append(name).append('=').append(val).append(NL).append(NL);
    }

    public Set<PeerProfile> readProfiles() {
        long start = this._context.clock().now();
        List<File> files = this.selectFiles();
        HashSet<PeerProfile> profiles = new HashSet<PeerProfile>(files.size());
        for (File f : files) {
            PeerProfile profile = this.readProfile(f);
            if (profile == null) continue;
            profiles.add(profile);
        }
        long duration = this._context.clock().now() - start;
        if (this._log.shouldLog(10)) {
            this._log.debug("Loading " + profiles.size() + " took " + duration + "ms");
        }
        return profiles;
    }

    private List<File> selectFiles() {
        ProfileFilter filter = new ProfileFilter();
        File[] files = this._profileDir.listFiles(filter);
        if (files != null && files.length > 0) {
            this.migrate(files);
        }
        ArrayList<File> rv = new ArrayList<File>(1024);
        for (int j = 0; j < B64.length(); ++j) {
            File subdir = new File(this._profileDir, DIR_PREFIX + B64.charAt(j));
            files = subdir.listFiles(filter);
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                rv.add(files[i]);
            }
        }
        return rv;
    }

    private void migrate(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File from = files[i];
            if (!from.isFile()) continue;
            File dir = new File(this._profileDir, DIR_PREFIX + from.getName().charAt(PREFIX.length()));
            File to = new File(dir, from.getName());
            FileUtil.rename((File)from, (File)to);
        }
    }

    private boolean isExpired(long lastSentToSuccessfully) {
        long timeSince = this._context.clock().now() - lastSentToSuccessfully;
        return timeSince > 259200000L;
    }

    public PeerProfile readProfile(File file) {
        Hash peer = this.getHash(file.getName());
        try {
            if (peer == null) {
                this._log.error("The file " + file.getName() + " is not a valid hash");
                return null;
            }
            PeerProfile profile = new PeerProfile(this._context, peer);
            Properties props = new Properties();
            this.loadProps(props, file);
            long lastSentToSuccessfully = ProfilePersistenceHelper.getLong(props, "lastSentToSuccessfully");
            if (this.isExpired(lastSentToSuccessfully)) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Dropping old profile " + file.getName() + ", since we haven't heard from them in a long time");
                }
                file.delete();
                return null;
            }
            if (file.getName().endsWith(OLD_SUFFIX)) {
                String newName = file.getAbsolutePath();
                boolean success = file.renameTo(new File(newName = newName.substring(0, newName.length() - OLD_SUFFIX.length()) + SUFFIX));
                if (!success) {
                    file.delete();
                }
            }
            profile.setCapacityBonus(ProfilePersistenceHelper.getLong(props, "capacityBonus"));
            profile.setIntegrationBonus(ProfilePersistenceHelper.getLong(props, "integrationBonus"));
            profile.setSpeedBonus(ProfilePersistenceHelper.getLong(props, "speedBonus"));
            profile.setLastHeardAbout(ProfilePersistenceHelper.getLong(props, "lastHeardAbout"));
            profile.setFirstHeardAbout(ProfilePersistenceHelper.getLong(props, "firstHeardAbout"));
            profile.setLastSendSuccessful(ProfilePersistenceHelper.getLong(props, "lastSentToSuccessfully"));
            profile.setLastSendFailed(ProfilePersistenceHelper.getLong(props, "lastFailedSend"));
            profile.setLastHeardFrom(ProfilePersistenceHelper.getLong(props, "lastHeardFrom"));
            profile.setTunnelTestTimeAverage(ProfilePersistenceHelper.getDouble(props, "tunnelTestTimeAverage"));
            profile.setPeakThroughputKBps(ProfilePersistenceHelper.getDouble(props, "tunnelPeakThroughput"));
            profile.setPeakTunnelThroughputKBps(ProfilePersistenceHelper.getDouble(props, "tunnelPeakTunnelThroughput"));
            profile.setPeakTunnel1mThroughputKBps(ProfilePersistenceHelper.getDouble(props, "tunnelPeakTunnel1mThroughput"));
            profile.getTunnelHistory().load(props);
            if (ProfilePersistenceHelper.getLong(props, "dbHistory.successfulLookups") > 1L || ProfilePersistenceHelper.getLong(props, "dbHistory.failedlLokups") > 1L) {
                profile.expandDBProfile();
                profile.getDBHistory().load(props);
                profile.getDbIntroduction().load(props, "dbIntroduction", true);
                profile.getDbResponseTime().load(props, "dbResponseTime", true);
            }
            profile.getTunnelCreateResponseTime().load(props, "tunnelCreateResponseTime", true);
            profile.getTunnelTestResponseTime().load(props, "tunnelTestResponseTime", true);
            if (this._log.shouldLog(10)) {
                this._log.debug("Loaded the profile for " + peer.toBase64() + " from " + file.getName());
            }
            return profile;
        }
        catch (Exception e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error loading properties from " + file.getAbsolutePath(), (Throwable)e);
            }
            file.delete();
            return null;
        }
    }

    private static final long getLong(Properties props, String key) {
        String val = props.getProperty(key);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                return 0L;
            }
        }
        return 0L;
    }

    private static final double getDouble(Properties props, String key) {
        String val = props.getProperty(key);
        if (val != null) {
            try {
                return Double.parseDouble(val);
            }
            catch (NumberFormatException nfe) {
                return 0.0;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps(Properties props, File file) throws IOException {
        InputStream fin = null;
        try {
            fin = new BufferedInputStream(new FileInputStream(file), 1);
            fin.mark(1);
            int c = fin.read();
            fin.reset();
            if (c == 35) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Loading uncompressed profile data from " + file.getName());
                }
                DataHelper.loadProps((Properties)props, (InputStream)fin);
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("Loading compressed profile data from " + file.getName());
                }
                DataHelper.loadProps((Properties)props, (InputStream)new GZIPInputStream(fin));
            }
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private Hash getHash(String name) {
        String key = name.substring(PREFIX.length());
        key = key.substring(0, 44);
        try {
            byte[] b = Base64.decode((String)key);
            if (b == null) {
                return null;
            }
            Hash h = Hash.create((byte[])b);
            return h;
        }
        catch (Exception dfe) {
            this._log.warn("Invalid base64 [" + key + "]", (Throwable)dfe);
            return null;
        }
    }

    private File pickFile(PeerProfile profile) {
        String hash = profile.getPeer().toBase64();
        File dir = new File(this._profileDir, DIR_PREFIX + hash.charAt(0));
        return new File(dir, PREFIX + hash + SUFFIX);
    }

    private static class ProfileFilter
    implements FilenameFilter {
        private ProfileFilter() {
        }

        public boolean accept(File dir, String filename) {
            return filename.startsWith(ProfilePersistenceHelper.PREFIX) && (filename.endsWith(ProfilePersistenceHelper.SUFFIX) || filename.endsWith(ProfilePersistenceHelper.OLD_SUFFIX) || filename.endsWith(ProfilePersistenceHelper.UNCOMPRESSED_SUFFIX));
        }
    }
}

