/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.MessageSelector;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

class StoreMessageSelector
implements MessageSelector {
    private Log _log;
    private Hash _peer;
    private long _storeJobId;
    private long _waitingForId;
    private long _expiration;
    private boolean _found;

    public StoreMessageSelector(RouterContext ctx, long storeJobId, RouterInfo peer, long waitingForId, long expiration) {
        this._log = ctx.logManager().getLog(StoreMessageSelector.class);
        this._peer = peer.getIdentity().getHash();
        this._storeJobId = storeJobId;
        this._found = false;
        this._waitingForId = waitingForId;
        this._expiration = expiration;
    }

    public boolean continueMatching() {
        return !this._found;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public boolean isMatch(I2NPMessage message) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this._storeJobId + ": isMatch(" + message.getClass().getName() + ") [want deliveryStatusMessage from " + this._peer + "]");
        }
        if (message instanceof DeliveryStatusMessage) {
            DeliveryStatusMessage msg = (DeliveryStatusMessage)message;
            if (msg.getMessageId() == this._waitingForId) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this._storeJobId + ": Found match for the key we're waiting for: " + this._waitingForId);
                }
                this._found = true;
                return true;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this._storeJobId + ": DeliveryStatusMessage of a key we're not looking for");
            }
            return false;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this._storeJobId + ": Not a DeliveryStatusMessage");
        }
        return false;
    }

    public String toString() {
        StringBuilder rv = new StringBuilder(64);
        rv.append("Waiting for netDb confirm from ").append(this._peer.toBase64()).append(", found? ");
        rv.append(this._found).append(" waiting for ").append(this._waitingForId);
        return rv.toString();
    }
}

