/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.KBucket;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class ExploreKeySelectorJob
extends JobImpl {
    private Log _log;
    private KademliaNetworkDatabaseFacade _facade;
    private static final long RERUN_DELAY_MS = 60000L;

    public ExploreKeySelectorJob(RouterContext context, KademliaNetworkDatabaseFacade facade) {
        super(context);
        this._log = context.logManager().getLog(ExploreKeySelectorJob.class);
        this._facade = facade;
    }

    public String getName() {
        return "Explore Key Selector Job";
    }

    public void runJob() {
        if (((FloodfillNetworkDatabaseFacade)this._facade).floodfillEnabled()) {
            this.requeue(1800000L);
            return;
        }
        Set toExplore = this.selectKeysToExplore();
        this._log.info("Filling the explorer pool with: " + toExplore);
        if (toExplore != null) {
            this._facade.queueForExploration(toExplore);
        }
        this.requeue(60000L);
    }

    private Set selectKeysToExplore() {
        Set<Hash> alreadyQueued = this._facade.getExploreKeys();
        if (alreadyQueued.size() > 32) {
            return null;
        }
        HashSet<Hash> toExplore = new HashSet<Hash>(32 - alreadyQueued.size());
        for (int i = 0; i < 32; ++i) {
            KBucket bucket = this._facade.getKBuckets().getBucket(i);
            if (bucket.getKeyCount() < 500) {
                boolean already = false;
                for (Hash key : alreadyQueued) {
                    if (!bucket.shouldContain(key)) continue;
                    already = true;
                    this._log.debug("Bucket " + i + " is already queued for exploration \t" + key);
                    break;
                }
                if (already) continue;
                Hash key = bucket.generateRandomKey();
                this._log.debug("Bucket " + i + " is NOT queued for exploration, and it only has " + bucket.getKeyCount() + " keys, so explore with \t" + key);
                toExplore.add(key);
                continue;
            }
            this._log.debug("Bucket " + i + " already has enough keys (" + bucket.getKeyCount() + "), no need to explore further");
        }
        return toExplore;
    }
}

