/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SHA1;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.PartialPiece;
import org.klomp.snark.bencode.BDecoder;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.BEncoder;
import org.klomp.snark.bencode.InvalidBEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaInfo {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(MetaInfo.class);
    private final String announce;
    private final byte[] info_hash;
    private final String name;
    private final String name_utf8;
    private final List<List<String>> files;
    private final List<List<String>> files_utf8;
    private final List<Long> lengths;
    private final int piece_length;
    private final byte[] piece_hashes;
    private final long length;
    private final boolean privateTorrent;
    private final List<List<String>> announce_list;
    private final String comment;
    private final String created_by;
    private final long creation_date;
    private Map<String, BEValue> infoMap;

    MetaInfo(String announce, String name, String name_utf8, List<List<String>> files, List<Long> lengths, int piece_length, byte[] piece_hashes, long length, boolean privateTorrent, List<List<String>> announce_list) {
        this.announce = announce;
        this.name = name;
        this.name_utf8 = name_utf8;
        this.files = files == null ? null : Collections.unmodifiableList(files);
        this.files_utf8 = null;
        this.lengths = lengths == null ? null : Collections.unmodifiableList(lengths);
        this.piece_length = piece_length;
        this.piece_hashes = piece_hashes;
        this.length = length;
        this.privateTorrent = privateTorrent;
        this.announce_list = announce_list;
        this.comment = null;
        this.created_by = null;
        this.creation_date = 0L;
        this.info_hash = this.calculateInfoHash();
    }

    public MetaInfo(InputStream in) throws IOException {
        this(new BDecoder(in));
    }

    private MetaInfo(BDecoder be) throws IOException {
        this(be.bdecodeMap().getMap());
        byte[] origInfohash = be.get_special_map_digest();
        if (!DataHelper.eq(origInfohash, this.info_hash)) {
            throw new InvalidBEncodingException("Infohash mismatch, please report");
        }
    }

    public MetaInfo(Map<String, BEValue> m) throws InvalidBEncodingException {
        BEValue val;
        if (this._log.shouldLog(10)) {
            this._log.debug("Creating a metaInfo: " + m, new Exception("source"));
        }
        this.announce = (val = m.get("announce")) == null ? null : val.getString();
        val = m.get("announce-list");
        if (val == null) {
            this.announce_list = null;
        } else {
            this.announce_list = new ArrayList<List<String>>();
            List<BEValue> bl1 = val.getList();
            for (BEValue bev : bl1) {
                List<BEValue> bl2 = bev.getList();
                ArrayList<String> sl2 = new ArrayList<String>();
                for (BEValue bev2 : bl2) {
                    sl2.add(bev2.getString());
                }
                this.announce_list.add(sl2);
            }
        }
        val = m.get("comment");
        String st = null;
        if (val != null) {
            try {
                st = val.getString();
            }
            catch (InvalidBEncodingException ibee) {
                // empty catch block
            }
        }
        this.comment = st;
        val = m.get("created by");
        st = null;
        if (val != null) {
            try {
                st = val.getString();
            }
            catch (InvalidBEncodingException ibee) {
                // empty catch block
            }
        }
        this.created_by = st;
        val = m.get("creation date");
        long time = 0L;
        if (val != null) {
            try {
                time = val.getLong() * 1000L;
            }
            catch (InvalidBEncodingException ibee) {
                // empty catch block
            }
        }
        this.creation_date = time;
        val = m.get("info");
        if (val == null) {
            throw new InvalidBEncodingException("Missing info map");
        }
        Map<String, BEValue> info = val.getMap();
        this.infoMap = Collections.unmodifiableMap(info);
        val = info.get("name");
        if (val == null) {
            throw new InvalidBEncodingException("Missing name string");
        }
        this.name = val.getString();
        if (this.name.indexOf(47) >= 0) {
            throw new InvalidBEncodingException("Invalid name containing '/' " + this.name);
        }
        val = info.get("name.utf-8");
        this.name_utf8 = val != null ? val.getString() : null;
        val = info.get("private");
        this.privateTorrent = val != null && val.getString().equals("1");
        val = info.get("piece length");
        if (val == null) {
            throw new InvalidBEncodingException("Missing piece length number");
        }
        this.piece_length = val.getInt();
        val = info.get("pieces");
        if (val == null) {
            throw new InvalidBEncodingException("Missing piece bytes");
        }
        this.piece_hashes = val.getBytes();
        val = info.get("length");
        if (val != null) {
            this.length = val.getLong();
            this.files = null;
            this.files_utf8 = null;
            this.lengths = null;
        } else {
            val = info.get("files");
            if (val == null) {
                throw new InvalidBEncodingException("Missing length number and/or files list");
            }
            List<BEValue> list = val.getList();
            int size = list.size();
            if (size == 0) {
                throw new InvalidBEncodingException("zero size files list");
            }
            ArrayList m_files = new ArrayList(size);
            ArrayList m_files_utf8 = new ArrayList(size);
            ArrayList<Long> m_lengths = new ArrayList<Long>(size);
            long l = 0L;
            for (int i = 0; i < list.size(); ++i) {
                Map<String, BEValue> desc = list.get(i).getMap();
                val = desc.get("length");
                if (val == null) {
                    throw new InvalidBEncodingException("Missing length number");
                }
                long len = val.getLong();
                if (len < 0L) {
                    throw new InvalidBEncodingException("Negative file length");
                }
                m_lengths.add(len);
                long oldTotal = l;
                if ((l += len) < oldTotal) {
                    throw new InvalidBEncodingException("Huge total length");
                }
                val = desc.get("path");
                if (val == null) {
                    throw new InvalidBEncodingException("Missing path list");
                }
                List<BEValue> path_list = val.getList();
                int path_length = path_list.size();
                if (path_length == 0) {
                    throw new InvalidBEncodingException("zero size file path list");
                }
                ArrayList<String> file = new ArrayList<String>(path_length);
                Iterator<BEValue> it = path_list.iterator();
                while (it.hasNext()) {
                    String s = it.next().getString();
                    if (s.indexOf(47) >= 0) {
                        s = s.replace("/", "_");
                    }
                    file.add(s);
                }
                for (int j = 0; j < i; ++j) {
                    if (!file.equals(m_files.get(j))) continue;
                    throw new InvalidBEncodingException("Duplicate file path " + DataHelper.toString(file));
                }
                m_files.add(Collections.unmodifiableList(file));
                val = desc.get("path.utf-8");
                if (val == null || (path_length = (path_list = val.getList()).size()) <= 0) continue;
                file = new ArrayList(path_length);
                it = path_list.iterator();
                while (it.hasNext()) {
                    file.add(it.next().getString());
                }
                m_files_utf8.add(Collections.unmodifiableList(file));
            }
            this.files = Collections.unmodifiableList(m_files);
            this.files_utf8 = Collections.unmodifiableList(m_files_utf8);
            this.lengths = Collections.unmodifiableList(m_lengths);
            this.length = l;
        }
        this.info_hash = this.calculateInfoHash();
    }

    public static String getNameAndInfoHash(InputStream in, byte[] infoHashOut) throws IOException {
        BDecoder bd = new BDecoder(in);
        Map<String, BEValue> m = bd.bdecodeMap().getMap();
        BEValue ibev = m.get("info");
        if (ibev == null) {
            throw new InvalidBEncodingException("Missing info map");
        }
        Map<String, BEValue> i = ibev.getMap();
        BEValue rvbev = i.get("name");
        if (rvbev == null) {
            throw new InvalidBEncodingException("Missing name");
        }
        byte[] h = bd.get_special_map_digest();
        System.arraycopy(h, 0, infoHashOut, 0, 20);
        return rvbev.getString();
    }

    public String getAnnounce() {
        return this.announce;
    }

    public List<List<String>> getAnnounceList() {
        return this.announce_list;
    }

    public byte[] getInfoHash() {
        return this.info_hash;
    }

    byte[] getPieceHashes() {
        return this.piece_hashes;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrivate() {
        return this.privateTorrent;
    }

    public List<List<String>> getFiles() {
        return this.files;
    }

    public List<Long> getLengths() {
        return this.lengths;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCreatedBy() {
        return this.created_by;
    }

    public long getCreationDate() {
        return this.creation_date;
    }

    public int getPieces() {
        return this.piece_hashes.length / 20;
    }

    public int getPieceLength(int piece) {
        int pieces = this.getPieces();
        if (piece >= 0 && piece < pieces - 1) {
            return this.piece_length;
        }
        if (piece == pieces - 1) {
            return (int)(this.length - (long)piece * (long)this.piece_length);
        }
        throw new IndexOutOfBoundsException("no piece: " + piece);
    }

    public boolean checkPiece(int piece, byte[] bs, int off, int length) {
        return this.fast_checkPiece(piece, bs, off, length);
    }

    private boolean fast_checkPiece(int piece, byte[] bs, int off, int length) {
        MessageDigest sha1 = SHA1.getInstance();
        sha1.update(bs, off, length);
        byte[] hash = sha1.digest();
        for (int i = 0; i < 20; ++i) {
            if (hash[i] == this.piece_hashes[20 * piece + i]) continue;
            return false;
        }
        return true;
    }

    boolean checkPiece(PartialPiece pp) {
        byte[] hash;
        MessageDigest sha1 = SHA1.getInstance();
        int piece = pp.getPiece();
        try {
            hash = pp.getHash();
        }
        catch (IOException ioe) {
            this._log.warn("Error checking", ioe);
            return false;
        }
        for (int i = 0; i < 20; ++i) {
            if (hash[i] == this.piece_hashes[20 * piece + i]) continue;
            return false;
        }
        return true;
    }

    public long getTotalLength() {
        return this.length;
    }

    public String toString() {
        return "MetaInfo[info_hash='" + I2PSnarkUtil.toHex(this.info_hash) + "', announce='" + this.announce + "', name='" + this.name + "', files=" + this.files + ", #pieces='" + this.piece_hashes.length / 20 + "', piece_length='" + this.piece_length + "', length='" + this.length + "']";
    }

    public MetaInfo reannounce(String announce) throws InvalidBEncodingException {
        HashMap<String, BEValue> m = new HashMap<String, BEValue>();
        if (announce != null) {
            m.put("announce", new BEValue(DataHelper.getUTF8(announce)));
        }
        Map<String, BEValue> info = this.createInfoMap();
        m.put("info", new BEValue(info));
        return new MetaInfo(m);
    }

    public synchronized byte[] getTorrentData() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (this.announce != null) {
            m.put("announce", this.announce);
        }
        if (this.announce_list != null) {
            m.put("announce-list", this.announce_list);
        }
        Map<String, BEValue> info = this.createInfoMap();
        m.put("info", info);
        return BEncoder.bencode(m);
    }

    public synchronized byte[] getInfoBytes() {
        if (this.infoMap == null) {
            this.createInfoMap();
        }
        return BEncoder.bencode(this.infoMap);
    }

    private Map<String, BEValue> createInfoMap() {
        if (this.infoMap != null) {
            return Collections.unmodifiableMap(this.infoMap);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Creating new infomap", new Exception());
        }
        HashMap<String, BEValue> info = new HashMap<String, BEValue>();
        info.put("name", (BEValue)((Object)this.name));
        if (this.name_utf8 != null) {
            info.put("name.utf-8", (BEValue)((Object)this.name_utf8));
        }
        if (this.privateTorrent) {
            info.put("private", (BEValue)((Object)"1"));
        }
        info.put("piece length", (BEValue)((Object)Integer.valueOf(this.piece_length)));
        info.put("pieces", (BEValue)this.piece_hashes);
        if (this.files == null) {
            info.put("length", (BEValue)((Object)Long.valueOf(this.length)));
        } else {
            ArrayList l = new ArrayList();
            for (int i = 0; i < this.files.size(); ++i) {
                HashMap<String, Object> file = new HashMap<String, Object>();
                file.put("path", this.files.get(i));
                if (this.files_utf8 != null && this.files_utf8.size() > i) {
                    file.put("path.utf-8", this.files_utf8.get(i));
                }
                file.put("length", this.lengths.get(i));
                l.add(file);
            }
            info.put("files", (BEValue)((Object)l));
        }
        this.infoMap = info;
        return Collections.unmodifiableMap(this.infoMap);
    }

    private byte[] calculateInfoHash() {
        Map<String, BEValue> info = this.createInfoMap();
        if (this._log.shouldLog(10)) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("info: ");
            for (Map.Entry<String, BEValue> entry : info.entrySet()) {
                String key = entry.getKey();
                BEValue val = entry.getValue();
                buf.append(key).append('=');
                buf.append(((Object)val).toString());
            }
            this._log.debug(buf.toString());
        }
        byte[] infoBytes = BEncoder.bencode(info);
        MessageDigest digest = SHA1.getInstance();
        byte[] hash = digest.digest(infoBytes);
        if (this._log.shouldLog(10)) {
            this._log.debug("info hash: " + I2PSnarkUtil.toHex(hash));
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length <= 0) {
            System.err.println("Usage: MetaInfo files...");
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(args[i]);
                MetaInfo meta = new MetaInfo(in);
                System.out.println(args[i] + " InfoHash: " + I2PSnarkUtil.toHex(meta.getInfoHash()));
                continue;
            }
            catch (IOException ioe) {
                System.err.println("Error in file " + args[i] + ": " + ioe);
                continue;
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

