/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.util.BigPipedInputStream;
import net.i2p.util.EepGet;
import net.i2p.util.I2PAppThread;
import net.i2p.util.SocketTimeout;
import net.i2p.util.SystemVersion;

public class SSLEepGet
extends EepGet {
    private boolean _saveCerts;
    private boolean _commandLine;
    private final SSLContext _sslContext;
    private SavingTrustManager _stm;
    private static final boolean _isAndroid = SystemVersion.isAndroid();
    private static final int LINE_LENGTH = 64;

    public SSLEepGet(I2PAppContext ctx, OutputStream outputStream, String url) {
        this(ctx, outputStream, url, null);
    }

    public SSLEepGet(I2PAppContext ctx, OutputStream outputStream, String url, SSLState state) {
        super(ctx, false, null, -1, 0, -1L, -1L, null, outputStream, url, true, null, null);
        this._sslContext = state != null && state.context != null ? state.context : this.initSSLContext();
        if (this._sslContext == null) {
            this._log.error("Failed to initialize custom SSL context, using default context");
        }
    }

    public static void main(String[] args) {
        FileOutputStream out;
        String url = null;
        boolean saveCerts = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-s")) {
                    saveCerts = true;
                    continue;
                }
                if (args[i].startsWith("-")) {
                    SSLEepGet.usage();
                    return;
                }
                url = args[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SSLEepGet.usage();
            return;
        }
        if (url == null) {
            SSLEepGet.usage();
            return;
        }
        String saveAs = SSLEepGet.suggestName(url);
        try {
            out = new FileOutputStream(saveAs);
        }
        catch (IOException ioe) {
            System.err.println("Failed to create output file " + saveAs);
            return;
        }
        SSLEepGet get = new SSLEepGet(I2PAppContext.getGlobalContext(), out, url);
        if (saveCerts) {
            get._saveCerts = true;
        }
        get._commandLine = true;
        SSLEepGet sSLEepGet = get;
        sSLEepGet.getClass();
        get.addStatusListener(sSLEepGet.new EepGet.CLIStatusListener(1024, 40));
        if (!get.fetch(45000L, -1L, 60000L)) {
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("Usage: SSLEepGet https://url");
        System.err.println("To save unknown certs, use: SSLEepGet -s https://url");
    }

    private SSLContext initSSLContext() {
        int adds;
        KeyStore ks;
        try {
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (GeneralSecurityException gse) {
            this._log.error("Key Store init error", gse);
            return null;
        }
        boolean success = false;
        String override = System.getProperty("javax.net.ssl.keyStore");
        if (override != null) {
            success = this.loadCerts(new File(override), ks);
        }
        if (!success) {
            if (_isAndroid) {
                success = this.loadCerts(new File(System.getProperty("java.home"), "etc/security/cacerts.bks"), ks);
            } else {
                success = this.loadCerts(new File(System.getProperty("java.home"), "lib/security/jssecacerts"), ks);
                if (!success) {
                    success = this.loadCerts(new File(System.getProperty("java.home"), "lib/security/cacerts"), ks);
                }
            }
        }
        if (!success) {
            try {
                ks.load(null, "changeit".toCharArray());
            }
            catch (Exception e) {
                // empty catch block
            }
            this._log.error("All key store loads failed, will only load local certificates");
        } else if (this._log.shouldLog(20)) {
            int count = 0;
            try {
                Enumeration<String> e = ks.aliases();
                while (e.hasMoreElements()) {
                    String alias = e.nextElement();
                    if (!ks.isCertificateEntry(alias)) continue;
                    ++count;
                }
            }
            catch (Exception foo) {
                // empty catch block
            }
            this._log.info("Loaded " + count + " default trusted certificates");
        }
        File dir = new File(this._context.getBaseDir(), "certificates");
        int totalAdds = adds = this.addCerts(dir, ks);
        if (adds > 0 && this._log.shouldLog(20)) {
            this._log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
        }
        if (!this._context.getBaseDir().getAbsolutePath().equals(this._context.getConfigDir().getAbsolutePath())) {
            dir = new File(this._context.getConfigDir(), "certificates");
            adds = this.addCerts(dir, ks);
            totalAdds += adds;
            if (adds > 0 && this._log.shouldLog(20)) {
                this._log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
            }
        }
        dir = new File(System.getProperty("user.dir"));
        if (!this._context.getBaseDir().getAbsolutePath().equals(dir.getAbsolutePath())) {
            dir = new File(this._context.getConfigDir(), "certificates");
            adds = this.addCerts(dir, ks);
            totalAdds += adds;
            if (adds > 0 && this._log.shouldLog(20)) {
                this._log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Loaded total of " + totalAdds + " new trusted certificates");
        }
        try {
            SSLContext sslc = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            this._stm = new SavingTrustManager(defaultTrustManager);
            sslc.init(null, new TrustManager[]{this._stm}, null);
            return sslc;
        }
        catch (GeneralSecurityException gse) {
            this._log.error("Key Store update error", gse);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean loadCerts(File file, KeyStore ks) {
        block20: {
            if (!file.exists()) {
                return false;
            }
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            ks.load(fis, "changeit".toCharArray());
            Object var7_4 = null;
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
                break block20;
            }
            catch (IOException foo2) {}
            break block20;
            {
                catch (GeneralSecurityException gse) {
                    this._log.error("KeyStore load error, no default keys: " + file.getAbsolutePath(), gse);
                    try {
                        ks.load(null, "changeit".toCharArray());
                    }
                    catch (Exception foo) {
                        // empty catch block
                    }
                    boolean foo = false;
                    Object var7_5 = null;
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException foo2) {
                        // empty catch block
                    }
                    return foo;
                }
                catch (IOException ioe) {
                    boolean bl;
                    try {
                        this._log.error("KeyStore load error, no default keys: " + file.getAbsolutePath(), ioe);
                        try {
                            ks.load(null, "changeit".toCharArray());
                        }
                        catch (Exception foo) {
                            // empty catch block
                        }
                        bl = false;
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        try {
                            if (fis != null) {
                                ((InputStream)fis).close();
                            }
                        }
                        catch (IOException foo2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException foo2) {
                        // empty catch block
                    }
                    return bl;
                }
            }
        }
        return true;
    }

    private int addCerts(File dir, KeyStore ks) {
        File[] files;
        if (this._log.shouldLog(20)) {
            this._log.info("Looking for X509 Certificates in " + dir.getAbsolutePath());
        }
        int added = 0;
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean success;
                File f = files[i];
                if (!f.isFile()) continue;
                String alias = f.getName().toLowerCase(Locale.US);
                if (alias.endsWith(".crt") || alias.endsWith(".pem") || alias.endsWith(".key") || alias.endsWith(".der") || alias.endsWith(".key") || alias.endsWith(".p7b") || alias.endsWith(".p7c") || alias.endsWith(".pfx") || alias.endsWith(".p12")) {
                    alias = alias.substring(0, alias.length() - 4);
                }
                if (!(success = this.addCert(f, alias, ks))) continue;
                ++added;
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private boolean addCert(File file, String alias, KeyStore ks) {
        block25: {
            FileInputStream fis;
            block24: {
                fis = null;
                fis = new FileInputStream(file);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(fis);
                if (this._log.shouldLog(20)) {
                    this._log.info("Read X509 Certificate from " + file.getAbsolutePath() + " Issuer: " + cert.getIssuerX500Principal() + "; Valid From: " + cert.getNotBefore() + " To: " + cert.getNotAfter());
                }
                try {
                    cert.checkValidity();
                }
                catch (CertificateExpiredException cee) {
                    this._log.error("Rejecting expired X509 Certificate: " + file.getAbsolutePath(), cee);
                    boolean bl = false;
                    Object var10_15 = null;
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException foo) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (CertificateNotYetValidException cnyve) {
                    this._log.error("Rejecting X509 Certificate not yet valid: " + file.getAbsolutePath(), cnyve);
                    boolean bl = false;
                    Object var10_16 = null;
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException foo) {
                        // empty catch block
                    }
                    return bl;
                }
                ks.setCertificateEntry(alias, cert);
                if (!this._log.shouldLog(20)) break block24;
                this._log.info("Now trusting X509 Certificate, Issuer: " + cert.getIssuerX500Principal());
            }
            Object var10_17 = null;
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
                break block25;
            }
            catch (IOException foo) {}
            break block25;
            {
                catch (GeneralSecurityException gse) {
                    this._log.error("Error reading X509 Certificate: " + file.getAbsolutePath(), gse);
                    boolean bl = false;
                    Object var10_18 = null;
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException foo) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (IOException ioe) {
                    this._log.error("Error reading X509 Certificate: " + file.getAbsolutePath(), ioe);
                    boolean bl = false;
                    Object var10_19 = null;
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException foo) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var10_20 = null;
                try {
                    if (fis != null) {
                        ((InputStream)fis).close();
                    }
                }
                catch (IOException foo) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    private static void saveCerts(String host, SavingTrustManager stm) {
        X509Certificate[] chain = stm.chain;
        if (chain == null) {
            System.out.println("Could not obtain server certificate chain");
            return;
        }
        for (int k = 0; k < chain.length; ++k) {
            X509Certificate cert = chain[k];
            String name = host + '-' + (k + 1) + ".crt";
            System.out.println("NOTE: Saving untrusted X509 certificate as " + name);
            System.out.println("      Issuer:     " + cert.getIssuerX500Principal());
            System.out.println("      Valid From: " + cert.getNotBefore());
            System.out.println("      Valid To:   " + cert.getNotAfter());
            try {
                cert.checkValidity();
            }
            catch (Exception e) {
                System.out.println("      WARNING: Certificate is not currently valid, it cannot be used");
            }
            SSLEepGet.saveCert(cert, new File(name));
        }
        System.out.println("NOTE: To trust them, copy the certificate file(s) to the certificates directory and rerun without the -s option");
        System.out.println("NOTE: EepGet failed, certificate error follows:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void saveCert(Certificate cert, File file) {
        block15: {
            FileOutputStream os = null;
            byte[] buf = cert.getEncoded();
            os = new FileOutputStream(file);
            PrintWriter wr = new PrintWriter(os);
            wr.println("-----BEGIN CERTIFICATE-----");
            String b64 = Base64.encode(buf, true);
            for (int i = 0; i < b64.length(); i += 64) {
                wr.println(b64.substring(i, Math.min(i + 64, b64.length())));
            }
            wr.println("-----END CERTIFICATE-----");
            wr.flush();
            Object var8_9 = null;
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
                break block15;
            }
            catch (IOException foo) {}
            break block15;
            {
                catch (CertificateEncodingException cee) {
                    System.out.println("Error writing X509 Certificate " + file.getAbsolutePath() + ' ' + cee);
                    Object var8_10 = null;
                    try {
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                        break block15;
                    }
                    catch (IOException foo) {}
                    break block15;
                }
                catch (IOException ioe) {
                    System.out.println("Error writing X509 Certificate " + file.getAbsolutePath() + ' ' + ioe);
                    Object var8_11 = null;
                    try {
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                        break block15;
                    }
                    catch (IOException foo) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    if (os != null) {
                        ((OutputStream)os).close();
                    }
                }
                catch (IOException foo) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public SSLState getSSLState() {
        return new SSLState(this._sslContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFetch(SocketTimeout timeout) throws IOException {
        this._headersRead = false;
        this._aborted = false;
        try {
            this.readHeaders();
            Object var3_2 = null;
            this._headersRead = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._headersRead = true;
            throw throwable;
        }
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP headers");
        }
        if (timeout != null) {
            timeout.resetTimer();
            if (this._fetchInactivityTimeout > 0L) {
                timeout.setInactivityTimeout(this._fetchInactivityTimeout);
            } else {
                timeout.setInactivityTimeout(60000L);
            }
        }
        if (this._redirectLocation != null) {
            throw new IOException("Server redirect to " + this._redirectLocation + " not allowed");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Headers read completely, reading " + this._bytesRemaining);
        }
        boolean strictSize = this._bytesRemaining >= 0L;
        I2PAppThread pusher = null;
        this._decompressException = null;
        if (this._isGzippedResponse) {
            PipedInputStream pi = BigPipedInputStream.getInstance();
            PipedOutputStream po = new PipedOutputStream(pi);
            pusher = new I2PAppThread(new EepGet.Gunzipper(pi, this._out), "EepGet Decompressor");
            this._out = po;
            pusher.start();
        }
        int remaining = (int)this._bytesRemaining;
        byte[] buf = new byte[16384];
        while (!(!this._keepFetching || remaining <= 0 && strictSize || this._aborted)) {
            int read;
            int toRead = buf.length;
            if (strictSize && toRead > remaining) {
                toRead = remaining;
            }
            if ((read = this._proxyIn.read(buf, 0, toRead)) == -1) break;
            if (timeout != null) {
                timeout.resetTimer();
            }
            this._out.write(buf, 0, read);
            this._bytesTransferred += (long)read;
            if ((remaining -= read) == 0 && this._encodingChunked) {
                int char1 = this._proxyIn.read();
                if (char1 == 13) {
                    int char2 = this._proxyIn.read();
                    if (char2 == 10) {
                        remaining = (int)this.readChunkLength();
                    } else {
                        this._out.write(char1);
                        this._out.write(char2);
                        this._bytesTransferred += 2L;
                        remaining -= 2;
                        read += 2;
                    }
                } else {
                    this._out.write(char1);
                    ++this._bytesTransferred;
                    --remaining;
                    ++read;
                }
            }
            if (timeout != null) {
                timeout.resetTimer();
            }
            if (this._bytesRemaining >= (long)read) {
                this._bytesRemaining -= (long)read;
            }
            if (read <= 0) continue;
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).bytesTransferred(this._alreadyTransferred, read, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url);
            }
            this._alreadyTransferred += (long)read;
        }
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
        if (this._isGzippedResponse) {
            try {
                pusher.join();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            pusher = null;
            if (this._decompressException != null) {
                this._keepFetching = false;
                throw this._decompressException;
            }
        }
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP data");
        }
        if (timeout != null) {
            timeout.cancel();
        }
        if (this._transferFailed) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).attemptFailed(this._url, this._bytesTransferred, this._bytesRemaining, this._currentAttempt, this._numRetries, new Exception("Attempt failed"));
            }
        } else if (this._bytesRemaining == -1L || remaining == 0) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).transferComplete(this._alreadyTransferred, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url, this._outputFile, this._notModified);
            }
        } else {
            throw new IOException("Disconnection on attempt " + this._currentAttempt + " after " + this._bytesTransferred);
        }
    }

    protected void sendRequest(SocketTimeout timeout) throws IOException {
        File outFile;
        if (this._outputStream == null && (outFile = new File(this._outputFile)).exists()) {
            this._alreadyTransferred = outFile.length();
        }
        String req = this.getRequest();
        URL url = new URL(this._actualURL);
        String host = null;
        int port = 0;
        if ("https".equals(url.getProtocol())) {
            host = url.getHost();
            port = url.getPort();
            if (port == -1) {
                port = 443;
            }
            this._proxy = this._sslContext != null ? this._sslContext.getSocketFactory().createSocket(host, port) : SSLSocketFactory.getDefault().createSocket(host, port);
        } else {
            throw new IOException("Only https supported: " + this._actualURL);
        }
        this._proxyIn = this._proxy.getInputStream();
        this._proxyOut = this._proxy.getOutputStream();
        try {
            this._proxyOut.write(DataHelper.getUTF8(req));
            this._proxyOut.flush();
        }
        catch (SSLHandshakeException sslhe) {
            this._log.error("SSL negotiation error with " + host + ':' + port + " - self-signed certificate or untrusted certificate authority?", sslhe);
            if (this._saveCerts && this._stm != null) {
                SSLEepGet.saveCerts(host, this._stm);
            } else if (this._commandLine) {
                System.out.println("FAILED (probably due to untrusted certificates) - Run with -s option to save certificates");
            }
            throw sslhe;
        }
        this._proxyIn = new BufferedInputStream(this._proxyIn);
        if (this._log.shouldLog(10)) {
            this._log.debug("Request flushed");
        }
    }

    public static class SSLState {
        private final SSLContext context;

        private SSLState(SSLContext ctx) {
            this.context = ctx;
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException();
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

