/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;

class ExpireJob
extends JobImpl {
    private final TunnelPool _pool;
    private final TunnelCreatorConfig _cfg;
    private boolean _leaseUpdated;
    private final long _dropAfter;
    private static final long OB_EARLY_EXPIRE = 30000L;
    private static final long IB_EARLY_EXPIRE = 37500L;

    public ExpireJob(RouterContext ctx, TunnelCreatorConfig cfg, TunnelPool pool) {
        super(ctx);
        this._pool = pool;
        this._cfg = cfg;
        long expire = cfg.getExpiration();
        if (this._pool.getSettings().isInbound()) {
            this._dropAfter = expire + 120000L;
            expire -= 37500L + ctx.random().nextLong(37500L);
        } else {
            this._dropAfter = expire + 60000L;
            expire -= 30000L + ctx.random().nextLong(30000L);
        }
        cfg.setExpiration(expire);
        this.getTiming().setStartAfter(expire);
    }

    public String getName() {
        return "Expire our tunnel";
    }

    public void runJob() {
        if (!this._leaseUpdated) {
            this._pool.removeTunnel(this._cfg);
            this._leaseUpdated = true;
            this._pool.refreshLeaseSet();
            long timeToDrop = this._dropAfter - this.getContext().clock().now();
            this.requeue(timeToDrop);
        } else {
            this.getContext().tunnelDispatcher().remove(this._cfg);
        }
    }
}

