/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.BuildRequestRecord;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.router.util.DecayingHashSet;
import net.i2p.util.Log;

public class BuildMessageProcessor {
    private final DecayingBloomFilter _filter;

    public BuildMessageProcessor(I2PAppContext ctx) {
        this._filter = new DecayingHashSet(ctx, 60000, 32, "TunnelBMP");
    }

    public BuildRequestRecord decrypt(I2PAppContext ctx, TunnelBuildMessage msg, Hash ourHash, PrivateKey privKey) {
        Log log = ctx.logManager().getLog(this.getClass());
        BuildRequestRecord rv = null;
        int ourHop = -1;
        long beforeActualDecrypt = 0L;
        long afterActualDecrypt = 0L;
        long totalEq = 0L;
        long totalDup = 0L;
        long beforeLoop = System.currentTimeMillis();
        for (int i = 0; i < msg.getRecordCount(); ++i) {
            ByteArray rec = msg.getRecord(i);
            int off = rec.getOffset();
            int len = 16;
            long beforeEq = System.currentTimeMillis();
            boolean eq = DataHelper.eq((byte[])ourHash.getData(), (int)0, (byte[])rec.getData(), (int)off, (int)len);
            totalEq += System.currentTimeMillis() - beforeEq;
            if (!eq) continue;
            long beforeIsDup = System.currentTimeMillis();
            boolean isDup = this._filter.add(rec.getData(), off + len, 32);
            totalDup += System.currentTimeMillis() - beforeIsDup;
            if (isDup) {
                if (log.shouldLog(30)) {
                    log.debug(msg.getUniqueId() + ": A record matching our hash was found, but it seems to be a duplicate");
                }
                ctx.statManager().addRateData("tunnel.buildRequestDup", 1L, 0L);
                return null;
            }
            BuildRequestRecord req = new BuildRequestRecord();
            beforeActualDecrypt = System.currentTimeMillis();
            boolean ok = req.decryptRecord(ctx, privKey, ourHash, rec);
            afterActualDecrypt = System.currentTimeMillis();
            if (ok) {
                if (log.shouldLog(10)) {
                    log.debug(msg.getUniqueId() + ": A record matching our hash was found and decrypted");
                }
            } else {
                if (log.shouldLog(10)) {
                    log.debug(msg.getUniqueId() + ": A record matching our hash was found, but could not be decrypted");
                }
                return null;
            }
            rv = req;
            ourHop = i;
        }
        if (rv == null) {
            if (log.shouldLog(10)) {
                log.debug(msg.getUniqueId() + ": No records matching our hash was found");
            }
            return null;
        }
        long beforeEncrypt = System.currentTimeMillis();
        SessionKey replyKey = rv.readReplyKey();
        byte[] iv = rv.readReplyIV();
        int ivOff = 0;
        for (int i = 0; i < msg.getRecordCount(); ++i) {
            if (i == ourHop) continue;
            ByteArray data = msg.getRecord(i);
            if (log.shouldLog(10)) {
                log.debug("Encrypting record " + i + "/?/" + data.getOffset() + "/" + data.getValid() + " with replyKey " + replyKey.toBase64() + "/" + Base64.encode((byte[])iv, (int)ivOff, (int)16));
            }
            ctx.aes().encrypt(data.getData(), data.getOffset(), data.getData(), data.getOffset(), replyKey, iv, ivOff, data.getValid());
        }
        long afterEncrypt = System.currentTimeMillis();
        msg.setRecord(ourHop, null);
        if (afterEncrypt - beforeLoop > 1000L && log.shouldLog(30)) {
            log.warn("Slow decryption, total=" + (afterEncrypt - beforeLoop) + " looping=" + (beforeEncrypt - beforeLoop) + " decrypt=" + (afterActualDecrypt - beforeActualDecrypt) + " eq=" + totalEq + " dup=" + totalDup + " encrypt=" + (afterEncrypt - beforeEncrypt));
        }
        return rv;
    }
}

