/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.util.Properties;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterAddress;
import net.i2p.router.transport.TransportImpl;
import net.i2p.util.Addresses;

public class NTCPAddress {
    private final int _port;
    private final String _host;
    public static final String PROP_PORT = "port";
    public static final String PROP_HOST = "host";
    public static final int DEFAULT_COST = 10;

    public NTCPAddress(String host, int port) {
        this._host = host != null ? host.trim() : null;
        this._port = port;
    }

    public NTCPAddress(RouterAddress addr) {
        if (addr == null) {
            this._host = null;
            this._port = -1;
            return;
        }
        this._host = addr.getOption(PROP_HOST);
        this._port = addr.getPort();
    }

    public RouterAddress toRouterAddress() {
        if (this._host == null || this._port <= 0) {
            return null;
        }
        RouterAddress addr = new RouterAddress();
        addr.setCost(10);
        Properties props = new Properties();
        props.setProperty(PROP_HOST, this._host);
        props.setProperty(PROP_PORT, "" + this._port);
        addr.setOptions(props);
        addr.setTransportStyle("NTCP");
        return addr;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public boolean isPubliclyRoutable() {
        return NTCPAddress.isPubliclyRoutable(this._host);
    }

    public static boolean isPubliclyRoutable(String host) {
        if (host == null) {
            return false;
        }
        byte[] quad = Addresses.getIP((String)host);
        return TransportImpl.isPubliclyRoutable(quad);
    }

    public String toString() {
        return this._host + ":" + this._port;
    }

    public int hashCode() {
        int rv = this._port;
        if (this._host != null) {
            rv ^= this._host.hashCode();
        }
        return rv;
    }

    public boolean equals(Object val) {
        if (val != null && val instanceof NTCPAddress) {
            String ourHost;
            NTCPAddress addr = (NTCPAddress)val;
            String hostname = null;
            if (addr.getHost() != null) {
                hostname = addr.getHost().trim();
            }
            if ((ourHost = this.getHost()) != null) {
                ourHost = ourHost.trim();
            }
            return DataHelper.eq((Object)hostname, (Object)ourHost) && this.getPort() == addr.getPort();
        }
        return false;
    }

    public boolean equals(RouterAddress addr) {
        if (addr == null) {
            return false;
        }
        return this._host.equals(addr.getOption(PROP_HOST)) && Integer.toString(this._port).equals(addr.getOption(PROP_PORT));
    }
}

