/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.TransportManager;
import net.i2p.router.transport.UPnP;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.Translate;
import org.cybergarage.util.Debug;
import org.freenetproject.DetectedIP;
import org.freenetproject.ForwardPort;
import org.freenetproject.ForwardPortCallback;
import org.freenetproject.ForwardPortStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UPnPManager {
    private final Log _log;
    private final RouterContext _context;
    private final UPnP _upnp;
    private final UPnPCallback _upnpCallback;
    private volatile boolean _isRunning;
    private InetAddress _detectedAddress;
    private final TransportManager _manager;
    private static final String PROP_HTTP_PORT = "i2np.upnp.HTTPPort";
    private static final int DEFAULT_HTTP_PORT = 7652;
    private static final String PROP_SSDP_PORT = "i2np.upnp.SSDPPort";
    private static final int DEFAULT_SSDP_PORT = 7653;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public UPnPManager(RouterContext context, TransportManager manager) {
        this._context = context;
        this._manager = manager;
        this._log = this._context.logManager().getLog(UPnPManager.class);
        org.cybergarage.upnp.UPnP.setEnable(9);
        Debug.initialize(context);
        this._upnp = new UPnP(context);
        this._upnp.setHTTPPort(this._context.getProperty(PROP_HTTP_PORT, 7652));
        this._upnp.setSSDPPort(this._context.getProperty(PROP_SSDP_PORT, 7653));
        this._upnpCallback = new UPnPCallback();
    }

    public synchronized void start() {
        if (this._log.shouldLog(10)) {
            this._log.debug("UPnP Start");
        }
        if (!this._isRunning) {
            long b = this._context.clock().now();
            try {
                this._isRunning = this._upnp.runPlugin();
                if (this._log.shouldLog(20)) {
                    this._log.info("UPnP runPlugin took " + (this._context.clock().now() - b));
                }
            }
            catch (Exception e) {
                this._log.error("UPnP error, please report", (Throwable)e);
            }
        }
        if (!this._isRunning) {
            if (!Addresses.isConnected()) {
                this._log.logAlways(30, "UPnP start failed - no network connection?");
            } else {
                this._log.error("UPnP start failed - port conflict?");
            }
        }
    }

    public synchronized void stop() {
        if (this._log.shouldLog(10)) {
            this._log.debug("UPnP Stop");
        }
        if (this._isRunning) {
            this._upnp.terminate();
        }
        this._isRunning = false;
        this._detectedAddress = null;
    }

    public void update(Map<String, Integer> ports) {
        if (this._log.shouldLog(10)) {
            this._log.debug("UPnP Update with " + ports.size() + " ports");
        }
        if (!this._isRunning) {
            return;
        }
        HashSet<ForwardPort> forwards = new HashSet<ForwardPort>(ports.size());
        for (Map.Entry<String, Integer> entry : ports.entrySet()) {
            String style = entry.getKey();
            int port = entry.getValue();
            int protocol = -1;
            if ("SSU".equals(style)) {
                protocol = 17;
            } else {
                if (!"NTCP".equals(style)) continue;
                protocol = 6;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Adding: " + style + " " + port);
            }
            ForwardPort fp = new ForwardPort(style, false, protocol, port);
            forwards.add(fp);
        }
        this._upnp.onChangePublicPorts(forwards, this._upnpCallback);
    }

    public String renderStatusHTML() {
        if (!this._isRunning) {
            return "<h3><a name=\"upnp\"></a>" + this._("UPnP is not enabled") + "</h3>\n";
        }
        return this._upnp.renderStatusHTML();
    }

    private final String _(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UPnPCallback
    implements ForwardPortCallback {
        private UPnPCallback() {
        }

        @Override
        public void portForwardStatus(Map<ForwardPort, ForwardPortStatus> statuses) {
            DetectedIP[] ips;
            if (UPnPManager.this._log.shouldLog(10)) {
                UPnPManager.this._log.debug("UPnP Callback:");
            }
            if ((ips = UPnPManager.this._upnp.getAddress()) != null) {
                for (DetectedIP ip : ips) {
                    if (!TransportImpl.isPubliclyRoutable(ip.publicAddress.getAddress())) continue;
                    if (UPnPManager.this._log.shouldLog(10)) {
                        UPnPManager.this._log.debug("External address: " + ip.publicAddress + " type: " + ip.natType);
                    }
                    if (!ip.publicAddress.equals(UPnPManager.this._detectedAddress)) {
                        UPnPManager.this._detectedAddress = ip.publicAddress;
                        UPnPManager.this._manager.externalAddressReceived("upnp", UPnPManager.this._detectedAddress.getAddress(), 0);
                    }
                    break;
                }
            } else if (UPnPManager.this._log.shouldLog(10)) {
                UPnPManager.this._log.debug("No external address returned");
            }
            for (Map.Entry<ForwardPort, ForwardPortStatus> entry : statuses.entrySet()) {
                String style;
                ForwardPort fp = entry.getKey();
                ForwardPortStatus fps = entry.getValue();
                if (UPnPManager.this._log.shouldLog(10)) {
                    UPnPManager.this._log.debug(fp.name + " " + fp.protocol + " " + fp.portNumber + " status: " + fps.status + " reason: " + fps.reasonString + " ext port: " + fps.externalPort);
                }
                if (fp.protocol == 17) {
                    style = "SSU";
                } else {
                    if (fp.protocol != 6) continue;
                    style = "NTCP";
                }
                boolean success = fps.status >= 1;
                UPnPManager.this._manager.forwardPortStatus(style, fp.portNumber, fps.externalPort, success, fps.reasonString);
            }
        }
    }
}

