/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Comparator;
import net.i2p.data.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XORComparator
implements Comparator<Hash> {
    private final byte[] _base;

    public XORComparator(Hash target) {
        this._base = target.getData();
    }

    @Override
    public int compare(Hash lhs, Hash rhs) {
        byte[] lhsb = lhs.getData();
        byte[] rhsb = rhs.getData();
        for (int i = 0; i < this._base.length; ++i) {
            int ld = (lhsb[i] ^ this._base[i]) & 0xFF;
            int rd = (rhsb[i] ^ this._base[i]) & 0xFF;
            if (ld < rd) {
                return -1;
            }
            if (ld <= rd) continue;
            return 1;
        }
        return 0;
    }
}

