/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.util.Log;

class FloodOnlyLookupMatchJob
extends JobImpl
implements ReplyJob {
    private final Log _log;
    private final FloodSearchJob _search;

    public FloodOnlyLookupMatchJob(RouterContext ctx, FloodSearchJob job) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
        this._search = job;
    }

    public void runJob() {
        if (this.getContext().netDb().lookupLocally(this._search.getKey()) != null) {
            if (this._log.shouldLog(20)) {
                this._log.info(this._search.getJobId() + ": search match and found locally");
            }
            this._search.success();
        } else {
            this._search.failed();
        }
    }

    public String getName() {
        return "NetDb flood search match";
    }

    public void setMessage(I2NPMessage message) {
        block6: {
            if (message instanceof DatabaseSearchReplyMessage) {
                this._search.failed();
                return;
            }
            try {
                DatabaseStoreMessage dsm = (DatabaseStoreMessage)message;
                if (this._log.shouldLog(20)) {
                    this._log.info(this._search.getJobId() + ": got a DSM for " + dsm.getKey().toBase64());
                }
                if (dsm.getEntry().getType() == 1) {
                    LeaseSet ls = (LeaseSet)dsm.getEntry();
                    ls.setReceivedAsReply();
                    this.getContext().netDb().store(dsm.getKey(), ls);
                } else {
                    this.getContext().netDb().store(dsm.getKey(), (RouterInfo)dsm.getEntry());
                }
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block6;
                this._log.warn(this._search.getJobId() + ": Received an invalid store reply", (Throwable)iae);
            }
        }
    }
}

