/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.Date;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.RequestLeaseSetMessage;
import net.i2p.data.i2cp.RequestVariableLeaseSetMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.LeaseRequestState;
import net.i2p.router.client.QueuedClientConnectionRunner;
import net.i2p.util.Log;

class RequestLeaseSetJob
extends JobImpl {
    private final Log _log;
    private final ClientConnectionRunner _runner;
    private final LeaseRequestState _requestState;
    private static final long MAX_FUDGE = 2000L;
    private static final String PROP_VARIABLE = "router.variableLeaseExpiration";
    private static final boolean DFLT_VARIABLE = true;

    public RequestLeaseSetJob(RouterContext ctx, ClientConnectionRunner runner, LeaseRequestState state) {
        super(ctx);
        this._log = ctx.logManager().getLog(RequestLeaseSetJob.class);
        this._runner = runner;
        this._requestState = state;
    }

    public String getName() {
        return "Request Lease Set";
    }

    public void runJob() {
        RequestLeaseSetMessage msg;
        RequestLeaseSetMessage rmsg;
        if (this._runner.isDead()) {
            return;
        }
        LeaseSet requested = this._requestState.getRequested();
        long endTime = requested.getEarliestLeaseDate();
        long fudge = 2000L - (endTime - this.getContext().clock().now()) / 300L;
        endTime += fudge;
        if (this.getContext().getProperty(PROP_VARIABLE, true) && (this._runner instanceof QueuedClientConnectionRunner || RequestVariableLeaseSetMessage.isSupported((String)this._runner.getClientVersion()))) {
            rmsg = new RequestVariableLeaseSetMessage();
            rmsg.setSessionId(this._runner.getSessionId());
            for (int i = 0; i < requested.getLeaseCount(); ++i) {
                Lease lease = requested.getLease(i);
                if (lease.getEndDate().getTime() < endTime) {
                    Lease nl = new Lease();
                    nl.setGateway(lease.getGateway());
                    nl.setTunnelId(lease.getTunnelId());
                    nl.setEndDate(new Date(endTime));
                    lease = nl;
                }
                rmsg.addEndpoint(lease);
            }
            msg = rmsg;
        } else {
            rmsg = new RequestLeaseSetMessage();
            Date end = new Date(endTime);
            rmsg.setEndDate(end);
            rmsg.setSessionId(this._runner.getSessionId());
            for (int i = 0; i < requested.getLeaseCount(); ++i) {
                Lease lease = requested.getLease(i);
                rmsg.addEndpoint(lease.getGateway(), lease.getTunnelId());
            }
            msg = rmsg;
        }
        try {
            this._runner.doSend((I2CPMessage)msg);
            this.getContext().jobQueue().addJob(new CheckLeaseRequestStatus());
        }
        catch (I2CPMessageException ime) {
            this.getContext().statManager().addRateData("client.requestLeaseSetDropped", 1L, 0L);
            this._log.error("Error sending I2CP message requesting the lease set", (Throwable)ime);
            this._requestState.setIsSuccessful(false);
            if (this._requestState.getOnFailed() != null) {
                this.getContext().jobQueue().addJob(this._requestState.getOnFailed());
            }
            this._runner.failLeaseRequest(this._requestState);
        }
    }

    private class CheckLeaseRequestStatus
    extends JobImpl {
        private final long _start;

        public CheckLeaseRequestStatus() {
            super(RequestLeaseSetJob.this.getContext());
            this._start = System.currentTimeMillis();
            this.getTiming().setStartAfter(RequestLeaseSetJob.this._requestState.getExpiration());
        }

        public void runJob() {
            if (RequestLeaseSetJob.this._runner.isDead()) {
                if (RequestLeaseSetJob.this._log.shouldLog(10)) {
                    RequestLeaseSetJob.this._log.debug("Already dead, dont try to expire the leaseSet lookup");
                }
                return;
            }
            if (RequestLeaseSetJob.this._requestState.getIsSuccessful()) {
                this.getContext().statManager().addRateData("client.requestLeaseSetSuccess", 1L);
                return;
            }
            this.getContext().statManager().addRateData("client.requestLeaseSetTimeout", 1L);
            if (RequestLeaseSetJob.this._log.shouldLog(40)) {
                long waited = System.currentTimeMillis() - this._start;
                RequestLeaseSetJob.this._log.error("Failed to receive a leaseSet in the time allotted (" + waited + "): " + RequestLeaseSetJob.this._requestState + " for " + RequestLeaseSetJob.this._runner.getConfig().getDestination().calculateHash().toBase64());
            }
            if (RequestLeaseSetJob.this._requestState.getOnFailed() != null) {
                RequestLeaseSetJob.this.getContext().jobQueue().addJob(RequestLeaseSetJob.this._requestState.getOnFailed());
            }
            RequestLeaseSetJob.this._runner.failLeaseRequest(RequestLeaseSetJob.this._requestState);
        }

        public String getName() {
            return "Check LeaseRequest Status";
        }
    }
}

