/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.util.VersionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseLookupMessage
extends FastI2NPMessageImpl {
    public static final int MESSAGE_TYPE = 2;
    private Hash _key;
    private Hash _fromHash;
    private TunnelId _replyTunnel;
    private List<Hash> _dontIncludePeers;
    private SessionKey _replyKey;
    private SessionTag _replyTag;
    private static final int MAX_NUM_PEERS = 512;
    private static final byte FLAG_TUNNEL = 1;
    private static final byte FLAG_ENCRYPT = 2;
    private static final String MIN_ENCRYPTION_VERSION = "0.9.7";

    public DatabaseLookupMessage(I2PAppContext context) {
        this(context, false);
    }

    public DatabaseLookupMessage(I2PAppContext context, boolean locallyCreated) {
        super(context);
    }

    public Hash getSearchKey() {
        return this._key;
    }

    public void setSearchKey(Hash key) {
        if (this._key != null) {
            throw new IllegalStateException();
        }
        this._key = key;
    }

    public Hash getFrom() {
        return this._fromHash;
    }

    public void setFrom(Hash from) {
        if (this._fromHash != null) {
            throw new IllegalStateException();
        }
        this._fromHash = from;
    }

    public TunnelId getReplyTunnel() {
        return this._replyTunnel;
    }

    public void setReplyTunnel(TunnelId replyTunnel) {
        if (this._replyTunnel != null) {
            throw new IllegalStateException();
        }
        this._replyTunnel = replyTunnel;
    }

    public static boolean supportsEncryptedReplies(RouterInfo to) {
        if (to == null) {
            return false;
        }
        String v = to.getOption("router.version");
        return v != null && VersionComparator.comp((String)v, (String)MIN_ENCRYPTION_VERSION) >= 0;
    }

    public SessionKey getReplyKey() {
        return this._replyKey;
    }

    public SessionTag getReplyTag() {
        return this._replyTag;
    }

    public void setReplySession(SessionKey encryptKey, SessionTag encryptTag) {
        if (this._replyKey != null || this._replyTag != null) {
            throw new IllegalStateException();
        }
        this._replyKey = encryptKey;
        this._replyTag = encryptTag;
    }

    public Set<Hash> getDontIncludePeers() {
        if (this._dontIncludePeers == null) {
            return null;
        }
        return new HashSet<Hash>(this._dontIncludePeers);
    }

    public void setDontIncludePeers(Collection<Hash> peers) {
        this._hasChecksum = false;
        this._dontIncludePeers = peers != null ? new ArrayList<Hash>(peers) : null;
    }

    public void addDontIncludePeer(Hash peer) {
        if (this._dontIncludePeers == null) {
            this._dontIncludePeers = new ArrayList<Hash>();
        } else if (this._dontIncludePeers.contains(peer)) {
            return;
        }
        this._hasChecksum = false;
        this._dontIncludePeers.add(peer);
    }

    public void addDontIncludePeers(Collection<Hash> peers) {
        this._hasChecksum = false;
        if (this._dontIncludePeers == null) {
            this._dontIncludePeers = new ArrayList<Hash>(peers);
        } else {
            for (Hash peer : peers) {
                if (this._dontIncludePeers.contains(peer)) continue;
                this._dontIncludePeers.add(peer);
            }
        }
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        if (type != 2) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        this._key = Hash.create((byte[])data, (int)curIndex);
        this._fromHash = Hash.create((byte[])data, (int)(curIndex += 32));
        boolean tunnelSpecified = (data[curIndex += 32] & 1) != 0;
        boolean replyKeySpecified = (data[curIndex] & 2) != 0;
        ++curIndex;
        if (tunnelSpecified) {
            this._replyTunnel = new TunnelId(DataHelper.fromLong((byte[])data, (int)curIndex, (int)4));
            curIndex += 4;
        }
        int numPeers = (int)DataHelper.fromLong((byte[])data, (int)curIndex, (int)2);
        curIndex += 2;
        if (numPeers < 0 || numPeers > 512) {
            throw new I2NPMessageException("Invalid number of peers - " + numPeers);
        }
        ArrayList<Hash> peers = new ArrayList<Hash>(numPeers);
        for (int i = 0; i < numPeers; ++i) {
            Hash p = Hash.create((byte[])data, (int)curIndex);
            curIndex += 32;
            peers.add(p);
        }
        this._dontIncludePeers = peers;
        if (replyKeySpecified) {
            byte[] rk = new byte[32];
            System.arraycopy(data, curIndex, rk, 0, 32);
            this._replyKey = new SessionKey(rk);
            curIndex += 32;
            byte[] rt = new byte[32];
            System.arraycopy(data, ++curIndex, rt, 0, 32);
            this._replyTag = new SessionTag(rt);
        }
    }

    @Override
    protected int calculateWrittenLength() {
        int totalLength = 0;
        totalLength += 64;
        ++totalLength;
        if (this._replyTunnel != null) {
            totalLength += 4;
        }
        totalLength += 2;
        if (this._dontIncludePeers != null) {
            totalLength += 32 * this._dontIncludePeers.size();
        }
        if (this._replyKey != null) {
            totalLength += 65;
        }
        return totalLength;
    }

    @Override
    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._key == null) {
            throw new I2NPMessageException("Key being searched for not specified");
        }
        if (this._fromHash == null) {
            throw new I2NPMessageException("From address not specified");
        }
        System.arraycopy(this._key.getData(), 0, out, curIndex, 32);
        System.arraycopy(this._fromHash.getData(), 0, out, curIndex += 32, 32);
        curIndex += 32;
        if (this._replyTunnel != null) {
            int flag = 1;
            if (this._replyKey != null) {
                flag = (byte)(flag | 2);
            }
            out[curIndex++] = flag;
            byte[] id = DataHelper.toLong((int)4, (long)this._replyTunnel.getTunnelId());
            System.arraycopy(id, 0, out, curIndex, 4);
            curIndex += 4;
        } else {
            out[curIndex++] = this._replyKey != null ? 2 : 0;
        }
        if (this._dontIncludePeers == null || this._dontIncludePeers.isEmpty()) {
            out[curIndex++] = 0;
            out[curIndex++] = 0;
        } else {
            int size = this._dontIncludePeers.size();
            if (size > 512) {
                throw new I2NPMessageException("Too many peers: " + size);
            }
            byte[] len = DataHelper.toLong((int)2, (long)size);
            out[curIndex++] = len[0];
            out[curIndex++] = len[1];
            for (Hash peer : this._dontIncludePeers) {
                System.arraycopy(peer.getData(), 0, out, curIndex, 32);
                curIndex += 32;
            }
        }
        if (this._replyKey != null) {
            System.arraycopy(this._replyKey.getData(), 0, out, curIndex, 32);
            curIndex += 32;
            out[curIndex++] = 1;
            System.arraycopy(this._replyTag.getData(), 0, out, curIndex, 32);
            curIndex += 32;
        }
        return curIndex;
    }

    @Override
    public int getType() {
        return 2;
    }

    public int hashCode() {
        return DataHelper.hashCode((Object)this._key) + DataHelper.hashCode((Object)this._fromHash) + DataHelper.hashCode((Object)this._replyTunnel) + DataHelper.hashCode(this._dontIncludePeers);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DatabaseLookupMessage) {
            DatabaseLookupMessage msg = (DatabaseLookupMessage)object;
            return DataHelper.eq((Object)this._key, (Object)msg._key) && DataHelper.eq((Object)this._fromHash, (Object)msg._fromHash) && DataHelper.eq((Object)this._replyTunnel, (Object)msg._replyTunnel) && DataHelper.eq(this._dontIncludePeers, msg._dontIncludePeers);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[DatabaseLookupMessage: ");
        buf.append("\n\tSearch Key: ").append(this._key);
        buf.append("\n\tFrom: ").append(this._fromHash);
        buf.append("\n\tReply Tunnel: ").append(this._replyTunnel);
        if (this._replyKey != null) {
            buf.append("\n\tReply Key: ").append(this._replyKey);
        }
        if (this._replyTag != null) {
            buf.append("\n\tReply Tag: ").append(this._replyTag);
        }
        buf.append("\n\tDont Include Peers: ");
        if (this._dontIncludePeers != null) {
            buf.append(this._dontIncludePeers.size());
        }
        buf.append("]");
        return buf.toString();
    }
}

