/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.web.SummaryRenderer;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.stat.RateSummaryListener;
import net.i2p.util.Log;
import net.i2p.util.SecureFile;
import net.i2p.util.SecureFileOutputStream;
import org.jrobin.core.Archive;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdMemoryBackendFactory;
import org.jrobin.core.Sample;

class SummaryListener
implements RateSummaryListener {
    static final String PROP_PERSISTENT = "routerconsole.graphPersistent";
    static final String RRD_DIR = "rrd";
    private static final String RRD_PREFIX = "rrd-";
    private static final String RRD_SUFFIX = ".jrb";
    static final String CF = "AVERAGE";
    private static final double XFF = 0.9;
    private static final int STEPS = 1;
    private final I2PAppContext _context = I2PAppContext.getGlobalContext();
    private final Log _log;
    private final Rate _rate;
    private final boolean _isPersistent;
    private String _name;
    private String _eventName;
    private RrdDb _db;
    private Sample _sample;
    private SummaryRenderer _renderer;
    private int _rows;
    static final int PERIODS = 1440;
    private static final int MIN_ROWS = 1440;
    static final int MAX_ROWS = 131040;
    private static final long THREE_MONTHS = 7862400000L;

    public SummaryListener(Rate r) {
        this._rate = r;
        this._log = this._context.logManager().getLog(SummaryListener.class);
        this._isPersistent = this._context.getBooleanPropertyDefaultTrue(PROP_PERSISTENT);
    }

    public void add(double totalValue, long eventCount, double totalEventTime, long period) {
        block4: {
            long now = this.now();
            long when = now / 1000L;
            if (this._db != null) {
                try {
                    this._sample.setTime(when);
                    double val = eventCount > 0L ? totalValue / (double)eventCount : 0.0;
                    this._sample.setValue(this._name, val);
                    this._sample.setValue(this._eventName, (double)eventCount);
                    this._sample.update();
                }
                catch (IOException ioe) {
                    this._log.error("Error adding", ioe);
                }
                catch (RrdException re) {
                    if (!this._log.shouldLog(30)) break block4;
                    this._log.warn("Error adding", re);
                }
            }
        }
    }

    static String createName(I2PAppContext ctx, String wanted) {
        return ctx.sha().calculateHash(DataHelper.getUTF8(wanted)).toBase64().substring(0, 20);
    }

    public Rate getRate() {
        return this._rate;
    }

    public boolean startListening() {
        RateStat rs = this._rate.getRateStat();
        long period = this._rate.getPeriod();
        String baseName = rs.getName() + "." + period;
        this._name = SummaryListener.createName(this._context, baseName);
        this._eventName = SummaryListener.createName(this._context, baseName + ".events");
        File rrdFile = null;
        try {
            String rrdDefName;
            RrdBackendFactory factory = RrdBackendFactory.getFactory(this.getBackendName());
            if (this._isPersistent) {
                SecureFile rrdDir = new SecureFile(this._context.getRouterDir(), RRD_DIR);
                rrdFile = new File(rrdDir, RRD_PREFIX + this._name + RRD_SUFFIX);
                rrdDefName = rrdFile.getAbsolutePath();
                if (rrdFile.exists()) {
                    this._db = new RrdDb(rrdDefName, factory);
                    Archive arch = this._db.getArchive(CF, 1);
                    if (arch == null) {
                        throw new IOException("No average CF in " + rrdDefName);
                    }
                    this._rows = arch.getRows();
                    if (this._log.shouldLog(20)) {
                        this._log.info("Existing RRD " + baseName + " (" + rrdDefName + ") with " + this._rows + " rows consuming " + this._db.getRrdBackend().getLength() + " bytes");
                    }
                } else {
                    ((File)rrdDir).mkdir();
                }
            } else {
                rrdDefName = this._name;
            }
            if (this._db == null) {
                RrdDef def = new RrdDef(rrdDefName, this.now() / 1000L, period / 1000L);
                long heartbeat = period * 10L / 1000L;
                def.addDatasource(this._name, "GAUGE", heartbeat, Double.NaN, Double.NaN);
                def.addDatasource(this._eventName, "GAUGE", heartbeat, 0.0, Double.NaN);
                this._rows = this._isPersistent ? (int)Math.max(1440L, Math.min(131040L, 7862400000L / period)) : 1440;
                def.addArchive(CF, 0.9, 1, this._rows);
                this._db = new RrdDb(def, factory);
                if (this._isPersistent) {
                    SecureFileOutputStream.setPerms(new File(rrdDefName));
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("New RRD " + baseName + " (" + rrdDefName + ") with " + this._rows + " rows consuming " + this._db.getRrdBackend().getLength() + " bytes");
                }
            }
            this._sample = this._db.createSample();
            this._renderer = new SummaryRenderer(this._context, this);
            this._rate.setSummaryListener(this);
            return true;
        }
        catch (OutOfMemoryError oom) {
            this._log.error("Error starting RRD for stat " + baseName, oom);
        }
        catch (RrdException re) {
            this._log.error("Error starting RRD for stat " + baseName, re);
            if (this._isPersistent && rrdFile != null) {
                rrdFile.delete();
            }
        }
        catch (IOException ioe) {
            this._log.error("Error starting RRD for stat " + baseName, ioe);
        }
        return false;
    }

    public void stopListening() {
        if (this._db == null) {
            return;
        }
        try {
            this._db.close();
        }
        catch (IOException ioe) {
            this._log.error("Error closing", ioe);
        }
        this._rate.setSummaryListener(null);
        if (!this._isPersistent) {
            try {
                ((RrdMemoryBackendFactory)RrdBackendFactory.getFactory("MEMORY")).delete(this._db.getPath());
            }
            catch (RrdException rrdException) {
                // empty catch block
            }
        }
        this._db = null;
    }

    public void renderPng(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit) throws IOException {
        this.renderPng(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit, null, null);
    }

    public void renderPng(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit, SummaryListener lsnr2, String titleOverride) throws IOException {
        if (this._renderer == null || this._db == null) {
            throw new IOException("No RRD, check logs for previous errors");
        }
        this._renderer.render(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit, lsnr2, titleOverride);
    }

    public void renderPng(OutputStream out) throws IOException {
        if (this._renderer == null || this._db == null) {
            throw new IOException("No RRD, check logs for previous errors");
        }
        this._renderer.render(out);
    }

    String getName() {
        return this._name;
    }

    String getEventName() {
        return this._eventName;
    }

    RrdDb getData() {
        return this._db;
    }

    long now() {
        return this._context.clock().now();
    }

    String getBackendName() {
        return this._isPersistent ? "NIO" : "MEMORY";
    }

    int getRows() {
        return this._rows;
    }

    public boolean equals(Object obj) {
        return obj instanceof SummaryListener && ((SummaryListener)obj)._rate.equals(this._rate);
    }

    public int hashCode() {
        return this._rate.hashCode();
    }
}

