/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.DummyNamingService;
import net.i2p.data.Destination;

public class ExecNamingService
extends DummyNamingService {
    private static final String PROP_EXEC_CMD = "i2p.naming.exec.command";
    private static final String DEFAULT_EXEC_CMD = "/usr/local/bin/i2presolve";
    private static final String PROP_SHELL_CMD = "i2p.naming.exec.shell";
    private static final String DEFAULT_SHELL_CMD = "/bin/bash";
    private static final int MAX_RESPONSE = 594;

    public ExecNamingService(I2PAppContext context) {
        super(context);
    }

    public Destination lookup(String hostname, Properties lookupOptions, Properties storedOptions) {
        Destination d = super.lookup(hostname, null, null);
        if (d != null) {
            return d;
        }
        if (hostname.length() == 60 && hostname.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
            return null;
        }
        String key = this.fetchAddr(hostname = hostname.toLowerCase(Locale.US));
        if (key != null) {
            this._log.error("Success: " + hostname);
            d = this.lookupBase64(key);
            ExecNamingService.putCache(hostname, d);
            return d;
        }
        return null;
    }

    private String fetchAddr(String hostname) {
        String command;
        String[] commandArr = new String[]{this._context.getProperty(PROP_SHELL_CMD, DEFAULT_SHELL_CMD), "-c", command = this._context.getProperty(PROP_EXEC_CMD, DEFAULT_EXEC_CMD) + " " + hostname};
        try {
            Process get = Runtime.getRuntime().exec(commandArr);
            get.waitFor();
            int exitValue = get.exitValue();
            if (exitValue != 0) {
                this._log.error("Exit " + exitValue + " from " + commandArr[0] + " " + commandArr[1] + " \"" + command + "\"");
                return null;
            }
            InputStream is = get.getInputStream();
            byte[] input = new byte[594];
            int count = is.read(input);
            is.close();
            if (count < 516) {
                this._log.error("Short response: " + command);
                return null;
            }
            String key = new String(input);
            if (key.startsWith(hostname + "=")) {
                key = key.substring(hostname.length() + 1);
            }
            if (!(key = key.substring(0, 516)).endsWith("AA")) {
                this._log.error("Invalid key: " + command);
                return null;
            }
            if (key.replaceAll("[a-zA-Z0-9~-]", "").length() != 0) {
                this._log.error("Invalid chars: " + command);
                return null;
            }
            return key;
        }
        catch (Throwable t) {
            this._log.error("Error fetching the addr", t);
            return null;
        }
    }
}

