/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.DummyNamingService;
import net.i2p.client.naming.NamingServiceListener;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.VersionComparator;
import net.metanotion.io.RAIFile;
import net.metanotion.io.Serializer;
import net.metanotion.io.block.BlockFile;
import net.metanotion.io.block.index.BSkipList;
import net.metanotion.io.data.IntBytes;
import net.metanotion.io.data.UTF8StringBytes;
import net.metanotion.util.skiplist.SkipIterator;
import net.metanotion.util.skiplist.SkipList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockfileNamingService
extends DummyNamingService {
    private final BlockFile _bf;
    private final RAIFile _raf;
    private final List<String> _lists;
    private final List<InvalidEntry> _invalid;
    private final Map<String, String> _negativeCache;
    private volatile boolean _isClosed;
    private final boolean _readOnly;
    private boolean _needsUpgrade;
    private static final Serializer _infoSerializer = new PropertiesSerializer();
    private static final Serializer _stringSerializer = new UTF8StringBytes();
    private static final Serializer _destSerializer = new DestEntrySerializer();
    private static final Serializer _hashIndexSerializer = new IntBytes();
    private static final String HOSTS_DB = "hostsdb.blockfile";
    private static final String FALLBACK_LIST = "hosts.txt";
    private static final String PROP_FORCE = "i2p.naming.blockfile.writeInAppContext";
    private static final String INFO_SKIPLIST = "%%__INFO__%%";
    private static final String REVERSE_SKIPLIST = "%%__REVERSE__%%";
    private static final String PROP_INFO = "info";
    private static final String PROP_VERSION = "version";
    private static final String PROP_LISTS = "lists";
    private static final String PROP_CREATED = "created";
    private static final String PROP_UPGRADED = "upgraded";
    private static final String VERSION = "3";
    private static final String PROP_ADDED = "a";
    private static final String PROP_SOURCE = "s";
    private static final String DUMMY = "";
    private static final int NEGATIVE_CACHE_SIZE = 32;

    public BlockfileNamingService(I2PAppContext context) {
        File f;
        boolean readOnly;
        RAIFile raf;
        BlockFile bf;
        block17: {
            super(context);
            this._lists = new ArrayList<String>();
            this._invalid = new ArrayList<InvalidEntry>();
            this._negativeCache = new LHMCache<String, String>(32);
            bf = null;
            raf = null;
            readOnly = false;
            f = new File(this._context.getRouterDir(), HOSTS_DB);
            if (f.exists()) {
                try {
                    readOnly = !f.canWrite() || !context.isRouterContext() && !context.getBooleanProperty(PROP_FORCE);
                    raf = new RAIFile(f, true, !readOnly);
                    bf = this.initExisting(raf);
                    if (readOnly && context.isRouterContext()) {
                        this._log.logAlways(30, "Read-only hosts database in router context");
                    }
                    if (bf.wasMounted()) {
                        if (context.isRouterContext()) {
                            this._log.logAlways(30, "The hosts database was not closed cleanly or is still open by another process");
                        } else {
                            this._log.logAlways(30, "The hosts database is possibly in use by another process, perhaps the router? The database is not designed for simultaneous access by multiple processes.\nIf you are using clients outside the router JVM, consider using the hosts.txt naming service with i2p.naming.impl=net.i2p.client.naming.HostsTxtNamingService");
                        }
                    }
                }
                catch (IOException ioe) {
                    if (raf != null) {
                        try {
                            raf.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    File corrupt = new File(this._context.getRouterDir(), "hostsdb.blockfile.corrupt");
                    this._log.log(50, "Corrupt or unreadable database " + f + ", moving to " + corrupt + " and creating new database", ioe);
                    boolean success = f.renameTo(corrupt);
                    if (success) break block17;
                    this._log.log(50, "Failed to move corrupt database " + f + " to " + corrupt);
                }
            }
        }
        if (bf == null) {
            try {
                raf = new RAIFile(f, true, true);
                SecureFileOutputStream.setPerms(f);
                bf = this.init(raf);
            }
            catch (IOException ioe) {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this._log.log(50, "Failed to initialize database", ioe);
                throw new RuntimeException(ioe);
            }
            readOnly = false;
        }
        this._bf = bf;
        this._raf = raf;
        this._readOnly = readOnly;
        if (this._needsUpgrade) {
            this.upgrade();
        }
        this._context.addShutdownTask(new Shutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlockFile init(RAIFile f) throws IOException {
        start = this._context.clock().now();
        try {
            rv = new BlockFile(f, true);
            hdr = rv.makeIndex("%%__INFO__%%", BlockfileNamingService._stringSerializer, BlockfileNamingService._infoSerializer);
            info = new Properties();
            info.setProperty("version", "3");
            info.setProperty("created", Long.toString(this._context.clock().now()));
            list = this._context.getProperty("i2p.hostsfilelist", "privatehosts.txt,userhosts.txt,hosts.txt");
            info.setProperty("lists", list);
            hdr.put((Comparable)"info", info);
            rv.makeIndex("%%__REVERSE__%%", BlockfileNamingService._hashIndexSerializer, BlockfileNamingService._infoSerializer);
            total = 0;
            for (String hostsfile : BlockfileNamingService.getFilenames(list)) {
                block15: {
                    file = new File(this._context.getRouterDir(), hostsfile);
                    if (!file.exists() || !file.canRead()) continue;
                    count = 0;
                    in = null;
                    sourceMsg = "Imported from " + hostsfile + " file";
                    try {
                        try {
                            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"), 16384);
                            line = null;
                            while ((line = in.readLine()) != null) {
                                if (line.startsWith("#") || (split = line.indexOf(61)) <= 0) continue;
                                key = line.substring(0, split).toLowerCase(Locale.US);
                                if (line.indexOf(35) > 0 && (line = line.substring(0, line.indexOf(35)).trim()).length() < split + 1) continue;
                                b64 = line.substring(split + 1);
                                d = this.lookupBase64(b64);
                                if (d != null) {
                                    this.addEntry(rv, hostsfile, key, d, sourceMsg);
                                    BlockfileNamingService.addReverseEntry(rv, key, d, this._log);
                                    ++count;
                                    continue;
                                }
                                this._log.logAlways(30, "Unable to import entry for " + key + " from file " + file + " - bad Base 64: " + b64);
                            }
                            var21_21 = null;
                            if (in == null) break block15;
                        }
                        catch (IOException ioe) {
                            this._log.error("Failed to read hosts from " + file, ioe);
                            var21_21 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException ioe) {}
                            }
                            break block15;
                        }
                    }
                    catch (Throwable var20_23) {
                        var21_21 = null;
                        if (in == null) throw var20_23;
                        ** try [egrp 3[TRYBLOCK] [4 : 530->538)] { 
lbl58:
                        // 1 sources

                        in.close();
                        throw var20_23;
lbl60:
                        // 1 sources

                        catch (IOException ioe) {
                            // empty catch block
                        }
                        throw var20_23;
                    }
                    try {}
                    catch (IOException ioe) {}
                    in.close();
                }
                total += count;
                this._log.logAlways(20, "Migrating " + count + " hosts from " + file + " to new hosts database");
                this._lists.add(hostsfile);
            }
            if (this._log.shouldLog(20)) {
                this._log.info("DB init took " + DataHelper.formatDuration(this._context.clock().now() - start));
            }
            if (total > 0) return rv;
            this._log.logAlways(30, "No hosts.txt files found, Initialized hosts database with zero entries");
            return rv;
        }
        catch (RuntimeException e) {
            this._log.error("Failed to initialize database", e);
            throw new IOException(e.toString());
        }
    }

    private BlockFile initExisting(RAIFile raf) throws IOException {
        long start = this._context.clock().now();
        try {
            List<String> skiplists;
            BlockFile bf = new BlockFile(raf, false);
            BSkipList hdr = bf.getIndex(INFO_SKIPLIST, _stringSerializer, _infoSerializer);
            if (hdr == null) {
                throw new IOException("No db header");
            }
            Properties info = (Properties)hdr.get((Comparable)((Object)PROP_INFO));
            if (info == null) {
                throw new IOException("No header info");
            }
            String list = info.getProperty(PROP_LISTS);
            if (list == null) {
                throw new IOException("No lists");
            }
            long createdOn = 0L;
            String created = info.getProperty(PROP_CREATED);
            if (created != null) {
                try {
                    createdOn = Long.parseLong(created);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            String version = info.getProperty(PROP_VERSION);
            this._needsUpgrade = this.needsUpgrade(bf, version);
            if (this._needsUpgrade) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Upgrading from database version " + version + " to " + VERSION + " created " + new Date(createdOn).toString() + " containing lists: " + list);
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("Found database version " + version + " created " + new Date(createdOn).toString() + " containing lists: " + list);
            }
            if ((skiplists = BlockfileNamingService.getFilenames(list)).isEmpty()) {
                skiplists.add(FALLBACK_LIST);
            }
            this._lists.addAll(skiplists);
            if (this._log.shouldLog(20)) {
                this._log.info("DB init took " + DataHelper.formatDuration(this._context.clock().now() - start));
            }
            return bf;
        }
        catch (RuntimeException e) {
            this._log.error("Failed to initialize database", e);
            throw new IOException(e.toString());
        }
    }

    private boolean needsUpgrade(BlockFile bf, String version) throws IOException {
        if (version != null && VersionComparator.comp(version, VERSION) >= 0) {
            return false;
        }
        if (!bf.file.canWrite()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Not upgrading read-only database version " + version);
            }
            return false;
        }
        return true;
    }

    private boolean upgrade() {
        try {
            BSkipList hdr;
            BSkipList rev = this._bf.getIndex(REVERSE_SKIPLIST, _hashIndexSerializer, _infoSerializer);
            if (rev == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Created reverse index");
                }
                rev = this._bf.makeIndex(REVERSE_SKIPLIST, _hashIndexSerializer, _infoSerializer);
            }
            Map<String, Destination> entries = this.getEntries();
            long start = System.currentTimeMillis();
            int i = 0;
            for (Map.Entry<String, Destination> entry : entries.entrySet()) {
                this.addReverseEntry(entry.getKey(), entry.getValue());
                ++i;
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Updated reverse index with " + i + " entries");
            }
            if ((hdr = this._bf.getIndex(INFO_SKIPLIST, _stringSerializer, _infoSerializer)) == null) {
                throw new IOException("No db header");
            }
            Properties info = (Properties)hdr.get((Comparable)((Object)PROP_INFO));
            if (info == null) {
                throw new IOException("No header info");
            }
            info.setProperty(PROP_VERSION, VERSION);
            info.setProperty(PROP_UPGRADED, Long.toString(this._context.clock().now()));
            hdr.put((Comparable)((Object)PROP_INFO), info);
            if (this._log.shouldLog(30)) {
                this._log.warn("Upgraded to version 3 in " + DataHelper.formatDuration(System.currentTimeMillis() - start));
            }
            return true;
        }
        catch (IOException ioe) {
            this._log.error("Error upgrading DB", ioe);
        }
        catch (RuntimeException e) {
            this._log.error("Error upgrading DB", e);
        }
        return false;
    }

    private DestEntry getEntry(String listname, String key) throws IOException {
        try {
            BSkipList sl = this._bf.getIndex(listname, _stringSerializer, _destSerializer);
            if (sl == null) {
                return null;
            }
            DestEntry rv = (DestEntry)sl.get((Comparable)((Object)key));
            return rv;
        }
        catch (IOException ioe) {
            this._log.error("DB Lookup error", ioe);
            throw ioe;
        }
        catch (RuntimeException e) {
            this._log.error("DB Lookup error", e);
            throw new IOException(e.toString());
        }
    }

    private void addEntry(BlockFile bf, String listname, String key, Destination dest, String source) throws IOException {
        try {
            BSkipList sl = bf.getIndex(listname, _stringSerializer, _destSerializer);
            if (sl == null) {
                sl = bf.makeIndex(listname, _stringSerializer, _destSerializer);
            }
            Properties props = new Properties();
            props.setProperty(PROP_ADDED, Long.toString(this._context.clock().now()));
            if (source != null) {
                props.setProperty(PROP_SOURCE, source);
            }
            BlockfileNamingService.addEntry(sl, key, dest, props);
        }
        catch (IOException ioe) {
            this._log.error("DB add error", ioe);
            throw ioe;
        }
        catch (RuntimeException e) {
            this._log.error("DB add error", e);
            throw new IOException(e.toString());
        }
    }

    private static void addEntry(SkipList sl, String key, Destination dest, Properties props) {
        DestEntry de = new DestEntry();
        de.dest = dest;
        de.props = props;
        sl.put((Comparable)((Object)key), de);
    }

    private static List<String> getFilenames(String list) {
        StringTokenizer tok = new StringTokenizer(list, ",");
        ArrayList<String> rv = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            rv.add(tok.nextToken());
        }
        return rv;
    }

    private static Object removeEntry(SkipList sl, String key) {
        return sl.remove((Comparable)((Object)key));
    }

    private String getReverseEntry(Hash hash) {
        try {
            BSkipList rev = this._bf.getIndex(REVERSE_SKIPLIST, _hashIndexSerializer, _infoSerializer);
            if (rev == null) {
                return null;
            }
            Integer idx = BlockfileNamingService.getReverseKey(hash);
            Properties props = (Properties)rev.get(idx);
            if (props == null) {
                return null;
            }
            for (Object okey : props.keySet()) {
                String key = (String)okey;
                Destination d = this.lookup(key);
                if (d == null || !d.calculateHash().equals(hash)) continue;
                return key;
            }
        }
        catch (IOException ioe) {
            this._log.error("DB get reverse error", ioe);
        }
        catch (RuntimeException e) {
            this._log.error("DB get reverse error", e);
        }
        return null;
    }

    private void addReverseEntry(String key, Destination dest) {
        BlockfileNamingService.addReverseEntry(this._bf, key, dest, this._log);
    }

    private static void addReverseEntry(BlockFile bf, String key, Destination dest, Log log) {
        try {
            BSkipList rev = bf.getIndex(REVERSE_SKIPLIST, _hashIndexSerializer, _infoSerializer);
            if (rev == null) {
                return;
            }
            Integer idx = BlockfileNamingService.getReverseKey(dest);
            Properties props = (Properties)rev.get(idx);
            if (props != null) {
                if (props.getProperty(key) != null) {
                    return;
                }
            } else {
                props = new Properties();
            }
            props.put(key, DUMMY);
            rev.put(idx, props);
        }
        catch (IOException ioe) {
            log.error("DB add reverse error", ioe);
        }
        catch (RuntimeException e) {
            log.error("DB add reverse error", e);
        }
    }

    private void removeReverseEntry(String key, Destination dest) {
        try {
            BSkipList rev = this._bf.getIndex(REVERSE_SKIPLIST, _hashIndexSerializer, _infoSerializer);
            if (rev == null) {
                return;
            }
            Integer idx = BlockfileNamingService.getReverseKey(dest);
            Properties props = (Properties)rev.get(idx);
            if (props == null || props.remove(key) == null) {
                return;
            }
            if (props.isEmpty()) {
                rev.remove(idx);
            } else {
                rev.put(idx, props);
            }
        }
        catch (IOException ioe) {
            this._log.error("DB remove reverse error", ioe);
        }
        catch (RuntimeException e) {
            this._log.error("DB remove reverse error", e);
        }
    }

    private static Integer getReverseKey(Destination dest) {
        return BlockfileNamingService.getReverseKey(dest.calculateHash());
    }

    private static Integer getReverseKey(Hash hash) {
        byte[] hashBytes = hash.getData();
        int i = (int)DataHelper.fromLong(hashBytes, 0, 4);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination lookup(String hostname, Properties lookupOptions, Properties storedOptions) {
        String listname = null;
        if (lookupOptions != null) {
            listname = lookupOptions.getProperty("list");
        }
        Destination d = null;
        if (listname == null && storedOptions == null) {
            d = super.lookup(hostname, null, null);
            if (d != null) {
                return d;
            }
            if (hostname.length() == 60 && hostname.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
                return null;
            }
        }
        String key = hostname.toLowerCase(Locale.US);
        Map<String, String> map = this._negativeCache;
        synchronized (map) {
            if (this._negativeCache.get(key) != null) {
                return null;
            }
        }
        map = this._bf;
        synchronized (map) {
            if (this._isClosed) {
                return null;
            }
            for (String list : this._lists) {
                if (listname != null && !list.equals(listname)) continue;
                try {
                    DestEntry de = this.getEntry(list, key);
                    if (de == null || !this.validate(key, de, listname)) continue;
                    d = de.dest;
                    if (storedOptions == null || de.props == null) break;
                    storedOptions.putAll((Map<?, ?>)de.props);
                }
                catch (IOException ioe) {}
                break;
            }
            this.deleteInvalid();
        }
        if (d != null) {
            BlockfileNamingService.putCache(hostname, d);
        } else {
            map = this._negativeCache;
            synchronized (map) {
                this._negativeCache.put(key, DUMMY);
            }
        }
        return d;
    }

    @Override
    public boolean put(String hostname, Destination d, Properties options) {
        return this.put(hostname, d, options, false);
    }

    @Override
    public boolean putIfAbsent(String hostname, Destination d, Properties options) {
        return this.put(hostname, d, options, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean put(String hostname, Destination d, Properties options, boolean checkExisting) {
        if (this._readOnly) {
            this._log.error("Add entry failed, read-only hosts database");
            return false;
        }
        String key = hostname.toLowerCase(Locale.US);
        Map<String, String> map = this._negativeCache;
        synchronized (map) {
            this._negativeCache.remove(key);
        }
        String listname = FALLBACK_LIST;
        Properties props = new Properties();
        props.setProperty(PROP_ADDED, Long.toString(this._context.clock().now()));
        if (options != null) {
            props.putAll((Map<?, ?>)options);
            String list = options.getProperty("list");
            if (list != null) {
                listname = list;
                props.remove("list");
            }
        }
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            if (this._isClosed) {
                return false;
            }
            try {
                boolean changed;
                BSkipList sl = this._bf.getIndex(listname, _stringSerializer, _destSerializer);
                if (sl == null) {
                    sl = this._bf.makeIndex(listname, _stringSerializer, _destSerializer);
                }
                boolean bl = changed = (checkExisting || !this._listeners.isEmpty()) && sl.get((Comparable)((Object)key)) != null;
                if (changed && checkExisting) {
                    return false;
                }
                BlockfileNamingService.addEntry(sl, key, d, props);
                if (changed) {
                    BlockfileNamingService.removeCache(hostname);
                }
                this.addReverseEntry(key, d);
                for (NamingServiceListener nsl : this._listeners) {
                    if (changed) {
                        nsl.entryChanged(this, hostname, d, options);
                        continue;
                    }
                    nsl.entryAdded(this, hostname, d, options);
                }
                return true;
            }
            catch (IOException ioe) {
                this._log.error("DB add error", ioe);
                return false;
            }
            catch (RuntimeException re) {
                this._log.error("DB add error", re);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String hostname, Properties options) {
        String list;
        if (this._readOnly) {
            this._log.error("Remove entry failed, read-only hosts database");
            return false;
        }
        String key = hostname.toLowerCase(Locale.US);
        String listname = FALLBACK_LIST;
        if (options != null && (list = options.getProperty("list")) != null) {
            listname = list;
        }
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            if (this._isClosed) {
                return false;
            }
            try {
                boolean rv;
                BSkipList sl = this._bf.getIndex(listname, _stringSerializer, _destSerializer);
                if (sl == null) {
                    return false;
                }
                Object removed = BlockfileNamingService.removeEntry(sl, key);
                boolean bl = rv = removed != null;
                if (rv) {
                    BlockfileNamingService.removeCache(hostname);
                    try {
                        this.removeReverseEntry(key, ((DestEntry)removed).dest);
                    }
                    catch (ClassCastException cce) {
                        this._log.error("DB reverse remove error", cce);
                    }
                    for (NamingServiceListener nsl : this._listeners) {
                        nsl.entryRemoved(this, key);
                    }
                }
                return rv;
            }
            catch (IOException ioe) {
                this._log.error("DB remove error", ioe);
                return false;
            }
            catch (RuntimeException re) {
                this._log.error("DB remove error", re);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Destination> getEntries(Properties options) {
        Object sk;
        String listname = FALLBACK_LIST;
        String search = null;
        String startsWith = null;
        String beginWith = null;
        int limit = Integer.MAX_VALUE;
        int skip = 0;
        if (options != null) {
            String ln = options.getProperty("list");
            if (ln != null) {
                listname = ln;
            }
            search = options.getProperty("search");
            startsWith = options.getProperty("startsWith");
            beginWith = options.getProperty("beginWith");
            if (beginWith == null && startsWith != null) {
                beginWith = startsWith.equals("[0-9]") ? "0" : startsWith;
            }
            String lim = options.getProperty("limit");
            try {
                limit = Integer.parseInt(lim);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            sk = options.getProperty("skip");
            try {
                skip = Integer.parseInt((String)sk);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Searching " + listname + " beginning with " + beginWith + " starting with " + startsWith + " search string " + search + " limit=" + limit + " skip=" + skip);
        }
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            HashMap<String, Destination> hashMap;
            block23: {
                if (this._isClosed) {
                    return Collections.EMPTY_MAP;
                }
                try {
                    block22: {
                        Map map;
                        try {
                            int i;
                            BSkipList sl = this._bf.getIndex(listname, _stringSerializer, _destSerializer);
                            if (sl == null) {
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("No skiplist found for lookup in " + listname);
                                }
                                sk = Collections.EMPTY_MAP;
                                Object var16_16 = null;
                                break block22;
                            }
                            SkipIterator iter = beginWith != null ? ((SkipList)sl).find((Comparable)((Object)beginWith)) : ((SkipList)sl).iterator();
                            HashMap<String, Destination> rv = new HashMap<String, Destination>();
                            for (i = 0; i < skip && iter.hasNext(); ++i) {
                                iter.next();
                            }
                            i = 0;
                            while (i < limit && iter.hasNext()) {
                                String key = (String)((Object)iter.nextKey());
                                if (startsWith != null && (!startsWith.equals("[0-9]") ? !key.startsWith(startsWith) : key.charAt(0) > '9')) break;
                                DestEntry de = (DestEntry)iter.next();
                                if (!this.validate(key, de, listname) || search != null && key.indexOf(search) < 0) continue;
                                rv.put(key, de.dest);
                                ++i;
                            }
                            hashMap = rv;
                            break block23;
                        }
                        catch (IOException ioe) {
                            this._log.error("DB lookup error", ioe);
                            map = Collections.EMPTY_MAP;
                            Object var16_18 = null;
                            this.deleteInvalid();
                            return map;
                        }
                        catch (RuntimeException re) {
                            this._log.error("DB lookup error", re);
                            map = Collections.EMPTY_MAP;
                            Object var16_19 = null;
                            this.deleteInvalid();
                            return map;
                        }
                    }
                    this.deleteInvalid();
                    return sk;
                }
                catch (Throwable throwable) {
                    Object var16_20 = null;
                    this.deleteInvalid();
                    throw throwable;
                }
            }
            Object var16_17 = null;
            this.deleteInvalid();
            return hashMap;
        }
    }

    @Override
    public String reverseLookup(Destination d, Properties options) {
        return this.reverseLookup(d.calculateHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String reverseLookup(Hash h) {
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            if (this._isClosed) {
                return null;
            }
            return this.getReverseEntry(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(Properties options) {
        String list;
        String listname = FALLBACK_LIST;
        if (options != null && (list = options.getProperty("list")) != null) {
            listname = list;
        }
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            if (this._isClosed) {
                return 0;
            }
            try {
                BSkipList sl = this._bf.getIndex(listname, _stringSerializer, _destSerializer);
                if (sl == null) {
                    return 0;
                }
                return sl.size();
            }
            catch (IOException ioe) {
                this._log.error("DB size error", ioe);
                return 0;
            }
            catch (RuntimeException re) {
                this._log.error("DB size error", re);
                return 0;
            }
        }
    }

    @Override
    public void shutdown() {
        this.close();
    }

    private boolean validate(String key, DestEntry de, String listname) {
        boolean rv;
        if (key == null) {
            return false;
        }
        boolean bl = rv = key.length() > 0 && de != null && de.dest != null && de.dest.getPublicKey() != null;
        if (!rv && !this._readOnly) {
            this._invalid.add(new InvalidEntry(key, listname));
        }
        return rv;
    }

    private void deleteInvalid() {
        if (this._invalid.isEmpty()) {
            return;
        }
        this._log.error("Removing " + this._invalid.size() + " corrupt entries from database");
        for (InvalidEntry ie : this._invalid) {
            String key = ie.key;
            String list = ie.list;
            try {
                boolean success;
                BSkipList sl = this._bf.getIndex(list, _stringSerializer, _destSerializer);
                if (sl == null) {
                    this._log.error("No list found to remove corrupt \"" + key + "\" from database " + list);
                    continue;
                }
                boolean bl = success = BlockfileNamingService.removeEntry(sl, key) != null;
                if (success) {
                    this._log.error("Removed corrupt \"" + key + "\" from database " + list);
                    continue;
                }
                this._log.error("May have Failed to remove corrupt \"" + key + "\" from database " + list);
            }
            catch (RuntimeException re) {
                this._log.error("Error while removing corrupt \"" + key + "\" from database " + list, re);
            }
            catch (IOException ioe) {
                this._log.error("Error while removing corrput \"" + key + "\" from database " + list, ioe);
            }
        }
        this._invalid.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        Object object = this._bf;
        synchronized (object) {
            block12: {
                try {
                    this._bf.close();
                }
                catch (IOException ioe) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Error closing", ioe);
                    }
                }
                catch (RuntimeException e) {
                    if (!this._log.shouldLog(30)) break block12;
                    this._log.warn("Error closing", e);
                }
            }
            try {
                this._raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._isClosed = true;
        }
        object = this._negativeCache;
        synchronized (object) {
            this._negativeCache.clear();
        }
        BlockfileNamingService.clearCache();
    }

    private static void logError(String msg, Throwable t) {
        I2PAppContext.getGlobalContext().logManager().getLog(BlockfileNamingService.class).error(msg, t);
    }

    public static void main(String[] args) {
        Properties ctxProps = new Properties();
        if (args.length > 0 && args[0].equals("force")) {
            ctxProps.setProperty(PROP_FORCE, "true");
        }
        I2PAppContext ctx = new I2PAppContext(ctxProps);
        BlockfileNamingService bns = new BlockfileNamingService(ctx);
        bns.close();
    }

    private static class InvalidEntry {
        public final String key;
        public final String list;

        public InvalidEntry(String k, String l) {
            this.key = k;
            this.list = l;
        }
    }

    private static class DestEntrySerializer
    implements Serializer {
        private DestEntrySerializer() {
        }

        public byte[] getBytes(Object o) {
            DestEntry de = (DestEntry)o;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                try {
                    DataHelper.writeProperties(baos, de.props, true, false);
                }
                catch (DataFormatException dfe) {
                    BlockfileNamingService.logError("DB Write Fail - properties too big?", dfe);
                    baos.write(new byte[2]);
                }
                de.dest.writeBytes(baos);
            }
            catch (IOException ioe) {
                BlockfileNamingService.logError("DB Write Fail", ioe);
            }
            catch (DataFormatException dfe) {
                BlockfileNamingService.logError("DB Write Fail", dfe);
            }
            return baos.toByteArray();
        }

        public Object construct(byte[] b) {
            Destination dest;
            DestEntry rv = new DestEntry();
            rv.dest = dest = new Destination();
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            try {
                rv.props = DataHelper.readProperties(bais);
                dest.readBytes(bais);
            }
            catch (IOException ioe) {
                BlockfileNamingService.logError("DB Read Fail", ioe);
                return null;
            }
            catch (DataFormatException dfe) {
                BlockfileNamingService.logError("DB Read Fail", dfe);
                return null;
            }
            return rv;
        }
    }

    private static class DestEntry {
        public Properties props;
        public Destination dest;

        private DestEntry() {
        }

        public String toString() {
            return "DestEntry (" + DataHelper.toString(this.props) + ") " + this.dest.toString();
        }
    }

    private static class PropertiesSerializer
    implements Serializer {
        private PropertiesSerializer() {
        }

        public byte[] getBytes(Object o) {
            Properties p = (Properties)o;
            try {
                return DataHelper.toProperties(p);
            }
            catch (DataFormatException dfe) {
                BlockfileNamingService.logError("DB Write Fail - properties too big?", dfe);
                return new byte[2];
            }
        }

        public Object construct(byte[] b) {
            Properties rv = new Properties();
            try {
                DataHelper.fromProperties(b, 0, rv);
            }
            catch (DataFormatException dfe) {
                BlockfileNamingService.logError("DB Read Fail", dfe);
                return null;
            }
            return rv;
        }
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        public void run() {
            BlockfileNamingService.this.close();
        }
    }
}

