/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.router.web.RouterConsoleRunner;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppConfiguration
implements Configuration {
    private static final String CLASSPATH = ".classpath";

    private void configureClassPath(WebAppContext wac) throws Exception {
        String cp;
        String ctxPath = wac.getContextPath();
        if (ctxPath.equals("/")) {
            return;
        }
        String appName = ctxPath.substring(1);
        if (ctxPath.equals("/susimail")) {
            wac.addSystemClass("org.eclipse.jetty.http.");
            wac.addSystemClass("org.eclipse.jetty.io.");
            wac.addSystemClass("org.eclipse.jetty.util.");
            ArrayList<String> classes = new ArrayList<String>(16);
            classes.addAll(Arrays.asList(wac.getServerClasses()));
            classes.remove("org.eclipse.jetty.");
            classes.add("-org.eclipse.jetty.http.");
            classes.add("-org.eclipse.jetty.io.");
            classes.add("-org.eclipse.jetty.util.");
            classes.add("org.eclipse.jetty.");
            wac.setServerClasses(classes.toArray(new String[classes.size()]));
        }
        I2PAppContext i2pContext = I2PAppContext.getGlobalContext();
        File libDir = new File(i2pContext.getBaseDir(), "lib");
        File pluginDir = new File(i2pContext.getConfigDir(), "plugins" + ctxPath);
        File dir = libDir;
        if (ctxPath.equals("/susimail")) {
            cp = "jetty-util.jar";
        } else if (pluginDir.exists()) {
            File consoleDir = new File(pluginDir, "console");
            Properties props = RouterConsoleRunner.webAppProperties(consoleDir.getAbsolutePath());
            cp = props.getProperty("webapps." + appName + CLASSPATH);
            dir = pluginDir;
        } else {
            Properties props = RouterConsoleRunner.webAppProperties(i2pContext);
            cp = props.getProperty("webapps." + appName + CLASSPATH);
        }
        if (cp == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(cp, " ,");
        StringBuilder buf = new StringBuilder();
        Set<URL> systemCP = WebAppConfiguration.getSystemClassPath();
        while (tok.hasMoreTokens()) {
            String elem;
            if (buf.length() > 0) {
                buf.append(',');
            }
            String path = (elem = tok.nextToken().trim()).startsWith("$I2P") ? i2pContext.getBaseDir().getAbsolutePath() + elem.substring(4) : (elem.startsWith("$PLUGIN") ? dir.getAbsolutePath() + elem.substring(7) : dir.getAbsolutePath() + '/' + elem);
            File jfile = new File(path);
            File jdir = jfile.getParentFile();
            if ((systemCP.contains(jfile.toURI().toURL()) || jdir != null && systemCP.contains(jdir.toURI().toURL())) && !ctxPath.equals("/susimail")) continue;
            System.err.println("Adding " + path + " to classpath for " + appName);
            buf.append(path);
        }
        if (buf.length() <= 0) {
            return;
        }
        ClassLoader cl = wac.getClassLoader();
        if (cl != null && cl instanceof WebAppClassLoader) {
            WebAppClassLoader wacl = (WebAppClassLoader)cl;
            wacl.addClassPath(buf.toString());
        } else {
            wac.setExtraClasspath(buf.toString());
        }
    }

    private static Set<URL> getSystemClassPath() {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = urlClassLoader.getURLs();
        HashSet<URL> rv = new HashSet<URL>(32);
        for (int i = 0; i < urls.length; ++i) {
            rv.add(urls[i]);
        }
        return rv;
    }

    public void deconfigure(WebAppContext context) {
    }

    public void configure(WebAppContext context) throws Exception {
        this.configureClassPath(context);
    }

    public void cloneConfigure(WebAppContext template, WebAppContext context) {
    }

    public void destroy(WebAppContext context) {
    }

    public void preConfigure(WebAppContext context) {
    }

    public void postConfigure(WebAppContext context) {
    }
}

