/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateTask;
import net.i2p.update.UpdateType;
import net.i2p.util.EepGet;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.PartialEepGet;
import net.i2p.util.VersionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdateRunner
extends I2PAppThread
implements UpdateTask,
EepGet.StatusListener {
    protected final RouterContext _context;
    protected final Log _log;
    protected final ConsoleUpdateManager _mgr;
    protected final List<URI> _urls;
    protected final String _updateFile;
    protected volatile boolean _isRunning;
    protected boolean done;
    protected EepGet _get;
    protected boolean _isPartial;
    protected String _newVersion;
    protected final ByteArrayOutputStream _baos;
    protected URI _currentURI;
    private final String _currentVersion;
    private static final String SIGNED_UPDATE_FILE = "i2pupdate.sud";
    protected static final long CONNECT_TIMEOUT = 55000L;
    protected static final long INACTIVITY_TIMEOUT = 300000L;
    protected static final long NOPROXY_INACTIVITY_TIMEOUT = 60000L;

    public UpdateRunner(RouterContext ctx, ConsoleUpdateManager mgr, List<URI> uris) {
        this(ctx, mgr, uris, "0.9.7.1");
    }

    public UpdateRunner(RouterContext ctx, ConsoleUpdateManager mgr, List<URI> uris, String currentVersion) {
        super("Update Runner");
        this.setDaemon(true);
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._mgr = mgr;
        this._urls = uris;
        this._baos = new ByteArrayOutputStream(TrustedUpdate.HEADER_BYTES);
        this._updateFile = new File(ctx.getTempDir(), "update" + ctx.random().nextInt() + ".tmp").getAbsolutePath();
        this._currentVersion = currentVersion;
    }

    @Override
    public boolean isRunning() {
        return this._isRunning;
    }

    @Override
    public void shutdown() {
        this._isRunning = false;
        this.interrupt();
    }

    @Override
    public UpdateType getType() {
        return UpdateType.ROUTER_SIGNED;
    }

    @Override
    public UpdateMethod getMethod() {
        return UpdateMethod.HTTP;
    }

    @Override
    public URI getURI() {
        return this._currentURI;
    }

    @Override
    public String getID() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._isRunning = true;
        try {
            this.update();
        }
        catch (Throwable t) {
            this._mgr.notifyTaskFailed(this, "", t);
        }
        finally {
            this._isRunning = false;
        }
    }

    protected void update() {
        boolean shouldProxy = Boolean.valueOf(this._context.getProperty("router.updateThroughProxy", ConfigUpdateHandler.DEFAULT_SHOULD_PROXY));
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = ConfigUpdateHandler.proxyPort(this._context);
        if (this._urls.isEmpty()) {
            this.updateStatus("<b>Update source list is empty, cannot download update</b>");
            this._log.error("Update source list is empty - cannot download update");
            this._mgr.notifyTaskFailed(this, "", null);
            return;
        }
        Iterator<URI> i$ = this._urls.iterator();
        while (i$.hasNext()) {
            URI uri;
            this._currentURI = uri = i$.next();
            String updateURL = uri.toString();
            this.updateStatus("<b>" + this._("Updating from {0}", UpdateRunner.linkify(updateURL)) + "</b>");
            if (this._log.shouldLog(10)) {
                this._log.debug("Selected update URL: " + updateURL);
            }
            if (shouldProxy) {
                this._isPartial = true;
                this._baos.reset();
                try {
                    this._get = new PartialEepGet((I2PAppContext)this._context, proxyHost, proxyPort, this._baos, updateURL, TrustedUpdate.HEADER_BYTES);
                    this._get.addStatusListener(this);
                    this._get.fetch(55000L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this._isPartial = false;
                if (this._newVersion == null) continue;
            }
            try {
                this._get = shouldProxy ? new EepGet((I2PAppContext)this._context, proxyHost, proxyPort, 40, this._updateFile, updateURL, false) : new EepGet(this._context, 1, this._updateFile, updateURL, false);
                this._get.addStatusListener(this);
                this._get.fetch(55000L, -1L, shouldProxy ? 300000L : 60000L);
            }
            catch (Throwable t) {
                this._log.error("Error updating", t);
            }
            if (!this.done) continue;
            break;
        }
        new File(this._updateFile).delete();
        if (!this.done) {
            this._mgr.notifyTaskFailed(this, "", null);
        }
    }

    @Override
    public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Attempt failed on " + url, cause);
        }
        this._mgr.notifyAttemptFailed(this, url, null);
    }

    @Override
    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
        if (this._isPartial) {
            return;
        }
        long d = (long)currentWrite + bytesTransferred;
        String status = "<b>" + this._("Updating") + "</b>";
        this._mgr.notifyProgress(this, status, d, d + bytesRemaining);
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        if (this._isPartial) {
            boolean newer;
            String newVersion = TrustedUpdate.getVersionString(new ByteArrayInputStream(this._baos.toByteArray()));
            boolean bl = newer = VersionComparator.comp(newVersion, this._currentVersion) > 0;
            if (newer) {
                this._newVersion = newVersion;
            } else {
                this.updateStatus("<b>" + this._("No new version found at {0}", UpdateRunner.linkify(url)) + "</b>");
                if (this._log.shouldLog(30)) {
                    this._log.warn("Found old version \"" + newVersion + "\" at " + url);
                }
            }
            return;
        }
        File tmp = new File(this._updateFile);
        if (this._mgr.notifyComplete(this, this._newVersion, tmp)) {
            this.done = true;
        } else {
            tmp.delete();
        }
    }

    @Override
    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Update from " + url + " did not download completely (" + bytesRemaining + " remaining after " + currentAttempt + " tries)");
        }
        this.updateStatus("<b>" + this._("Transfer failed from {0}", UpdateRunner.linkify(url)) + "</b>");
        this._mgr.notifyAttemptFailed(this, url, null);
    }

    @Override
    public void headerReceived(String url, int attemptNum, String key, String val) {
    }

    @Override
    public void attempting(String url) {
    }

    protected void updateStatus(String s) {
        this._mgr.notifyProgress(this, s);
    }

    protected static String linkify(String url) {
        return ConsoleUpdateManager.linkify(url);
    }

    protected String _(String s) {
        return this._mgr._(s);
    }

    protected String _(String s, Object o) {
        return this._mgr._(s, o);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ' ' + (Object)((Object)this.getType()) + ' ' + this.getID() + ' ' + (Object)((Object)this.getMethod()) + ' ' + this.getURI();
    }
}

