/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SHA1Hash;
import net.i2p.data.DataHelper;
import net.i2p.kademlia.KBucketSet;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.dht.KBTrimmer;
import org.klomp.snark.dht.NID;
import org.klomp.snark.dht.NodeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DHTNodes {
    private final I2PAppContext _context;
    private long _expireTime;
    private final Log _log;
    private final ConcurrentHashMap<NID, NodeInfo> _nodeMap;
    private final KBucketSet<NID> _kad;
    private volatile boolean _isRunning;
    private static final long CLEAN_TIME = 187000L;
    private static final long MAX_EXPIRE_TIME = 1800000L;
    private static final long MIN_EXPIRE_TIME = 600000L;
    private static final long DELTA_EXPIRE_TIME = 180000L;
    private static final int MAX_PEERS = 799;
    private static final long MAX_BUCKET_AGE = 900000L;
    private static final int KAD_K = 8;
    private static final int KAD_B = 1;

    public DHTNodes(I2PAppContext ctx, NID me) {
        this._context = ctx;
        this._expireTime = 1800000L;
        this._log = this._context.logManager().getLog(DHTNodes.class);
        this._nodeMap = new ConcurrentHashMap();
        this._kad = new KBucketSet<NID>(ctx, me, 8, 1, new KBTrimmer(ctx, 8));
    }

    public void start() {
        this._isRunning = true;
        new Cleaner();
    }

    public void stop() {
        this.clear();
        this._isRunning = false;
    }

    public int size() {
        return this._nodeMap.size();
    }

    public void clear() {
        this._kad.clear();
        this._nodeMap.clear();
    }

    public NodeInfo get(NID nid) {
        return this._nodeMap.get(nid);
    }

    public NodeInfo putIfAbsent(NodeInfo nInfo) {
        NodeInfo rv = this._nodeMap.putIfAbsent(nInfo.getNID(), nInfo);
        if (rv != null) {
            this._kad.add(rv.getNID());
        } else {
            this._kad.add(nInfo.getNID());
        }
        return rv;
    }

    public NodeInfo remove(NID nid) {
        this._kad.remove(nid);
        return this._nodeMap.remove(nid);
    }

    public Collection<NodeInfo> values() {
        return this._nodeMap.values();
    }

    public List<NodeInfo> findClosest(SHA1Hash h, int numWant) {
        NID key = h instanceof NID ? (NID)h : new NID(h.getData());
        List<NID> keys = this._kad.getClosest(key, numWant);
        ArrayList<NodeInfo> rv = new ArrayList<NodeInfo>(keys.size());
        for (NID nid : keys) {
            NodeInfo ninfo = this._nodeMap.get(nid);
            if (ninfo == null) continue;
            rv.add(ninfo);
        }
        return rv;
    }

    public List<NID> getExploreKeys() {
        return this._kad.getExploreKeys(900000L);
    }

    public void renderStatusHTML(StringBuilder buf) {
        buf.append(this._kad.toString().replace("\n", "<br>\n"));
    }

    private class Cleaner
    extends SimpleTimer2.TimedEvent {
        public Cleaner() {
            super(SimpleTimer2.getInstance(), 935000L);
        }

        public void timeReached() {
            if (!DHTNodes.this._isRunning) {
                return;
            }
            long now = DHTNodes.this._context.clock().now();
            int peerCount = 0;
            Iterator<NodeInfo> iter = DHTNodes.this.values().iterator();
            while (iter.hasNext()) {
                NodeInfo peer = iter.next();
                if (peer.lastSeen() < now - DHTNodes.this._expireTime) {
                    iter.remove();
                    DHTNodes.this._kad.remove(peer.getNID());
                    continue;
                }
                ++peerCount;
            }
            if (peerCount > 799) {
                DHTNodes.this._expireTime = Math.max(DHTNodes.this._expireTime - 180000L, 600000L);
            } else {
                DHTNodes.this._expireTime = Math.min(DHTNodes.this._expireTime + 180000L, 1800000L);
            }
            if (DHTNodes.this._log.shouldLog(10)) {
                DHTNodes.this._log.debug("DHT storage cleaner done, now with " + peerCount + " peers, " + DataHelper.formatDuration(DHTNodes.this._expireTime) + " expiration");
            }
            this.schedule(187000L);
        }
    }
}

