/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.cybergarage.http.HTTP;
import org.cybergarage.http.HTTPResponse;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.ActionList;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.ServiceStateTable;
import org.cybergarage.upnp.StateVariable;
import org.cybergarage.upnp.UPnP;
import org.cybergarage.upnp.control.ActionListener;
import org.cybergarage.upnp.control.QueryListener;
import org.cybergarage.upnp.device.InvalidDescriptionException;
import org.cybergarage.upnp.device.ST;
import org.cybergarage.upnp.event.NotifyRequest;
import org.cybergarage.upnp.event.Subscriber;
import org.cybergarage.upnp.event.SubscriberList;
import org.cybergarage.upnp.ssdp.SSDPNotifyRequest;
import org.cybergarage.upnp.ssdp.SSDPNotifySocket;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.upnp.xml.ServiceData;
import org.cybergarage.util.Debug;
import org.cybergarage.util.Mutex;
import org.cybergarage.util.StringUtil;
import org.cybergarage.xml.Node;
import org.cybergarage.xml.Parser;
import org.cybergarage.xml.ParserException;

public class Service {
    public static final String ELEM_NAME = "service";
    private Node serviceNode;
    public static final String SCPD_ROOTNODE = "scpd";
    public static final String SCPD_ROOTNODE_NS = "urn:schemas-upnp-org:service-1-0";
    public static final String SPEC_VERSION = "specVersion";
    public static final String MAJOR = "major";
    public static final String MAJOR_VALUE = "1";
    public static final String MINOR = "minor";
    public static final String MINOR_VALUE = "0";
    private Mutex mutex = new Mutex();
    private static final String SERVICE_TYPE = "serviceType";
    private static final String SERVICE_ID = "serviceId";
    private static final String SCPDURL = "SCPDURL";
    private static final String CONTROL_URL = "controlURL";
    private static final String EVENT_SUB_URL = "eventSubURL";
    private Object userData = null;

    public Node getServiceNode() {
        return this.serviceNode;
    }

    public Service() {
        this(new Node(ELEM_NAME));
        Node sp = new Node(SPEC_VERSION);
        Node M = new Node(MAJOR);
        M.setValue(MAJOR_VALUE);
        sp.addNode(M);
        Node m = new Node(MINOR);
        m.setValue(MINOR_VALUE);
        sp.addNode(m);
        Node scpd = new Node(SCPD_ROOTNODE);
        scpd.addAttribute("xmlns", SCPD_ROOTNODE_NS);
        scpd.addNode(sp);
        this.getServiceData().setSCPDNode(scpd);
    }

    public Service(Node node) {
        this.serviceNode = node;
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public static boolean isServiceNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    private Node getDeviceNode() {
        Node node = this.getServiceNode().getParentNode();
        if (node == null) {
            return null;
        }
        return node.getParentNode();
    }

    private Node getRootNode() {
        return this.getServiceNode().getRootNode();
    }

    public Device getDevice() {
        return new Device(this.getRootNode(), this.getDeviceNode());
    }

    public Device getRootDevice() {
        return this.getDevice().getRootDevice();
    }

    public void setServiceType(String value) {
        this.getServiceNode().setNode(SERVICE_TYPE, value);
    }

    public String getServiceType() {
        return this.getServiceNode().getNodeValue(SERVICE_TYPE);
    }

    public void setServiceID(String value) {
        this.getServiceNode().setNode(SERVICE_ID, value);
    }

    public String getServiceID() {
        return this.getServiceNode().getNodeValue(SERVICE_ID);
    }

    private boolean isURL(String referenceUrl, String url) {
        if (referenceUrl == null || url == null) {
            return false;
        }
        boolean ret = url.equals(referenceUrl);
        if (ret) {
            return true;
        }
        String relativeRefUrl = HTTP.toRelativeURL(referenceUrl, false);
        ret = url.equals(relativeRefUrl);
        return ret;
    }

    public void setSCPDURL(String value) {
        this.getServiceNode().setNode(SCPDURL, value);
    }

    public String getSCPDURL() {
        return this.getServiceNode().getNodeValue(SCPDURL);
    }

    public boolean isSCPDURL(String url) {
        return this.isURL(this.getSCPDURL(), url);
    }

    public void setControlURL(String value) {
        this.getServiceNode().setNode(CONTROL_URL, value);
    }

    public String getControlURL() {
        return this.getServiceNode().getNodeValue(CONTROL_URL);
    }

    public boolean isControlURL(String url) {
        return this.isURL(this.getControlURL(), url);
    }

    public void setEventSubURL(String value) {
        this.getServiceNode().setNode(EVENT_SUB_URL, value);
    }

    public String getEventSubURL() {
        return this.getServiceNode().getNodeValue(EVENT_SUB_URL);
    }

    public boolean isEventSubURL(String url) {
        return this.isURL(this.getEventSubURL(), url);
    }

    public boolean loadSCPD(String scpdStr) throws InvalidDescriptionException {
        try {
            Parser parser = UPnP.getXMLParser();
            Node scpdNode = parser.parse(scpdStr);
            if (scpdNode == null) {
                return false;
            }
            ServiceData data = this.getServiceData();
            data.setSCPDNode(scpdNode);
        }
        catch (ParserException e) {
            throw new InvalidDescriptionException(e);
        }
        return true;
    }

    public boolean loadSCPD(File file) throws ParserException {
        Parser parser = UPnP.getXMLParser();
        Node scpdNode = parser.parse(file);
        if (scpdNode == null) {
            return false;
        }
        ServiceData data = this.getServiceData();
        data.setSCPDNode(scpdNode);
        return true;
    }

    public boolean loadSCPD(InputStream input) throws ParserException {
        Parser parser = UPnP.getXMLParser();
        Node scpdNode = parser.parse(input);
        if (scpdNode == null) {
            return false;
        }
        ServiceData data = this.getServiceData();
        data.setSCPDNode(scpdNode);
        return true;
    }

    public void setDescriptionURL(String value) {
        this.getServiceData().setDescriptionURL(value);
    }

    public String getDescriptionURL() {
        return this.getServiceData().getDescriptionURL();
    }

    private Node getSCPDNode(URL scpdUrl) throws ParserException {
        Parser parser = UPnP.getXMLParser();
        return parser.parse(scpdUrl);
    }

    private Node getSCPDNode(File scpdFile) throws ParserException {
        Parser parser = UPnP.getXMLParser();
        return parser.parse(scpdFile);
    }

    private Node getSCPDNode() {
        File f;
        ServiceData data = this.getServiceData();
        Node scpdNode = data.getSCPDNode();
        if (scpdNode != null) {
            return scpdNode;
        }
        Device rootDev = this.getRootDevice();
        if (rootDev == null) {
            return null;
        }
        String scpdURLStr = this.getSCPDURL();
        String rootDevPath = rootDev.getDescriptionFilePath();
        if (rootDevPath != null && (f = new File(rootDevPath.concat(scpdURLStr))).exists()) {
            try {
                scpdNode = this.getSCPDNode(f);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            if (scpdNode != null) {
                data.setSCPDNode(scpdNode);
                return scpdNode;
            }
        }
        try {
            URL scpdUrl = new URL(rootDev.getAbsoluteURL(scpdURLStr));
            scpdNode = this.getSCPDNode(scpdUrl);
            if (scpdNode != null) {
                data.setSCPDNode(scpdNode);
                return scpdNode;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String newScpdURLStr = rootDev.getDescriptionFilePath() + HTTP.toRelativeURL(scpdURLStr);
        try {
            scpdNode = this.getSCPDNode(new File(newScpdURLStr));
            return scpdNode;
        }
        catch (Exception e) {
            Debug.warning(e);
            return null;
        }
    }

    public byte[] getSCPDData() {
        Node scpdNode = this.getSCPDNode();
        if (scpdNode == null) {
            return new byte[0];
        }
        String desc = new String();
        desc = desc + "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        desc = desc + "\n";
        desc = desc + scpdNode.toString();
        return desc.getBytes();
    }

    public ActionList getActionList() {
        ActionList actionList = new ActionList();
        Node scdpNode = this.getSCPDNode();
        if (scdpNode == null) {
            return actionList;
        }
        Node actionListNode = scdpNode.getNode("actionList");
        if (actionListNode == null) {
            return actionList;
        }
        int nNode = actionListNode.getNNodes();
        for (int n = 0; n < nNode; ++n) {
            Node node = actionListNode.getNode(n);
            if (!Action.isActionNode(node)) continue;
            Action action = new Action(this.serviceNode, node);
            actionList.add(action);
        }
        return actionList;
    }

    public Action getAction(String actionName) {
        ActionList actionList = this.getActionList();
        int nActions = actionList.size();
        for (int n = 0; n < nActions; ++n) {
            Action action = actionList.getAction(n);
            String name = action.getName();
            if (name == null || !name.equals(actionName)) continue;
            return action;
        }
        return null;
    }

    public void addAction(Action a) {
        for (Argument arg : a.getArgumentList()) {
            arg.setService(this);
        }
        Node scdpNode = this.getSCPDNode();
        Node actionListNode = scdpNode.getNode("actionList");
        if (actionListNode == null) {
            actionListNode = new Node("actionList");
            scdpNode.addNode(actionListNode);
        }
        actionListNode.addNode(a.getActionNode());
    }

    public ServiceStateTable getServiceStateTable() {
        ServiceStateTable stateTable = new ServiceStateTable();
        Node stateTableNode = this.getSCPDNode().getNode("serviceStateTable");
        if (stateTableNode == null) {
            return stateTable;
        }
        Node serviceNode = this.getServiceNode();
        int nNode = stateTableNode.getNNodes();
        for (int n = 0; n < nNode; ++n) {
            Node node = stateTableNode.getNode(n);
            if (!StateVariable.isStateVariableNode(node)) continue;
            StateVariable serviceVar = new StateVariable(serviceNode, node);
            stateTable.add(serviceVar);
        }
        return stateTable;
    }

    public StateVariable getStateVariable(String name) {
        ServiceStateTable stateTable = this.getServiceStateTable();
        int tableSize = stateTable.size();
        for (int n = 0; n < tableSize; ++n) {
            StateVariable var = stateTable.getStateVariable(n);
            String varName = var.getName();
            if (varName == null || !varName.equals(name)) continue;
            return var;
        }
        return null;
    }

    public boolean hasStateVariable(String name) {
        return this.getStateVariable(name) != null;
    }

    public boolean isService(String name) {
        if (name == null) {
            return false;
        }
        if (name.endsWith(this.getServiceType())) {
            return true;
        }
        return name.endsWith(this.getServiceID());
    }

    private ServiceData getServiceData() {
        Node node = this.getServiceNode();
        ServiceData userData = (ServiceData)node.getUserData();
        if (userData == null) {
            userData = new ServiceData();
            node.setUserData(userData);
            userData.setNode(node);
        }
        return userData;
    }

    private String getNotifyServiceTypeNT() {
        return this.getServiceType();
    }

    private String getNotifyServiceTypeUSN() {
        return this.getDevice().getUDN() + "::" + this.getServiceType();
    }

    public void announce(String bindAddr) {
        Device rootDev = this.getRootDevice();
        String devLocation = rootDev.getLocationURL(bindAddr);
        String serviceNT = this.getNotifyServiceTypeNT();
        String serviceUSN = this.getNotifyServiceTypeUSN();
        Device dev = this.getDevice();
        SSDPNotifyRequest ssdpReq = new SSDPNotifyRequest();
        ssdpReq.setServer(UPnP.getServerName());
        ssdpReq.setLeaseTime(dev.getLeaseTime());
        ssdpReq.setLocation(devLocation);
        ssdpReq.setNTS("ssdp:alive");
        ssdpReq.setNT(serviceNT);
        ssdpReq.setUSN(serviceUSN);
        SSDPNotifySocket ssdpSock = new SSDPNotifySocket(bindAddr);
        Device.notifyWait();
        ssdpSock.post(ssdpReq);
    }

    public void byebye(String bindAddr) {
        String devNT = this.getNotifyServiceTypeNT();
        String devUSN = this.getNotifyServiceTypeUSN();
        SSDPNotifyRequest ssdpReq = new SSDPNotifyRequest();
        ssdpReq.setNTS("ssdp:byebye");
        ssdpReq.setNT(devNT);
        ssdpReq.setUSN(devUSN);
        SSDPNotifySocket ssdpSock = new SSDPNotifySocket(bindAddr);
        Device.notifyWait();
        ssdpSock.post(ssdpReq);
    }

    public boolean serviceSearchResponse(SSDPPacket ssdpPacket) {
        String serviceType;
        String ssdpST = ssdpPacket.getST();
        if (ssdpST == null) {
            return false;
        }
        Device dev = this.getDevice();
        String serviceNT = this.getNotifyServiceTypeNT();
        String serviceUSN = this.getNotifyServiceTypeUSN();
        if (ST.isAllDevice(ssdpST)) {
            dev.postSearchResponse(ssdpPacket, serviceNT, serviceUSN);
        } else if (ST.isURNService(ssdpST) && ssdpST.equals(serviceType = this.getServiceType())) {
            dev.postSearchResponse(ssdpPacket, serviceType, serviceUSN);
        }
        return true;
    }

    public void setQueryListener(QueryListener queryListener) {
        ServiceStateTable stateTable = this.getServiceStateTable();
        int tableSize = stateTable.size();
        for (int n = 0; n < tableSize; ++n) {
            StateVariable var = stateTable.getStateVariable(n);
            var.setQueryListener(queryListener);
        }
    }

    public SubscriberList getSubscriberList() {
        return this.getServiceData().getSubscriberList();
    }

    public void addSubscriber(Subscriber sub) {
        this.getSubscriberList().add(sub);
    }

    public void removeSubscriber(Subscriber sub) {
        this.getSubscriberList().remove(sub);
    }

    public Subscriber getSubscriber(String name) {
        SubscriberList subList = this.getSubscriberList();
        int subListCnt = subList.size();
        for (int n = 0; n < subListCnt; ++n) {
            String sid;
            Subscriber sub = subList.getSubscriber(n);
            if (sub == null || (sid = sub.getSID()) == null || !sid.equals(name)) continue;
            return sub;
        }
        return null;
    }

    private boolean notify(Subscriber sub, StateVariable stateVar) {
        String varName = stateVar.getName();
        String value = stateVar.getValue();
        String host = sub.getDeliveryHost();
        int port = sub.getDeliveryPort();
        NotifyRequest notifyReq = new NotifyRequest();
        notifyReq.setRequest(sub, varName, value);
        HTTPResponse res = notifyReq.post(host, port);
        if (!res.isSuccessful()) {
            return false;
        }
        sub.incrementNotifyCount();
        return true;
    }

    public void notify(StateVariable stateVar) {
        Subscriber sub;
        int n;
        SubscriberList subList = this.getSubscriberList();
        int subListCnt = subList.size();
        Subscriber[] subs = new Subscriber[subListCnt];
        for (n = 0; n < subListCnt; ++n) {
            subs[n] = subList.getSubscriber(n);
        }
        for (n = 0; n < subListCnt; ++n) {
            sub = subs[n];
            if (sub == null || !sub.isExpired()) continue;
            this.removeSubscriber(sub);
        }
        subListCnt = subList.size();
        subs = new Subscriber[subListCnt];
        for (n = 0; n < subListCnt; ++n) {
            subs[n] = subList.getSubscriber(n);
        }
        for (n = 0; n < subListCnt; ++n) {
            sub = subs[n];
            if (sub != null && this.notify(sub, stateVar)) continue;
        }
    }

    public void notifyAllStateVariables() {
        ServiceStateTable stateTable = this.getServiceStateTable();
        int tableSize = stateTable.size();
        for (int n = 0; n < tableSize; ++n) {
            StateVariable var = stateTable.getStateVariable(n);
            if (!var.isSendEvents()) continue;
            this.notify(var);
        }
    }

    public String getSID() {
        return this.getServiceData().getSID();
    }

    public void setSID(String id) {
        this.getServiceData().setSID(id);
    }

    public void clearSID() {
        this.setSID("");
        this.setTimeout(0L);
    }

    public boolean hasSID() {
        return StringUtil.hasData(this.getSID());
    }

    public boolean isSubscribed() {
        return this.hasSID();
    }

    public long getTimeout() {
        return this.getServiceData().getTimeout();
    }

    public void setTimeout(long value) {
        this.getServiceData().setTimeout(value);
    }

    public void setActionListener(ActionListener listener) {
        ActionList actionList = this.getActionList();
        int nActions = actionList.size();
        for (int n = 0; n < nActions; ++n) {
            Action action = actionList.getAction(n);
            action.setActionListener(listener);
        }
    }

    public void addStateVariable(StateVariable var) {
        Node stateTableNode = this.getSCPDNode().getNode("serviceStateTable");
        if (stateTableNode == null) {
            stateTableNode = new Node("serviceStateTable");
            this.getSCPDNode().addNode(stateTableNode);
        }
        var.setServiceNode(this.getServiceNode());
        stateTableNode.addNode(var.getStateVariableNode());
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public Object getUserData() {
        return this.userData;
    }
}

