/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.BuildRequestRecord;
import net.i2p.data.i2np.BuildResponseRecord;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.data.i2np.TunnelBuildReplyMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.i2np.VariableTunnelBuildReplyMessage;
import net.i2p.router.HandlerJobBuilder;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.BuildMessageProcessor;
import net.i2p.router.tunnel.BuildReplyHandler;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelDispatcher;
import net.i2p.router.tunnel.pool.BuildExecutor;
import net.i2p.router.tunnel.pool.ExpireJob;
import net.i2p.router.tunnel.pool.ParticipatingThrottler;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.RequestThrottler;
import net.i2p.router.tunnel.pool.TunnelPoolManager;
import net.i2p.router.util.CDQEntry;
import net.i2p.util.Log;

class BuildHandler
implements Runnable {
    private final RouterContext _context;
    private final Log _log;
    private final TunnelPoolManager _manager;
    private final BuildExecutor _exec;
    private final Job _buildMessageHandlerJob;
    private final Job _buildReplyMessageHandlerJob;
    private final BlockingQueue<BuildMessageState> _inboundBuildMessages;
    private final BuildMessageProcessor _processor;
    private final RequestThrottler _requestThrottler;
    private final ParticipatingThrottler _throttler;
    private final BuildReplyHandler _buildReplyHandler;
    private final AtomicInteger _currentLookups = new AtomicInteger();
    private volatile boolean _isRunning;
    private static final int MIN_QUEUE = 18;
    private static final int MAX_QUEUE = 192;
    private static final int NEXT_HOP_LOOKUP_TIMEOUT = 15000;
    private static final int PRIORITY = 300;
    private static final int MIN_LOOKUP_LIMIT = 10;
    private static final int MAX_LOOKUP_LIMIT = 100;
    private static final int PERCENT_LOOKUP_LIMIT = 3;
    private static final int NEXT_HOP_SEND_TIMEOUT = 25000;

    public BuildHandler(RouterContext ctx, TunnelPoolManager manager, BuildExecutor exec) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._manager = manager;
        this._exec = exec;
        int sz = Math.min(192, Math.max(18, TunnelDispatcher.getShareBandwidth(ctx) * 18 / 48));
        this._inboundBuildMessages = new LinkedBlockingQueue<BuildMessageState>(sz);
        this._context.statManager().createRateStat("tunnel.reject.10", "How often we reject a tunnel probabalistically", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.reject.20", "How often we reject a tunnel because of transient overload", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.reject.30", "How often we reject a tunnel because of bandwidth overload", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.reject.50", "How often we reject a tunnel because of a critical issue (shutdown, etc)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRequiredRateStat("tunnel.decryptRequestTime", "Time to decrypt a build request (ms)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRequiredRateStat("tunnel.rejectTimeout", "Reject tunnel count (unknown next hop)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRequiredRateStat("tunnel.rejectTimeout2", "Reject tunnel count (can't contact next hop)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRequiredRateStat("tunnel.rejectDupID", "Part. tunnel dup ID", "Tunnels", new long[]{86400000L});
        this._context.statManager().createRequiredRateStat("tunnel.ownDupID", "Our tunnel dup. ID", "Tunnels", new long[]{86400000L});
        this._context.statManager().createRequiredRateStat("tunnel.rejectHostile", "Reject malicious tunnel", "Tunnels", new long[]{86400000L});
        this._context.statManager().createRequiredRateStat("tunnel.rejectHopThrottle", "Reject per-hop limit", "Tunnels", new long[]{3600000L});
        this._context.statManager().createRequiredRateStat("tunnel.dropReqThrottle", "Drop per-hop limit", "Tunnels", new long[]{3600000L});
        this._context.statManager().createRequiredRateStat("tunnel.dropLookupThrottle", "Drop next hop lookup", "Tunnels", new long[]{3600000L});
        this._context.statManager().createRequiredRateStat("tunnel.rejectOverloaded", "Delay to process rejected request (ms)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRequiredRateStat("tunnel.acceptLoad", "Delay to process accepted request (ms)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.dropConnLimits", "Drop instead of reject due to conn limits", "Tunnels", new long[]{600000L});
        this._context.statManager().createRateStat("tunnel.rejectConnLimits", "Reject due to conn limits", "Tunnels", new long[]{600000L});
        this._context.statManager().createRequiredRateStat("tunnel.dropLoad", "Delay before dropping request (ms)?", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRequiredRateStat("tunnel.dropLoadDelay", "Delay before abandoning request (ms)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRequiredRateStat("tunnel.dropLoadBacklog", "Pending request count when dropped", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRequiredRateStat("tunnel.dropLoadProactive", "Delay estimate when dropped (ms)", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRequiredRateStat("tunnel.dropLoadProactiveAbort", "Allowed requests during load", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildReplyTooSlow", "How often a tunnel build reply came back after we had given up waiting for it?", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.receiveRejectionProbabalistic", "How often we are rejected probabalistically?", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("tunnel.receiveRejectionTransient", "How often we are rejected due to transient overload?", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("tunnel.receiveRejectionBandwidth", "How often we are rejected due to bandwidth overload?", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("tunnel.receiveRejectionCritical", "How often we are rejected due to critical failure?", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("tunnel.corruptBuildReply", "", "Tunnels", new long[]{86400000L});
        ctx.statManager().createRateStat("tunnel.buildLookupSuccess", "Was a deferred lookup successful?", "Tunnels", new long[]{3600000L});
        this._processor = new BuildMessageProcessor(ctx);
        this._requestThrottler = new RequestThrottler(ctx);
        this._throttler = new ParticipatingThrottler(ctx);
        this._buildReplyHandler = new BuildReplyHandler(ctx);
        this._buildMessageHandlerJob = new TunnelBuildMessageHandlerJob(ctx);
        this._buildReplyMessageHandlerJob = new TunnelBuildReplyMessageHandlerJob(ctx);
        TunnelBuildMessageHandlerJobBuilder tbmhjb = new TunnelBuildMessageHandlerJobBuilder();
        TunnelBuildReplyMessageHandlerJobBuilder tbrmhjb = new TunnelBuildReplyMessageHandlerJobBuilder();
        ctx.inNetMessagePool().registerHandlerJobBuilder(21, tbmhjb);
        ctx.inNetMessagePool().registerHandlerJobBuilder(22, tbrmhjb);
        ctx.inNetMessagePool().registerHandlerJobBuilder(23, tbmhjb);
        ctx.inNetMessagePool().registerHandlerJobBuilder(24, tbrmhjb);
    }

    public void restart() {
        this._inboundBuildMessages.clear();
    }

    public synchronized void shutdown(int numThreads) {
        this._isRunning = false;
        this._inboundBuildMessages.clear();
        BuildMessageState poison = new BuildMessageState(this._context, null, null, null);
        for (int i = 0; i < numThreads; ++i) {
            this._inboundBuildMessages.offer(poison);
        }
    }

    public void run() {
        this._isRunning = true;
        while (this._isRunning && !this._manager.isShutdown()) {
            try {
                this.handleInboundRequest();
            }
            catch (Exception e) {
                this._log.log(50, "B0rked in the tunnel handler", (Throwable)e);
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Done handling");
        }
        this._isRunning = false;
    }

    private void handleInboundRequest() {
        BuildMessageState state = null;
        try {
            state = this._inboundBuildMessages.take();
        }
        catch (InterruptedException ie) {
            return;
        }
        if (state.msg == null) {
            this._isRunning = false;
            return;
        }
        long now = this._context.clock().now();
        long dropBefore = now - 3250L;
        if (state.recvTime <= dropBefore) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Not even trying to handle/decrypt the request " + state.msg.getUniqueId() + ", since we received it a long time ago: " + (now - state.recvTime));
            }
            this._context.statManager().addRateData("tunnel.dropLoadDelay", now - state.recvTime);
            this._context.throttle().setTunnelStatus(BuildHandler._x("Dropping tunnel requests: Too slow"));
            return;
        }
        this.handleRequest(state);
    }

    private void handleReply(BuildReplyMessageState state) {
        long replyMessageId = state.msg.getUniqueId();
        PooledTunnelCreatorConfig cfg = this._exec.removeFromBuilding(replyMessageId);
        if (cfg == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("The reply " + replyMessageId + " did not match any pending tunnels");
            }
            this._context.statManager().addRateData("tunnel.buildReplyTooSlow", 1L);
        } else {
            this.handleReply(state.msg, cfg, System.currentTimeMillis() - state.recvTime);
        }
    }

    private void handleReply(TunnelBuildReplyMessage msg, PooledTunnelCreatorConfig cfg, long delay) {
        List<Integer> order;
        int[] statuses;
        long requestedOn = cfg.getExpiration() - 600000L;
        long rtt = this._context.clock().now() - requestedOn;
        if (this._log.shouldLog(20)) {
            this._log.info(msg.getUniqueId() + ": Handling the reply after " + rtt + ", delayed " + delay + " waiting for " + cfg);
        }
        if ((statuses = this._buildReplyHandler.decrypt(msg, cfg, order = cfg.getReplyOrder())) != null) {
            boolean allAgree = true;
            for (int i = 0; i < cfg.getLength(); ++i) {
                Hash peer = cfg.getPeer(i);
                if (peer.equals((Object)this._context.routerHash())) continue;
                int record = order.indexOf(i);
                if (record < 0) {
                    this._log.error("Bad status index " + i);
                    this._exec.buildComplete(cfg, cfg.getTunnelPool());
                    return;
                }
                int howBad = statuses[record];
                RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
                String bwTier = "Unknown";
                if (ri != null) {
                    bwTier = ri.getBandwidthTier();
                } else if (this._log.shouldLog(30)) {
                    this._log.warn("Failed detecting bwTier, null routerInfo for: " + peer);
                }
                if (howBad == 0) {
                    this._context.statManager().addRateData("tunnel.tierAgree" + bwTier, 1L);
                } else {
                    this._context.statManager().addRateData("tunnel.tierReject" + bwTier, 1L);
                }
                if (this._log.shouldLog(20)) {
                    this._log.info(msg.getUniqueId() + ": Peer " + peer + " replied with status " + howBad);
                }
                if (howBad == 0) {
                    this._context.profileManager().tunnelJoined(peer, rtt);
                    continue;
                }
                allAgree = false;
                switch (howBad) {
                    case 30: {
                        this._context.statManager().addRateData("tunnel.receiveRejectionBandwidth", 1L);
                        break;
                    }
                    case 20: {
                        this._context.statManager().addRateData("tunnel.receiveRejectionTransient", 1L);
                        break;
                    }
                    case 10: {
                        this._context.statManager().addRateData("tunnel.receiveRejectionProbabalistic", 1L);
                        break;
                    }
                    default: {
                        this._context.statManager().addRateData("tunnel.receiveRejectionCritical", 1L);
                    }
                }
                this._context.profileManager().tunnelRejected(peer, rtt, howBad);
                this._context.messageHistory().tunnelParticipantRejected(peer, "peer rejected after " + rtt + " with " + howBad + ": " + cfg.toString());
            }
            if (allAgree) {
                boolean success = cfg.isInbound() ? this._context.tunnelDispatcher().joinInbound(cfg) : this._context.tunnelDispatcher().joinOutbound(cfg);
                if (!success) {
                    this._context.statManager().addRateData("tunnel.ownDupID", 1L);
                    this._exec.buildComplete(cfg, cfg.getTunnelPool());
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Dup ID for our own tunnel " + cfg);
                    }
                    return;
                }
                cfg.getTunnelPool().addTunnel(cfg);
                this._exec.buildComplete(cfg, cfg.getTunnelPool());
                this._exec.buildSuccessful(cfg);
                ExpireJob expireJob = new ExpireJob(this._context, cfg, cfg.getTunnelPool());
                cfg.setExpireJob(expireJob);
                this._context.jobQueue().addJob(expireJob);
                if (cfg.getDestination() == null) {
                    this._context.statManager().addRateData("tunnel.buildExploratorySuccess", rtt);
                } else {
                    this._context.statManager().addRateData("tunnel.buildClientSuccess", rtt);
                }
            } else {
                this._exec.buildComplete(cfg, cfg.getTunnelPool());
                if (cfg.getDestination() == null) {
                    this._context.statManager().addRateData("tunnel.buildExploratoryReject", rtt);
                } else {
                    this._context.statManager().addRateData("tunnel.buildClientReject", rtt);
                }
            }
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn(msg.getUniqueId() + ": Tunnel reply could not be decrypted for tunnel " + cfg);
            }
            this._context.statManager().addRateData("tunnel.corruptBuildReply", 1L);
            this._exec.buildComplete(cfg, cfg.getTunnelPool());
        }
    }

    private long handleRequest(BuildMessageState state) {
        long timeSinceReceived = this._context.clock().now() - state.recvTime;
        if (this._log.shouldLog(10)) {
            this._log.debug(state.msg.getUniqueId() + ": handling request after " + timeSinceReceived);
        }
        if (timeSinceReceived > 39000L) {
            this._context.throttle().setTunnelStatus(BuildHandler._x("Dropping tunnel requests: Overloaded"));
            if (this._log.shouldLog(30)) {
                this._log.warn("Not even trying to handle/decrypt the request " + state.msg.getUniqueId() + ", since we received it a long time ago: " + timeSinceReceived);
            }
            this._context.statManager().addRateData("tunnel.dropLoadDelay", timeSinceReceived);
            return -1L;
        }
        long beforeDecrypt = System.currentTimeMillis();
        BuildRequestRecord req = this._processor.decrypt(this._context, state.msg, this._context.routerHash(), this._context.keyManager().getPrivateKey());
        long decryptTime = System.currentTimeMillis() - beforeDecrypt;
        this._context.statManager().addRateData("tunnel.decryptRequestTime", decryptTime);
        if (decryptTime > 500L && this._log.shouldLog(30)) {
            this._log.warn("Took too long to decrypt the request: " + decryptTime + " for message " + state.msg.getUniqueId() + " received " + (timeSinceReceived + decryptTime) + " ago");
        }
        if (req == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("The request " + state.msg.getUniqueId() + " could not be decrypted");
            }
            return -1L;
        }
        long beforeLookup = System.currentTimeMillis();
        Hash nextPeer = req.readNextIdentity();
        long readPeerTime = System.currentTimeMillis() - beforeLookup;
        RouterInfo nextPeerInfo = this._context.netDb().lookupRouterInfoLocally(nextPeer);
        long lookupTime = System.currentTimeMillis() - beforeLookup;
        if (lookupTime > 500L && this._log.shouldLog(30)) {
            this._log.warn("Took too long to lookup the request: " + lookupTime + "/" + readPeerTime + " for message " + state.msg.getUniqueId() + " received " + (timeSinceReceived + decryptTime) + " ago");
        }
        if (nextPeerInfo == null) {
            int numTunnels = this._context.tunnelManager().getParticipatingCount();
            int limit = Math.max(10, Math.min(100, numTunnels * 3 / 100));
            int current = this._currentLookups.incrementAndGet();
            if (current <= limit) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Request " + state.msg.getUniqueId() + '/' + req.readReceiveTunnelId() + '/' + req.readNextTunnelId() + " handled, lookup next peer " + nextPeer + " lookups: " + current + '/' + limit);
                }
                this._context.netDb().lookupRouterInfo(nextPeer, new HandleReq(this._context, state, req, nextPeer), new TimeoutReq(this._context, state, req, nextPeer), 15000L);
            } else {
                this._currentLookups.decrementAndGet();
                if (this._log.shouldLog(30)) {
                    this._log.warn("Drop next hop lookup, limit " + limit);
                }
                this._context.statManager().addRateData("tunnel.dropLookupThrottle", 1L);
            }
            return -1L;
        }
        long beforeHandle = System.currentTimeMillis();
        this.handleReq(nextPeerInfo, state, req, nextPeer);
        long handleTime = System.currentTimeMillis() - beforeHandle;
        if (this._log.shouldLog(10)) {
            this._log.debug("Request " + state.msg.getUniqueId() + " handled and we know the next peer " + nextPeer + " after " + handleTime + "/" + decryptTime + "/" + lookupTime + "/" + timeSinceReceived);
        }
        return handleTime;
    }

    private void handleRequestAsInboundEndpoint(BuildEndMessageState state) {
        int records = state.msg.getRecordCount();
        TunnelBuildReplyMessage msg = records == 8 ? new TunnelBuildReplyMessage(this._context) : new VariableTunnelBuildReplyMessage(this._context, records);
        for (int i = 0; i < records; ++i) {
            msg.setRecord(i, state.msg.getRecord(i));
        }
        msg.setUniqueId(state.msg.getUniqueId());
        this.handleReply(msg, state.cfg, System.currentTimeMillis() - state.recvTime);
    }

    private void handleReq(RouterInfo nextPeerInfo, BuildMessageState state, BuildRequestRecord req, Hash nextPeer) {
        Hash from;
        long ourId = req.readReceiveTunnelId();
        long nextId = req.readNextTunnelId();
        boolean isInGW = req.readIsInboundGateway();
        boolean isOutEnd = req.readIsOutboundEndpoint();
        if (isInGW && isOutEnd) {
            this._context.statManager().addRateData("tunnel.rejectHostile", 1L);
            this._log.error("Dropping build request, IBGW+OBEP");
            return;
        }
        if (!isOutEnd && this._context.routerHash().equals((Object)nextPeer)) {
            this._context.statManager().addRateData("tunnel.rejectHostile", 1L);
            this._log.error("Dropping build request, we the next hop");
            return;
        }
        if (!isInGW) {
            from = state.fromHash;
            if (from == null) {
                from = state.from.calculateHash();
            }
            if (this._context.routerHash().equals((Object)from)) {
                this._context.statManager().addRateData("tunnel.rejectHostile", 1L);
                this._log.error("Dropping build request, we are the previous hop");
                return;
            }
        }
        if (!isOutEnd && !isInGW) {
            from = state.fromHash;
            if (from == null) {
                from = state.from.calculateHash();
            }
            if (nextPeer.equals((Object)from)) {
                this._context.statManager().addRateData("tunnel.rejectHostile", 1L);
                this._log.error("Dropping build request with the same previous and next hop");
                return;
            }
        }
        long time = req.readRequestTime();
        long now = this._context.clock().now() / 3600000L * 3600000L;
        int ourSlot = -1;
        int response = this._context.throttle().acceptTunnelRequest();
        long recvDelay = this._context.clock().now() - state.recvTime;
        if (response == 0) {
            float pDrop = (float)recvDelay / 39000.0f;
            pDrop = (float)Math.pow(pDrop, 16.0);
            if (this._context.random().nextFloat() < pDrop) {
                this._context.statManager().addRateData("tunnel.rejectOverloaded", recvDelay);
                this._context.throttle().setTunnelStatus(BuildHandler._x("Rejecting tunnels: Request overload"));
                response = 20;
            } else {
                this._context.statManager().addRateData("tunnel.acceptLoad", recvDelay);
            }
        }
        RouterInfo ri = this._context.router().getRouterInfo();
        if (response == 0) {
            if (ri == null) {
                response = 30;
            } else {
                char bw = ri.getBandwidthTier().charAt(0);
                if (bw != 'O' && bw != 'N' && (isInGW && !this._context.commSystem().haveInboundCapacity(87) || isOutEnd && !this._context.commSystem().haveOutboundCapacity(87))) {
                    this._context.statManager().addRateData("tunnel.rejectConnLimits", 1L);
                    this._context.throttle().setTunnelStatus(BuildHandler._x("Rejecting tunnels: Connection limit"));
                    response = 30;
                }
            }
        }
        if (response == 0 && !isInGW) {
            Hash from2 = state.fromHash;
            if (from2 == null) {
                from2 = state.from.calculateHash();
            }
            if (from2 != null && this._throttler.shouldThrottle(from2)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Rejecting tunnel (hop throttle), previous hop: " + from2);
                }
                this._context.statManager().addRateData("tunnel.rejectHopThrottle", 1L);
                response = 30;
            }
        }
        if (response == 0 && !isOutEnd && this._throttler.shouldThrottle(nextPeer)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Rejecting tunnel (hop throttle), next hop: " + nextPeer);
            }
            this._context.statManager().addRateData("tunnel.rejectHopThrottle", 1L);
            response = 30;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Responding to " + state.msg.getUniqueId() + "/" + ourId + " after " + recvDelay + " with " + response + " from " + (state.fromHash != null ? state.fromHash : (state.from != null ? state.from.calculateHash() : "tunnel")));
        }
        HopConfig cfg = null;
        if (response == 0) {
            cfg = new HopConfig();
            cfg.setCreation(this._context.clock().now());
            cfg.setExpiration(this._context.clock().now() + 600000L);
            cfg.setIVKey(req.readIVKey());
            cfg.setLayerKey(req.readLayerKey());
            if (isInGW) {
                cfg.setReceiveFrom(null);
            } else if (state.fromHash != null) {
                cfg.setReceiveFrom(state.fromHash);
            } else if (state.from != null) {
                cfg.setReceiveFrom(state.from.calculateHash());
            } else {
                return;
            }
            cfg.setReceiveTunnelId(DataHelper.toLong((int)4, (long)ourId));
            if (isOutEnd) {
                cfg.setSendTo(null);
                cfg.setSendTunnelId(null);
            } else {
                cfg.setSendTo(nextPeer);
                cfg.setSendTunnelId(DataHelper.toLong((int)4, (long)nextId));
            }
            boolean success = isOutEnd ? this._context.tunnelDispatcher().joinOutboundEndpoint(cfg) : (isInGW ? this._context.tunnelDispatcher().joinInboundGateway(cfg) : this._context.tunnelDispatcher().joinParticipant(cfg));
            if (success) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Joining " + state.msg.getUniqueId() + "/" + cfg.getReceiveTunnel() + "/" + recvDelay + " as " + (isOutEnd ? "outbound endpoint" : (isInGW ? "inbound gw" : "participant")));
                }
            } else {
                response = 30;
                this._context.statManager().addRateData("tunnel.rejectDupID", 1L);
                if (this._log.shouldLog(30)) {
                    this._log.warn("DUP ID failure " + state.msg.getUniqueId() + "/" + cfg.getReceiveTunnel() + " as " + (isOutEnd ? "outbound endpoint" : (isInGW ? "inbound gw" : "participant")));
                }
            }
        }
        if (response != 0) {
            this._context.statManager().addRateData("tunnel.reject." + response, 1L);
            this._context.messageHistory().tunnelRejected(state.fromHash, new TunnelId(ourId), nextPeer, "rejecting for " + response + ": " + state.msg.getUniqueId() + "/" + ourId + "/" + req.readNextTunnelId() + " delay " + recvDelay + " as " + (isOutEnd ? "outbound endpoint" : (isInGW ? "inbound gw" : "participant")));
        }
        if (!(response == 0 || this._context.routerHash().equals((Object)nextPeer) || this._context.commSystem().haveOutboundCapacity(81) || this._context.commSystem().isEstablished(nextPeer))) {
            this._context.statManager().addRateData("tunnel.dropConnLimits", 1L);
            if (this._log.shouldLog(30)) {
                this._log.warn("Not sending rejection due to conn limits");
            }
            return;
        }
        byte[] reply = BuildResponseRecord.create(this._context, response, req.readReplyKey(), req.readReplyIV(), state.msg.getUniqueId());
        int records = state.msg.getRecordCount();
        for (int j = 0; j < records; ++j) {
            if (state.msg.getRecord(j) != null) continue;
            ourSlot = j;
            state.msg.setRecord(j, new ByteArray(reply));
            break;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Read slot " + ourSlot + " containing our hop @ " + this._context.routerHash() + " accepted? " + response + " receiving on " + ourId + " sending to " + nextId + " on " + nextPeer + " inGW? " + isInGW + " outEnd? " + isOutEnd + " time difference " + (now - time) + " recvDelay " + recvDelay + " replyMessage " + req.readReplyMessageId() + " replyKey " + req.readReplyKey() + " replyIV " + Base64.encode((byte[])req.readReplyIV()));
        }
        if (!isOutEnd) {
            state.msg.setUniqueId(req.readReplyMessageId());
            state.msg.setMessageExpiration(this._context.clock().now() + 25000L);
            OutNetMessage msg = new OutNetMessage(this._context);
            msg.setMessage(state.msg);
            msg.setExpiration(state.msg.getMessageExpiration());
            msg.setPriority(300);
            msg.setTarget(nextPeerInfo);
            if (response == 0) {
                msg.setOnFailedSendJob(new TunnelBuildNextHopFailJob(this._context, cfg));
            }
            this._context.outNetMessagePool().add(msg);
        } else {
            TunnelBuildReplyMessage replyMsg = records == 8 ? new TunnelBuildReplyMessage(this._context) : new VariableTunnelBuildReplyMessage(this._context, records);
            for (int i = 0; i < records; ++i) {
                replyMsg.setRecord(i, state.msg.getRecord(i));
            }
            replyMsg.setUniqueId(req.readReplyMessageId());
            replyMsg.setMessageExpiration(this._context.clock().now() + 25000L);
            TunnelGatewayMessage m = new TunnelGatewayMessage(this._context);
            m.setMessage(replyMsg);
            m.setMessageExpiration(replyMsg.getMessageExpiration());
            m.setTunnelId(new TunnelId(nextId));
            if (this._context.routerHash().equals((Object)nextPeer)) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("We are the reply gateway for " + nextId + " when replying to replyMessage " + req.readReplyMessageId());
                }
                this._context.tunnelDispatcher().dispatch(m);
            } else {
                OutNetMessage outMsg = new OutNetMessage(this._context);
                outMsg.setExpiration(m.getMessageExpiration());
                outMsg.setMessage(m);
                outMsg.setPriority(300);
                outMsg.setTarget(nextPeerInfo);
                if (response == 0) {
                    outMsg.setOnFailedSendJob(new TunnelBuildNextHopFailJob(this._context, cfg));
                }
                this._context.outNetMessagePool().add(outMsg);
            }
        }
    }

    public int getInboundBuildQueueSize() {
        return this._inboundBuildMessages.size();
    }

    private static final String _x(String s) {
        return s;
    }

    private static class TunnelBuildNextHopFailJob
    extends JobImpl {
        private final HopConfig _cfg;

        private TunnelBuildNextHopFailJob(RouterContext ctx, HopConfig cfg) {
            super(ctx);
            this._cfg = cfg;
        }

        public String getName() {
            return "Timeout contacting next peer for tunnel join";
        }

        public void runJob() {
            this.getContext().tunnelDispatcher().remove(this._cfg);
            this.getContext().statManager().addRateData("tunnel.rejectTimeout2", 1L);
            Log log = this.getContext().logManager().getLog(BuildHandler.class);
            if (log.shouldLog(30)) {
                log.warn("Timeout contacting next hop for " + this._cfg);
            }
        }
    }

    private static class TunnelBuildReplyMessageHandlerJob
    extends JobImpl {
        private TunnelBuildReplyMessageHandlerJob(RouterContext ctx) {
            super(ctx);
        }

        public void runJob() {
        }

        public String getName() {
            return "Receive tunnel build reply message";
        }
    }

    private static class TunnelBuildMessageHandlerJob
    extends JobImpl {
        private TunnelBuildMessageHandlerJob(RouterContext ctx) {
            super(ctx);
        }

        public void runJob() {
        }

        public String getName() {
            return "Receive tunnel build message";
        }
    }

    private static class BuildEndMessageState {
        final TunnelBuildMessage msg;
        final PooledTunnelCreatorConfig cfg;
        final long recvTime;

        public BuildEndMessageState(PooledTunnelCreatorConfig c, I2NPMessage m) {
            this.cfg = c;
            this.msg = (TunnelBuildMessage)m;
            this.recvTime = System.currentTimeMillis();
        }
    }

    private static class BuildReplyMessageState {
        final TunnelBuildReplyMessage msg;
        final long recvTime;

        public BuildReplyMessageState(I2NPMessage m) {
            this.msg = (TunnelBuildReplyMessage)m;
            this.recvTime = System.currentTimeMillis();
        }
    }

    private static class BuildMessageState
    implements CDQEntry {
        private final RouterContext _ctx;
        final TunnelBuildMessage msg;
        final RouterIdentity from;
        final Hash fromHash;
        final long recvTime;

        public BuildMessageState(RouterContext ctx, I2NPMessage m, RouterIdentity f, Hash h) {
            this._ctx = ctx;
            this.msg = (TunnelBuildMessage)m;
            this.from = f;
            this.fromHash = h;
            this.recvTime = ctx.clock().now();
        }

        public void setEnqueueTime(long time) {
        }

        public long getEnqueueTime() {
            return this.recvTime;
        }

        public void drop() {
            this._ctx.throttle().setTunnelStatus(BuildHandler._x("Dropping tunnel requests: Queue time"));
            this._ctx.statManager().addRateData("tunnel.dropLoadProactive", this._ctx.clock().now() - this.recvTime);
        }
    }

    private class TunnelBuildReplyMessageHandlerJobBuilder
    implements HandlerJobBuilder {
        private TunnelBuildReplyMessageHandlerJobBuilder() {
        }

        public Job createJob(I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
            if (BuildHandler.this._log.shouldLog(10)) {
                BuildHandler.this._log.debug("Receive tunnel build reply message " + receivedMessage.getUniqueId() + " from " + (fromHash != null ? fromHash : (from != null ? from.calculateHash() : "a tunnel")));
            }
            BuildHandler.this.handleReply(new BuildReplyMessageState(receivedMessage));
            return BuildHandler.this._buildReplyMessageHandlerJob;
        }
    }

    private class TunnelBuildMessageHandlerJobBuilder
    implements HandlerJobBuilder {
        private TunnelBuildMessageHandlerJobBuilder() {
        }

        public Job createJob(I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
            long reqId = receivedMessage.getUniqueId();
            PooledTunnelCreatorConfig cfg = BuildHandler.this._exec.removeFromBuilding(reqId);
            if (BuildHandler.this._log.shouldLog(10)) {
                BuildHandler.this._log.debug("Receive tunnel build message " + reqId + " from " + (from != null ? from.calculateHash() : (fromHash != null ? fromHash : "tunnels")) + ", found matching tunnel? " + (cfg != null));
            }
            if (cfg != null) {
                if (!cfg.isInbound()) {
                    BuildHandler.this._log.error("received it, but its not inbound? " + cfg);
                }
                BuildEndMessageState state = new BuildEndMessageState(cfg, receivedMessage);
                BuildHandler.this.handleRequestAsInboundEndpoint(state);
            } else if (BuildHandler.this._exec.wasRecentlyBuilding(reqId)) {
                if (BuildHandler.this._log.shouldLog(30)) {
                    BuildHandler.this._log.warn("Dropping the reply " + reqId + ", as we used to be building that");
                }
                BuildHandler.this._context.statManager().addRateData("tunnel.buildReplyTooSlow", 1L);
            } else {
                long age;
                int sz = BuildHandler.this._inboundBuildMessages.size();
                BuildMessageState cur = (BuildMessageState)BuildHandler.this._inboundBuildMessages.peek();
                boolean accept = true;
                if (cur != null && (age = BuildHandler.this._context.clock().now() - cur.recvTime) >= 3250L) {
                    BuildHandler.this._context.statManager().addRateData("tunnel.dropLoad", age, (long)sz);
                    BuildHandler.this._context.throttle().setTunnelStatus(BuildHandler._x("Dropping tunnel requests: High load"));
                    accept = false;
                }
                if (accept) {
                    Hash fh = fromHash;
                    if (fh == null && from != null) {
                        fh = from.calculateHash();
                    }
                    if (fh != null && BuildHandler.this._requestThrottler.shouldThrottle(fh)) {
                        if (BuildHandler.this._log.shouldLog(30)) {
                            BuildHandler.this._log.warn("Dropping tunnel request (from throttle), previous hop: " + from);
                        }
                        BuildHandler.this._context.statManager().addRateData("tunnel.dropReqThrottle", 1L);
                        accept = false;
                    }
                }
                if (accept) {
                    accept = BuildHandler.this._inboundBuildMessages.offer(new BuildMessageState(BuildHandler.this._context, receivedMessage, from, fromHash));
                    if (accept) {
                        BuildHandler.this._exec.repoll();
                    } else {
                        BuildHandler.this._context.throttle().setTunnelStatus(BuildHandler._x("Dropping tunnel requests: High load"));
                        BuildHandler.this._context.statManager().addRateData("tunnel.dropLoadBacklog", (long)sz);
                    }
                }
            }
            return BuildHandler.this._buildMessageHandlerJob;
        }
    }

    private class TimeoutReq
    extends JobImpl {
        private final BuildMessageState _state;
        private final BuildRequestRecord _req;
        private final Hash _nextPeer;

        TimeoutReq(RouterContext ctx, BuildMessageState state, BuildRequestRecord req, Hash nextPeer) {
            super(ctx);
            this._state = state;
            this._req = req;
            this._nextPeer = nextPeer;
        }

        public String getName() {
            return "Timeout looking for next peer for tunnel join";
        }

        public void runJob() {
            BuildHandler.this._currentLookups.decrementAndGet();
            this.getContext().statManager().addRateData("tunnel.rejectTimeout", 1L);
            this.getContext().statManager().addRateData("tunnel.buildLookupSuccess", 0L);
            this.getContext().messageHistory().tunnelRejected(this._state.fromHash, new TunnelId(this._req.readReceiveTunnelId()), this._nextPeer, "rejected because we couldn't find " + this._nextPeer + ": " + this._state.msg.getUniqueId() + "/" + this._req.readNextTunnelId());
        }
    }

    private class HandleReq
    extends JobImpl {
        private final BuildMessageState _state;
        private final BuildRequestRecord _req;
        private final Hash _nextPeer;

        HandleReq(RouterContext ctx, BuildMessageState state, BuildRequestRecord req, Hash nextPeer) {
            super(ctx);
            this._state = state;
            this._req = req;
            this._nextPeer = nextPeer;
        }

        public String getName() {
            return "Deferred tunnel join processing";
        }

        public void runJob() {
            RouterInfo ri;
            BuildHandler.this._currentLookups.decrementAndGet();
            if (BuildHandler.this._log.shouldLog(10)) {
                BuildHandler.this._log.debug("Request " + this._state.msg.getUniqueId() + " handled with a successful deferred lookup for the next peer " + this._nextPeer);
            }
            if ((ri = this.getContext().netDb().lookupRouterInfoLocally(this._nextPeer)) != null) {
                BuildHandler.this.handleReq(ri, this._state, this._req, this._nextPeer);
                this.getContext().statManager().addRateData("tunnel.buildLookupSuccess", 1L);
            } else {
                if (BuildHandler.this._log.shouldLog(30)) {
                    BuildHandler.this._log.warn("Deferred successfully, but we couldnt find " + this._nextPeer);
                }
                this.getContext().statManager().addRateData("tunnel.buildLookupSuccess", 0L);
            }
        }
    }
}

