/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.Arrays;
import java.util.List;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.PendingGatewayMessage;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TrivialPreprocessor
implements TunnelGateway.QueuePreprocessor {
    protected final RouterContext _context;
    protected final Log _log;
    public static final int PREPROCESSED_SIZE = 1024;
    protected static final int IV_SIZE = 16;
    protected static final ByteCache _dataCache = ByteCache.getInstance((int)32, (int)1024);
    private static final byte MASK_IS_SUBSEQUENT = -128;
    private static final byte MASK_FRAGMENTED = 8;
    private static final byte MASK_EXTENDED = 4;
    private static final byte MASK_TUNNEL = 32;
    private static final byte MASK_ROUTER = 64;

    public TrivialPreprocessor(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
    }

    @Override
    public long getDelayAmount() {
        return 0L;
    }

    @Override
    public boolean preprocessQueue(List<PendingGatewayMessage> pending, TunnelGateway.Sender sender, TunnelGateway.Receiver rec) {
        throw new IllegalArgumentException("unused, right?");
    }

    protected void notePreprocessing(long messageId, int numFragments, int totalLength, List<Long> messageIds, String msg) {
    }

    protected void preprocess(byte[] fragments, int fragmentLength) {
        byte[] iv = SimpleByteCache.acquire((int)16);
        this._context.random().nextBytes(iv);
        System.arraycopy(iv, 0, fragments, fragmentLength, 16);
        byte[] hashBuf = SimpleByteCache.acquire((int)32);
        this._context.sha().calculateHash(fragments, 0, fragmentLength + 16, hashBuf, 0);
        int distance = 1024 - fragmentLength;
        System.arraycopy(fragments, 0, fragments, distance, fragmentLength);
        Arrays.fill(fragments, 0, distance, (byte)0);
        int offset = 0;
        System.arraycopy(iv, 0, fragments, offset, 16);
        System.arraycopy(hashBuf, 0, fragments, offset += 16, 4);
        offset += 4;
        SimpleByteCache.release((byte[])hashBuf);
        SimpleByteCache.release((byte[])iv);
        int numPadBytes = 1003 - fragmentLength;
        if (numPadBytes > 0) {
            this.fillRandomNonZero(fragments, offset, numPadBytes);
            offset += numPadBytes;
        }
        fragments[offset] = 0;
        ++offset;
        if (this._log.shouldLog(10)) {
            this._log.debug("Preprocessing beginning of the fragment instructions at " + offset);
        }
    }

    private void fillRandomNonZero(byte[] b, int off, int len) {
        int est = len + len / 128 + 3;
        byte[] tmp = new byte[est];
        this._context.random().nextBytes(tmp);
        int extra = len;
        for (int i = 0; i < len; ++i) {
            while (tmp[i] == 0) {
                if (extra < est) {
                    tmp[i] = tmp[extra++];
                    continue;
                }
                tmp[i] = (byte)(this._context.random().nextInt() & 0xFF);
            }
        }
        System.arraycopy(tmp, 0, b, off, len);
    }

    protected int writeFirstFragment(PendingGatewayMessage msg, byte[] target, int offset) {
        boolean fragmented = false;
        int instructionsLength = this.getInstructionsSize(msg);
        int payloadLength = msg.getData().length - msg.getOffset();
        if (offset + payloadLength + instructionsLength + 16 + 1 + 4 > 1024) {
            fragmented = true;
            payloadLength = 1003 - (instructionsLength += 4) - offset;
            if (payloadLength <= 0) {
                throw new RuntimeException("Fragment too small! payloadLen=" + payloadLength + " target.length=" + target.length + " offset=" + offset + " msg.length=" + msg.getData().length + " msg.offset=" + msg.getOffset() + " instructionsLength=" + instructionsLength + " for " + msg);
            }
        }
        if (payloadLength <= 0) {
            throw new RuntimeException("Full size too small! payloadLen=" + payloadLength + " target.length=" + target.length + " offset=" + offset + " msg.length=" + msg.getData().length + " msg.offset=" + msg.getOffset() + " instructionsLength=" + instructionsLength + " for " + msg);
        }
        target[offset] = 0;
        if (msg.getToTunnel() != null) {
            int n = offset;
            target[n] = (byte)(target[n] | 0x20);
        } else if (msg.getToRouter() != null) {
            int n = offset;
            target[n] = (byte)(target[n] | 0x40);
        }
        if (fragmented) {
            int n = offset;
            target[n] = (byte)(target[n] | 8);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("CONTROL: " + Integer.toHexString(target[offset]));
        }
        ++offset;
        if (msg.getToTunnel() != null) {
            DataHelper.toLong((byte[])target, (int)offset, (int)4, (long)msg.getToTunnel().getTunnelId());
            offset += 4;
        }
        if (msg.getToRouter() != null) {
            System.arraycopy(msg.getToRouter().getData(), 0, target, offset, 32);
            offset += 32;
        }
        if (fragmented) {
            DataHelper.toLong((byte[])target, (int)offset, (int)4, (long)msg.getMessageId());
            if (this._log.shouldLog(10)) {
                this._log.debug("writing messageId= " + msg.getMessageId() + " at offset " + offset);
            }
            offset += 4;
        }
        DataHelper.toLong((byte[])target, (int)offset, (int)2, (long)payloadLength);
        System.arraycopy(msg.getData(), msg.getOffset(), target, offset += 2, payloadLength);
        if (this._log.shouldLog(10)) {
            this._log.debug("initial fragment[" + msg.getMessageId() + "/" + msg.getFragmentNumber() + "/" + (1024 - offset - payloadLength) + "/" + payloadLength + "]: ");
        }
        offset += payloadLength;
        msg.setOffset(msg.getOffset() + payloadLength);
        if (fragmented) {
            msg.incrementFragmentNumber();
        }
        return offset;
    }

    protected int writeSubsequentFragment(PendingGatewayMessage msg, byte[] target, int offset) {
        boolean isLast = true;
        int instructionsLength = this.getInstructionsSize(msg);
        int payloadLength = msg.getData().length - msg.getOffset();
        if (payloadLength + instructionsLength + 16 + 1 + 4 > 1024) {
            isLast = false;
            payloadLength = 1003 - instructionsLength;
        }
        target[offset] = 0;
        int n = offset;
        target[n] = (byte)(target[n] | 0xFFFFFF80);
        int n2 = offset;
        target[n2] = (byte)(target[n2] | (byte)(msg.getFragmentNumber() << 1));
        if (isLast) {
            int n3 = offset;
            target[n3] = (byte)(target[n3] | 1);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("CONTROL: " + Integer.toHexString(target[offset]) + "/" + Base64.encode((byte[])target, (int)offset, (int)1) + " at offset " + offset);
        }
        DataHelper.toLong((byte[])target, (int)(++offset), (int)4, (long)msg.getMessageId());
        DataHelper.toLong((byte[])target, (int)(offset += 4), (int)2, (long)payloadLength);
        System.arraycopy(msg.getData(), msg.getOffset(), target, offset += 2, payloadLength);
        if (this._log.shouldLog(10)) {
            this._log.debug("subsequent fragment[" + msg.getMessageId() + "/" + msg.getFragmentNumber() + "/" + offset + "/" + payloadLength + "]: ");
        }
        offset += payloadLength;
        if (!isLast) {
            msg.incrementFragmentNumber();
        }
        msg.setOffset(msg.getOffset() + payloadLength);
        return offset;
    }

    protected int getInstructionsSize(PendingGatewayMessage msg) {
        if (msg.getFragmentNumber() > 0) {
            return 7;
        }
        int header = 1;
        if (msg.getToTunnel() != null) {
            header += 4;
        }
        if (msg.getToRouter() != null) {
            header += 32;
        }
        return header += 2;
    }

    protected int getInstructionAugmentationSize(PendingGatewayMessage msg, int offset, int instructionsSize) {
        int payloadLength = msg.getData().length - msg.getOffset();
        if (offset + payloadLength + instructionsSize + 16 + 1 + 4 > 1024) {
            return 4;
        }
        return 0;
    }
}

