/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class GracefulShutdown
implements Runnable {
    private final RouterContext _context;

    public GracefulShutdown(RouterContext ctx) {
        this._context = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Log log = this._context.logManager().getLog(Router.class);
        while (true) {
            boolean shutdown;
            if (shutdown = this._context.router().gracefulShutdownInProgress()) {
                int gracefulExitCode = this._context.router().scheduledGracefulExitCode();
                if (gracefulExitCode == 3 || gracefulExitCode == 4 || this._context.tunnelManager().getParticipatingCount() <= 0) {
                    if (gracefulExitCode == 3) {
                        log.log(50, "Shutting down after a brief delay");
                    } else if (gracefulExitCode == 4) {
                        log.log(50, "Restarting after a brief delay");
                    } else {
                        log.log(50, "Graceful shutdown progress - no more tunnels, safe to die");
                    }
                    try {
                        Thread thread = Thread.currentThread();
                        synchronized (thread) {
                            Thread.currentThread().wait(2000L);
                        }
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    this._context.router().shutdown(gracefulExitCode);
                    return;
                }
                try {
                    Thread ie = Thread.currentThread();
                    synchronized (ie) {
                        Thread.currentThread().wait(10000L);
                    }
                }
                catch (InterruptedException ie) {}
                continue;
            }
            try {
                Thread gracefulExitCode = Thread.currentThread();
                synchronized (gracefulExitCode) {
                    Thread.currentThread().wait();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

